/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.resourcepackmanager.utils;

import org.bukkit.Bukkit;

public class ServerVersionHelper {
    private static final int majorVersion;
    private static final int minorVersion;
    private static final boolean supportsMultipleResourcePacks;

    private static int getRevision(String version) {
        String[] parts = version.split("-")[0].split("\\.");
        if (parts.length >= 3) {
            try {
                return Integer.parseInt(parts[2]);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return 0;
    }

    public static boolean supportsMultipleResourcePacks() {
        return supportsMultipleResourcePacks;
    }

    public static int getMajorVersion() {
        return majorVersion;
    }

    public static int getMinorVersion() {
        return minorVersion;
    }

    static {
        String version = Bukkit.getBukkitVersion();
        String[] parts = version.split("-")[0].split("\\.");
        majorVersion = Integer.parseInt(parts[0]);
        minorVersion = Integer.parseInt(parts[1]);
        supportsMultipleResourcePacks = majorVersion > 1 || majorVersion == 1 && minorVersion >= 20 && ServerVersionHelper.getRevision(version) >= 3;
    }
}

