/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.resourcepackmanager.thirdparty;

import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.Logger;
import com.magmaguy.magmacore.util.ZipFile;
import com.magmaguy.resourcepackmanager.ResourcePackManager;
import com.magmaguy.resourcepackmanager.config.DefaultConfig;
import com.magmaguy.resourcepackmanager.config.compatibleplugins.CompatiblePluginConfigFields;
import com.magmaguy.resourcepackmanager.mixer.Mix;
import com.magmaguy.resourcepackmanager.org.apache.hc.client5.http.classic.methods.HttpGet;
import com.magmaguy.resourcepackmanager.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import com.magmaguy.resourcepackmanager.org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import com.magmaguy.resourcepackmanager.org.apache.hc.client5.http.impl.classic.HttpClients;
import com.magmaguy.resourcepackmanager.org.apache.hc.core5.http.HttpEntity;
import com.magmaguy.resourcepackmanager.thirdparty.GeneratorInterface;
import com.magmaguy.resourcepackmanager.utils.SHA1Generator;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.HashSet;
import java.util.Objects;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class ThirdPartyResourcePack
implements GeneratorInterface {
    public static HashSet<ThirdPartyResourcePack> thirdPartyResourcePacks = new HashSet();
    private final String pluginName;
    private final String mixerFilename;
    private final String localPath;
    private final String url;
    private File file = null;
    private boolean encrypts;
    private boolean distributes;
    private boolean zips;
    private boolean cluster;
    private String reloadCommand;
    private boolean isEnabled;
    private String SHA1;
    private File mixerResourcePack = null;
    private int priority = -1;
    private boolean done = false;
    private int ticksWithoutChange = 0;
    private boolean consideredStable = false;
    private boolean stableResourcePackSent = false;
    private static BukkitTask resourcePackChangeWatcher = null;

    public ThirdPartyResourcePack(String pluginName, String localPath, String url, boolean encrypts, boolean distributes, boolean zips, boolean cluster, String reloadCommand) {
        String existingMixerSHA1;
        File existingMixerFile;
        this.pluginName = pluginName;
        this.mixerFilename = pluginName + "_resource_pack.zip";
        this.url = url;
        this.localPath = localPath;
        this.isEnabled = Bukkit.getPluginManager().isPluginEnabled(pluginName);
        if (!this.isEnabled) {
            this.done = true;
            return;
        }
        if (localPath != null && !this.processLocal(localPath)) {
            this.done = true;
            return;
        }
        if (localPath == null && url == null) {
            Logger.warn("Plugin " + pluginName + " has no resource pack path specified! ResourcePackManager will not be able to merge the resource pack from this plugin.");
            this.isEnabled = false;
            this.done = true;
            return;
        }
        this.encrypts = encrypts;
        this.distributes = distributes;
        this.reloadCommand = reloadCommand;
        this.zips = zips;
        this.cluster = cluster;
        if (cluster) {
            this.processCluster();
        } else if (!zips) {
            this.zipThirdPartyPack();
        }
        if (localPath != null && !cluster) {
            this.SHA1 = this.getSHA1(this.file);
        }
        if (!cluster && localPath != null && (existingMixerFile = this.getTarget().toFile()).exists() && Objects.equals(this.SHA1, existingMixerSHA1 = this.getSHA1(existingMixerFile))) {
            this.consideredStable = true;
        }
        if (!cluster) {
            this.process();
        }
        if (DefaultConfig.getPriorityOrder().contains(pluginName)) {
            this.priority = DefaultConfig.getPriorityOrder().indexOf(pluginName);
        }
        thirdPartyResourcePacks.add(this);
        this.done = true;
    }

    public static void startResourcePackChangeWatchdog() {
        resourcePackChangeWatcher = new BukkitRunnable(){

            public void run() {
                boolean readyToSend = true;
                boolean stableAlreadySent = true;
                for (ThirdPartyResourcePack thirdPartyResourcePack : thirdPartyResourcePacks) {
                    if (!thirdPartyResourcePack.isEnabled || thirdPartyResourcePack.file == null) continue;
                    if (!Objects.equals(thirdPartyResourcePack.getSHA1(thirdPartyResourcePack.file), thirdPartyResourcePack.SHA1)) {
                        thirdPartyResourcePack.ticksWithoutChange = 0;
                        thirdPartyResourcePack.SHA1 = thirdPartyResourcePack.getSHA1(thirdPartyResourcePack.file);
                        if (thirdPartyResourcePack.consideredStable) {
                            thirdPartyResourcePack.consideredStable = false;
                            thirdPartyResourcePack.stableResourcePackSent = false;
                            Logger.info("Resource pack for " + thirdPartyResourcePack.pluginName + " has changed, considering it unstable.");
                        }
                    }
                    if (!thirdPartyResourcePack.stableResourcePackSent) {
                        stableAlreadySent = false;
                    }
                    if (!thirdPartyResourcePack.consideredStable) {
                        readyToSend = false;
                    }
                    if (thirdPartyResourcePack.consideredStable) continue;
                    ++thirdPartyResourcePack.ticksWithoutChange;
                    if (thirdPartyResourcePack.ticksWithoutChange != 3) continue;
                    thirdPartyResourcePack.consideredStable = true;
                    Logger.info("Resource pack for " + thirdPartyResourcePack.pluginName + " has not changed for 3 seconds, considering it stable.");
                }
                if (!stableAlreadySent && readyToSend) {
                    ThirdPartyResourcePack.notifyResourcePackSending();
                    ThirdPartyResourcePack.tagAsResourcePackSent();
                    new BukkitRunnable(){

                        public void run() {
                            Logger.info("Sending resource pack now.");
                            Mix.mixResourcePacks();
                        }
                    }.runTaskLaterAsynchronously((Plugin)ResourcePackManager.plugin, 100L);
                }
            }
        }.runTaskTimerAsynchronously((Plugin)ResourcePackManager.plugin, 20L, 20L);
    }

    public static void tagAsResourcePackSent() {
        for (ThirdPartyResourcePack thirdPartyResourcePack : thirdPartyResourcePacks) {
            thirdPartyResourcePack.stableResourcePackSent = true;
        }
    }

    private static void notifyResourcePackSending() {
        String message = "&eAll resource packs are stable. Resource pack will be sent in 5 seconds.";
        Logger.info("All resource packs are stable. Resource pack will be sent in 5 seconds.");
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.isOp()) continue;
            player.sendMessage(ChatColorConverter.convert(message));
        }
    }

    public static void shutdown() {
        thirdPartyResourcePacks.clear();
        resourcePackChangeWatcher.cancel();
    }

    public static void initializeThirdPartyResourcePack(CompatiblePluginConfigFields compatiblePluginConfigFields) {
        new ThirdPartyResourcePack(compatiblePluginConfigFields.getPluginName(), compatiblePluginConfigFields.getLocalPath(), compatiblePluginConfigFields.getUrl(), compatiblePluginConfigFields.isEncrypts(), compatiblePluginConfigFields.isDistributes(), compatiblePluginConfigFields.isZips(), compatiblePluginConfigFields.isCluster(), compatiblePluginConfigFields.getReloadCommand());
    }

    private void zipThirdPartyPack() {
        ZipFile.zip(this.file, this.getTarget().toString());
        this.mixerResourcePack = this.file = new File(this.getTarget().toUri());
    }

    private void processCluster() {
        if (!this.file.isDirectory()) {
            Logger.warn("Cluster path for " + this.pluginName + " is not a directory: " + this.file.getPath());
            this.isEnabled = false;
            return;
        }
        File[] clusterContents = this.file.listFiles();
        if (clusterContents == null || clusterContents.length == 0) {
            Logger.warn("Cluster directory for " + this.pluginName + " is empty: " + this.file.getPath());
            this.isEnabled = false;
            return;
        }
        File mixerDir = new File(ResourcePackManager.plugin.getDataFolder().toString() + File.separatorChar + "mixer");
        if (!mixerDir.exists()) {
            mixerDir.mkdir();
        }
        Logger.info("Processing cluster for " + this.pluginName + " with " + clusterContents.length + " resource packs");
        for (File resourcePackFolder : clusterContents) {
            if (!resourcePackFolder.isDirectory()) {
                Logger.info("Skipping non-directory in cluster: " + resourcePackFolder.getName());
                continue;
            }
            File[] resourcePackContents = resourcePackFolder.listFiles();
            if (resourcePackContents == null) continue;
            for (File contentFolder : resourcePackContents) {
                if (!contentFolder.isDirectory()) continue;
                File targetFolder = new File(mixerDir.getPath() + File.separatorChar + contentFolder.getName());
                try {
                    this.recursivelyCloneDirectory(contentFolder, targetFolder);
                    Logger.info("Copied " + contentFolder.getName() + " from " + resourcePackFolder.getName() + " to mixer folder");
                }
                catch (Exception e) {
                    Logger.warn("Failed to copy " + contentFolder.getPath() + " to mixer folder");
                    e.printStackTrace();
                }
            }
        }
        this.isEnabled = false;
        Logger.info("Finished processing cluster for " + this.pluginName);
    }

    private void recursivelyCloneDirectory(File source, File target) {
        block6: {
            block5: {
                File[] files;
                if (!source.isDirectory()) break block5;
                if (!target.exists()) {
                    target.mkdir();
                }
                if ((files = source.listFiles()) == null) break block6;
                for (File child : files) {
                    this.recursivelyCloneDirectory(child, new File(target.getPath() + File.separatorChar + child.getName()));
                }
                break block6;
            }
            try {
                if (target.exists()) {
                    Mix.resolveFileCollision(source, target);
                }
                Files.copy(source.toPath(), target.toPath(), new CopyOption[0]);
            }
            catch (Exception e) {
                Logger.warn("Failed to copy file " + source.getPath() + " to " + target.getPath());
            }
        }
    }

    private boolean processLocal(String localPath) {
        this.file = new File(ResourcePackManager.plugin.getDataFolder().getParentFile().toPath().toString() + File.separatorChar + localPath);
        if (!this.file.exists()) {
            Logger.warn("Found " + this.pluginName + " but could not find resource pack at location " + this.file.getPath() + " ! ResourcePackManager will not be able to merge the resource pack from this plugin.");
            this.isEnabled = false;
            return false;
        }
        return true;
    }

    public void process() {
        if (!this.isEnabled) {
            return;
        }
        if (this.localPath != null && this.mixerCloneExists()) {
            if (this.getSHA1(new File(this.getTarget().toUri())).equals(this.SHA1)) {
                this.mixerResourcePack = this.getTarget().toFile();
                return;
            }
            Logger.info("Clearing outdated resource pack in " + String.valueOf(this.getTarget()));
            this.getTarget().toFile().delete();
        }
        if (this.encrypts) {
            this.decrypt();
        }
        if (this.distributes) {
            this.unpublish();
        }
        this.cloneResourcePackFile();
    }

    private String getSHA1(File file) {
        try {
            return SHA1Generator.sha1CodeString(file);
        }
        catch (Exception e) {
            Logger.warn("Failed to generate SHA1 for " + file.getAbsolutePath());
            return null;
        }
    }

    @Override
    public void decrypt() {
    }

    @Override
    public void unpublish() {
    }

    @Override
    public void cloneResourcePackFile() {
        if (this.localPath != null) {
            this.cloneLocalRSP();
        } else {
            this.cloneRemoteRSP();
        }
    }

    private void cloneLocalRSP() {
        try {
            if (this.zips) {
                File mixerFolder = new File(ResourcePackManager.plugin.getDataFolder().toString(), "mixer");
                if (!mixerFolder.exists()) {
                    mixerFolder.mkdirs();
                }
                Logger.info("Cloning resource pack from " + String.valueOf(this.file.toPath()));
                this.mixerResourcePack = Files.copy(Path.of(this.file.getAbsolutePath(), new String[0]), Path.of(this.getTarget().toAbsolutePath().toString(), new String[0]), StandardCopyOption.REPLACE_EXISTING).toFile();
            }
        }
        catch (Exception e) {
            Logger.warn("Failed to clone resource pack from " + this.file.getPath() + " to the mixer folder!");
            e.printStackTrace();
        }
    }

    public void cloneRemoteRSP() {
        block32: {
            Logger.info("Getting resource pack from remote URL! This is not ideal but not optional for some plugins. URL: " + this.url);
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                HttpGet httpGet = new HttpGet(this.url);
                try (CloseableHttpResponse response = httpClient.execute(httpGet);){
                    int statusCode = response.getCode();
                    Logger.info("Response status code: " + statusCode);
                    if (statusCode == 200) {
                        HttpEntity responseEntity = response.getEntity();
                        if (responseEntity != null) {
                            File zipFile = this.getTarget().toFile();
                            if (zipFile.exists()) {
                                Logger.info("Target file exists, deleting it: " + zipFile.getAbsolutePath());
                                zipFile.delete();
                            }
                            zipFile.createNewFile();
                            try (BufferedInputStream inStream = new BufferedInputStream(responseEntity.getContent());
                                 FileOutputStream outStream = new FileOutputStream(zipFile);){
                                int bytesRead;
                                byte[] buffer = new byte[4096];
                                while ((bytesRead = ((InputStream)inStream).read(buffer)) != -1) {
                                    outStream.write(buffer, 0, bytesRead);
                                }
                                Logger.info("Successfully downloaded the resource pack to " + zipFile.getAbsolutePath());
                                break block32;
                            }
                            catch (Exception e) {
                                Logger.warn("Failed to write resource pack from remote!");
                            }
                            break block32;
                        }
                        Logger.warn("Response entity is null");
                        break block32;
                    }
                    Logger.warn("Unexpected response status: " + statusCode);
                }
                catch (Exception e) {
                    Logger.warn("Failed to communicate with remote server when downloading resource pack for plugin " + this.pluginName + "!");
                }
            }
            catch (Exception e) {
                Logger.warn("Failed to connect to url " + this.url + " to download resource pack for plugin " + this.pluginName);
            }
        }
    }

    @Override
    public void reload() {
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)this.reloadCommand);
    }

    private boolean mixerCloneExists() {
        return Files.exists(this.getTarget(), new LinkOption[0]);
    }

    private Path getTarget() {
        return Path.of(ResourcePackManager.plugin.getDataFolder().toString(), "mixer", this.mixerFilename);
    }

    @Generated
    public String getPluginName() {
        return this.pluginName;
    }

    @Generated
    public String getMixerFilename() {
        return this.mixerFilename;
    }

    @Generated
    public File getFile() {
        return this.file;
    }

    @Generated
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Generated
    public File getMixerResourcePack() {
        return this.mixerResourcePack;
    }

    @Generated
    public int getPriority() {
        return this.priority;
    }

    @Generated
    public boolean isDone() {
        return this.done;
    }

    @Generated
    public void setStableResourcePackSent(boolean stableResourcePackSent) {
        this.stableResourcePackSent = stableResourcePackSent;
    }
}

