/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.resourcepackmanager.org.apache.hc.core5.http2.impl.nio;

import com.magmaguy.resourcepackmanager.org.apache.hc.core5.annotation.Contract;
import com.magmaguy.resourcepackmanager.org.apache.hc.core5.annotation.Internal;
import com.magmaguy.resourcepackmanager.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.magmaguy.resourcepackmanager.org.apache.hc.core5.concurrent.FutureCallback;
import com.magmaguy.resourcepackmanager.org.apache.hc.core5.http2.impl.nio.ClientH2PrefaceHandler;
import com.magmaguy.resourcepackmanager.org.apache.hc.core5.http2.impl.nio.ClientH2StreamMultiplexerFactory;
import com.magmaguy.resourcepackmanager.org.apache.hc.core5.reactor.ProtocolIOSession;
import com.magmaguy.resourcepackmanager.org.apache.hc.core5.reactor.ProtocolUpgradeHandler;
import com.magmaguy.resourcepackmanager.org.apache.hc.core5.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
@Internal
public class ClientH2UpgradeHandler
implements ProtocolUpgradeHandler {
    private final ClientH2StreamMultiplexerFactory http2StreamHandlerFactory;

    public ClientH2UpgradeHandler(ClientH2StreamMultiplexerFactory http2StreamHandlerFactory) {
        this.http2StreamHandlerFactory = Args.notNull(http2StreamHandlerFactory, "HTTP/2 stream handler factory");
    }

    @Override
    public void upgrade(ProtocolIOSession ioSession, FutureCallback<ProtocolIOSession> callback) {
        ClientH2PrefaceHandler protocolNegotiator = new ClientH2PrefaceHandler(ioSession, this.http2StreamHandlerFactory, true, callback);
        ioSession.upgrade(protocolNegotiator);
        try {
            protocolNegotiator.connected(ioSession);
        }
        catch (IOException ex) {
            protocolNegotiator.exception(ioSession, ex);
        }
    }
}

