/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.resourcepackmanager.mixer;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.Strictness;
import com.google.gson.stream.JsonReader;
import com.magmaguy.magmacore.util.Logger;
import com.magmaguy.magmacore.util.ZipFile;
import com.magmaguy.resourcepackmanager.ResourcePackManager;
import com.magmaguy.resourcepackmanager.api.ResourcePackManagerAPI;
import com.magmaguy.resourcepackmanager.autohost.AutoHost;
import com.magmaguy.resourcepackmanager.config.DefaultConfig;
import com.magmaguy.resourcepackmanager.thirdparty.ThirdPartyResourcePack;
import com.magmaguy.resourcepackmanager.utils.SHA1Generator;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Mix {
    private static final String resourcePackName = "ResourcePackManager_RSP";
    private static List<File> resourcePacks;
    private static List<String> orderedResourcePacks;
    private static File finalResourcePack;
    private static String finalSHA1;
    private static byte[] finalSHA1Bytes;
    private static File mixerFolder;

    private Mix() {
    }

    public static void mixResourcePacksAsync() {
        new BukkitRunnable(){

            public void run() {
                Mix.mixResourcePacks();
            }
        }.runTaskAsynchronously((Plugin)ResourcePackManager.plugin);
    }

    public static void mixResourcePacks() {
        if (!Mix.initializeDefaultPluginFolders()) {
            return;
        }
        Mix.initializeThirdPartyResourcePacks();
        Mix.cloneToOutputAndUnzip();
        Mix.createOutputDefaultElements();
        AutoHost.initialize();
    }

    private static boolean initializeDefaultPluginFolders() {
        try {
            File outputFolder;
            mixerFolder = new File(ResourcePackManager.plugin.getDataFolder().getAbsolutePath() + File.separatorChar + "mixer");
            if (!mixerFolder.exists()) {
                mixerFolder.mkdir();
            }
            if (!(outputFolder = Mix.getOutputFolder()).exists()) {
                outputFolder.mkdir();
            }
            return true;
        }
        catch (Exception e) {
            Logger.warn("Failed to create default plugin folders! Check the OS permissions on the plugin's configuration folder.");
            return false;
        }
    }

    private static void initializeThirdPartyResourcePacks() {
        orderedResourcePacks = new ArrayList<String>();
        ArrayList<ThirdPartyResourcePack> resourcePackManagers = new ArrayList<ThirdPartyResourcePack>(ThirdPartyResourcePack.thirdPartyResourcePacks.stream().toList());
        resourcePackManagers.addAll(ResourcePackManagerAPI.thirdPartyResourcePackHashMap.values());
        ArrayList tempList = new ArrayList();
        resourcePackManagers.stream().filter(ThirdPartyResourcePack::isEnabled).forEach(tempList::add);
        resourcePacks = new ArrayList<File>();
        ArrayList<File> customFiles = new ArrayList<File>();
        ArrayList thirdPartyFiles = new ArrayList();
        tempList.forEach(rsp -> {
            File mixerPack = rsp.getMixerResourcePack();
            if (mixerPack != null) {
                thirdPartyFiles.add(mixerPack);
            }
        });
        for (File file : mixerFolder.listFiles()) {
            boolean isThirdParty;
            if (file.isDirectory() || !file.getName().endsWith(".zip") || (isThirdParty = thirdPartyFiles.stream().anyMatch(tp -> tp.getName().equals(file.getName())))) continue;
            customFiles.add(file);
        }
        List<String> priorityOrder = DefaultConfig.getPriorityOrder();
        for (int i = 0; i < priorityOrder.size(); ++i) {
            boolean foundAtThisPriority = false;
            Iterator it = tempList.iterator();
            while (it.hasNext()) {
                File f;
                ThirdPartyResourcePack pack = (ThirdPartyResourcePack)it.next();
                if (pack.getPriority() != i || (f = pack.getMixerResourcePack()) == null) continue;
                resourcePacks.add(f);
                orderedResourcePacks.add(f.getName().replace(".zip", ""));
                it.remove();
                foundAtThisPriority = true;
                break;
            }
            if (foundAtThisPriority) continue;
            Iterator fileIt = customFiles.iterator();
            while (fileIt.hasNext()) {
                File custom = (File)fileIt.next();
                int prio = priorityOrder.indexOf(custom.getName());
                if (prio != i) continue;
                resourcePacks.add(custom);
                orderedResourcePacks.add(custom.getName().replace(".zip", ""));
                fileIt.remove();
            }
        }
        tempList.stream().map(ThirdPartyResourcePack::getMixerResourcePack).filter(Objects::nonNull).forEach(packFile -> {
            resourcePacks.add((File)packFile);
            orderedResourcePacks.add(packFile.getName().replace(".zip", ""));
            Logger.info("Added supported resource pack " + packFile.getName() + " without a priority!");
        });
        customFiles.forEach(customFile -> {
            resourcePacks.add((File)customFile);
            orderedResourcePacks.add(customFile.getName().replace(".zip", ""));
            Logger.info("Added custom resource pack " + customFile.getName() + " without a priority!");
        });
    }

    private static void cloneToOutputAndUnzip() {
        resourcePacks.forEach(resourcePack -> {
            try {
                if (resourcePack == null) {
                    Logger.warn("A resource pack was null by the time it was meant to be unzipped!");
                    return;
                }
                File file = new File(ResourcePackManager.plugin.getDataFolder().getAbsolutePath() + File.separatorChar + "output" + File.separatorChar + resourcePack.getName().replace(".zip", ""));
                ZipFile.unzip(resourcePack, file);
                Mix.stripDirectoryMetadata(file);
            }
            catch (Exception e) {
                if (resourcePack == null) {
                    Logger.warn("Failed to extract resource pack! The file might be encrypted. This pack will be skipped.");
                }
                Logger.warn("Failed to extract resource pack " + resourcePack.getName() + " - the file might be encrypted or the plugin distributes its own pack. This pack will be skipped.");
            }
        });
        Mix.copyClusterDirectoriesToOutput();
    }

    private static void copyClusterDirectoriesToOutput() {
        if (mixerFolder == null || !mixerFolder.exists()) {
            return;
        }
        File[] mixerContents = mixerFolder.listFiles();
        if (mixerContents == null) {
            return;
        }
        for (File file : mixerContents) {
            if (!file.isDirectory() || file.getName().equals("output")) continue;
            File outputWrapper = new File(Mix.getOutputFolder().getPath() + File.separatorChar + "cluster_" + file.getName());
            if (!outputWrapper.exists()) {
                outputWrapper.mkdir();
            }
            try {
                Mix.recursivelyCopyDirectoryForCluster(file, new File(outputWrapper.getPath() + File.separatorChar + file.getName()));
                if (!orderedResourcePacks.contains("cluster_" + file.getName())) {
                    orderedResourcePacks.add("cluster_" + file.getName());
                }
                Logger.info("Copied cluster directory " + file.getName() + " to output folder");
            }
            catch (Exception e) {
                Logger.warn("Failed to copy cluster directory " + file.getName() + " to output folder");
                e.printStackTrace();
            }
        }
    }

    private static void recursivelyCopyDirectoryForCluster(File source, File target) {
        block6: {
            block5: {
                File[] files;
                if (!source.isDirectory()) break block5;
                if (!target.exists()) {
                    target.mkdir();
                }
                if ((files = source.listFiles()) == null) break block6;
                for (File child : files) {
                    Mix.recursivelyCopyDirectoryForCluster(child, new File(target.getPath() + File.separatorChar + child.getName()));
                }
                break block6;
            }
            try {
                if (target.exists()) {
                    Mix.resolveFileCollision(source, target);
                }
                Files.copy(source.toPath(), target.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                Logger.warn("Failed to copy cluster file " + source.getPath());
            }
        }
    }

    private static void createOutputDefaultElements() {
        if (Mix.getOutputResourcePackFolder().exists()) {
            Mix.recursivelyDeleteDirectory(Mix.getOutputResourcePackFolder());
        }
        try {
            Mix.getOutputResourcePackFolder().mkdir();
        }
        catch (Exception e) {
            Logger.warn("Failed to create resource pack output directory");
            throw new RuntimeException(e);
        }
        ArrayList<File> orderedFiles = new ArrayList<File>();
        for (String filename : orderedResourcePacks) {
            orderedFiles.add(new File(Mix.getOutputFolder().getPath() + File.separatorChar + filename));
        }
        for (File file : orderedFiles) {
            if (file.getName().equals("ResourcePackManager_RSP.zip")) continue;
            if (!file.exists()) {
                Logger.info("Skipping " + file.getName() + " - pack was not extracted (may be encrypted or corrupted)");
                continue;
            }
            if (!file.isDirectory()) {
                if (file.getName().endsWith(".zip")) continue;
                Logger.warn("Somehow a non-folder file made its way to the output folder! This isn't good. File: " + file.getAbsolutePath());
                continue;
            }
            File[] subFiles = file.listFiles();
            if (subFiles == null) continue;
            for (File subFile : subFiles) {
                Mix.recursivelyCopyDirectory(subFile, Mix.getOutputResourcePackFolder());
            }
        }
        Mix.copyPluginPackMcmeta();
        Mix.removeIncompatibleShaders();
        if (!ZipFile.zip(Mix.getOutputResourcePackFolder(), Mix.getOutputResourcePackFolder().getPath() + ".zip")) {
            Logger.warn("Failed to zip merged resource pack!");
            return;
        }
        if (!DefaultConfig.getResourcePackRerouting().isEmpty() && !DefaultConfig.getResourcePackRerouting().isBlank()) {
            try {
                File rerouteFolder = new File(ResourcePackManager.plugin.getDataFolder().getParentFile().getAbsolutePath() + File.separatorChar + DefaultConfig.getResourcePackRerouting());
                if (!rerouteFolder.exists()) {
                    Logger.warn("Failed to reroute zipped file to " + rerouteFolder.getAbsolutePath() + " because that folder does not exist!");
                } else if (!rerouteFolder.isDirectory()) {
                    Logger.warn("Failed to reroute zipped file to " + rerouteFolder.getAbsolutePath() + " because that is a file and not a folder!");
                } else if (!ZipFile.zip(Mix.getOutputResourcePackFolder(), rerouteFolder.getPath() + File.separatorChar + "ResourcePackManager_RSP.zip")) {
                    Logger.warn("Failed to zip merged resource pack into reroute directory!");
                    return;
                }
            }
            catch (Exception e) {
                Logger.warn("Failed to reroute zipped file to " + DefaultConfig.getResourcePackRerouting());
            }
        }
        for (Iterator<String> iterator : Mix.getOutputFolder().listFiles()) {
            if (((File)((Object)iterator)).getName().equals("ResourcePackManager_RSP.zip")) {
                finalResourcePack = iterator;
                try {
                    finalSHA1 = SHA1Generator.sha1CodeString(finalResourcePack);
                    finalSHA1Bytes = SHA1Generator.sha1CodeByteArray(finalResourcePack);
                }
                catch (Exception e) {
                    Logger.warn("Failed to get SHA1 from zipped resource pack!");
                    finalResourcePack = null;
                }
                continue;
            }
            Mix.recursivelyDeleteDirectory(iterator);
        }
    }

    private static File getOutputFolder() {
        return new File(ResourcePackManager.plugin.getDataFolder().getAbsolutePath() + File.separatorChar + "output");
    }

    private static File getOutputResourcePackFolder() {
        return new File(Mix.getOutputFolder().getAbsolutePath() + File.separatorChar + resourcePackName);
    }

    private static void recursivelyDeleteDirectory(File directory) {
        if (directory.isDirectory()) {
            for (File file : directory.listFiles()) {
                Mix.recursivelyDeleteDirectory(file);
            }
            try {
                Files.delete(directory.toPath());
            }
            catch (Exception e) {
                Logger.warn("Failed to delete directory " + directory.getPath());
            }
        } else {
            try {
                Files.delete(directory.toPath());
            }
            catch (IOException e) {
                Logger.warn("Failed to delete file " + directory.getPath());
            }
        }
    }

    private static void recursivelyCopyDirectory(File source, File target) {
        if (source.isDirectory()) {
            target = new File(target.getAbsolutePath() + File.separatorChar + source.getName());
            target.mkdir();
            for (File file : source.listFiles()) {
                Mix.recursivelyCopyDirectory(file, target);
            }
        } else {
            try {
                if (Path.of(target.getPath() + File.separatorChar + source.getName(), new String[0]).toFile().exists()) {
                    Mix.resolveFileCollision(source, Path.of(target.getPath() + File.separatorChar + source.getName(), new String[0]).toFile());
                    return;
                }
                Files.copy(source.toPath(), Path.of(target.getPath() + File.separatorChar + source.getName(), new String[0]), new CopyOption[0]);
            }
            catch (IOException e) {
                Logger.warn("Failed to copy file");
                throw new RuntimeException(e);
            }
        }
    }

    public static void resolveFileCollision(File sourceFile, File targetFile) throws IOException {
        FileWriter targetFileWriter;
        if (!targetFile.getName().endsWith(".json")) {
            Files.copy(sourceFile.toPath(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            Logger.info("Hard collision for file " + targetFile.getPath() + " detected! Replaced with higher priority version.");
            return;
        }
        if (!Mix.isMergeableJsonFile(targetFile)) {
            Files.copy(sourceFile.toPath(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            Logger.info("JSON collision for file " + targetFile.getPath() + " detected! Replaced with higher priority version (not a mergeable JSON type).");
            return;
        }
        FileReader sourceFileReader = new FileReader(sourceFile);
        FileReader targetFileReader = new FileReader(targetFile);
        JsonObject json1 = null;
        try {
            json1 = JsonParser.parseReader(sourceFileReader).getAsJsonObject();
        }
        catch (Exception e) {
            Logger.warn("Malformed JSON for " + sourceFile.getAbsolutePath() + " !");
            try {
                JsonReader jsonReader = new JsonReader(sourceFileReader);
                jsonReader.setStrictness(Strictness.LENIENT);
                json1 = JsonParser.parseReader(jsonReader).getAsJsonObject();
                Logger.info(JsonParser.parseReader(jsonReader).getAsString());
            }
            catch (Exception ex) {
                Logger.warn("Your JSON " + sourceFile.getAbsolutePath() + " is so broken even lenient won't let me read it!");
            }
        }
        JsonObject json2 = JsonParser.parseReader(targetFileReader).getAsJsonObject();
        sourceFileReader.close();
        targetFileReader.close();
        JsonObject mergedJson = Mix.mergeJsonObjects(json1, json2);
        try (FileWriter file = targetFileWriter = new FileWriter(targetFile);){
            new Gson().toJson((JsonElement)mergedJson, (Appendable)file);
        }
        targetFileWriter.close();
        Logger.info("File " + targetFile.getName() + " successfully auto-merged!");
    }

    private static boolean isMergeableJsonFile(File file) {
        String path = file.getPath().replace("\\", "/");
        String fileName = file.getName();
        if (fileName.equals("sounds.json")) {
            return true;
        }
        if (path.contains("/lang/") || path.contains("/languages/")) {
            return true;
        }
        if (path.contains("/minecraft/models/item/")) {
            return true;
        }
        if (path.contains("/atlases/")) {
            return true;
        }
        return path.contains("/font/");
    }

    private static void stripDirectoryMetadata(File file) throws IOException {
        if (!file.isDirectory()) {
            return;
        }
        for (File listFile : file.listFiles()) {
            Mix.stripDirectoryMetadata(listFile);
        }
    }

    public static JsonObject mergeJsonObjects(JsonObject json1, JsonObject json2) {
        JsonObject mergedJson = new JsonObject();
        for (String key : json1.keySet()) {
            if (json2.has(key)) {
                JsonElement value1 = json1.get(key);
                JsonElement value2 = json2.get(key);
                if (value1.isJsonObject() && value2.isJsonObject()) {
                    mergedJson.add(key, Mix.mergeJsonObjects(value1.getAsJsonObject(), value2.getAsJsonObject()));
                    continue;
                }
                if (value1.isJsonArray() && value2.isJsonArray()) {
                    mergedJson.add(key, Mix.mergeJsonArrays(value1.getAsJsonArray(), value2.getAsJsonArray()));
                    continue;
                }
                mergedJson.add(key, value2);
                continue;
            }
            mergedJson.add(key, json1.get(key));
        }
        for (String key : json2.keySet()) {
            if (json1.has(key)) continue;
            mergedJson.add(key, json2.get(key));
        }
        return mergedJson;
    }

    private static JsonArray mergeJsonArrays(JsonArray array1, JsonArray array2) {
        JsonArray mergedArray = new JsonArray();
        for (JsonElement element : array1) {
            mergedArray.add(element);
        }
        for (JsonElement element : array2) {
            mergedArray.add(element);
        }
        return mergedArray;
    }

    private static void copyPluginPackMcmeta() {
        try {
            InputStream inputStream = ResourcePackManager.plugin.getResource("pack.mcmeta");
            if (inputStream == null) {
                Logger.warn("Could not find pack.mcmeta in plugin resources!");
                return;
            }
            File targetFile = new File(Mix.getOutputResourcePackFolder().getPath() + File.separatorChar + "pack.mcmeta");
            Files.copy(inputStream, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            inputStream.close();
            Logger.info("Copied ResourcePackManager pack.mcmeta to merged resource pack.");
        }
        catch (IOException e) {
            Logger.warn("Failed to copy pack.mcmeta to merged resource pack!");
            e.printStackTrace();
        }
    }

    private static void removeIncompatibleShaders() {
        File coreShaderFolder = new File(Mix.getOutputResourcePackFolder().getPath() + File.separatorChar + "assets" + File.separatorChar + "minecraft" + File.separatorChar + "shaders" + File.separatorChar + "core");
        if (!coreShaderFolder.exists()) {
            return;
        }
        File[] shaderFiles = coreShaderFolder.listFiles();
        if (shaderFiles == null) {
            return;
        }
        int removedCount = 0;
        for (File shaderFile : shaderFiles) {
            if (!shaderFile.isFile() || !shaderFile.getName().endsWith(".fsh") && !shaderFile.getName().endsWith(".vsh") && !shaderFile.getName().endsWith(".glsl")) continue;
            try {
                Files.delete(shaderFile.toPath());
                ++removedCount;
            }
            catch (IOException e) {
                Logger.warn("Failed to remove incompatible shader: " + shaderFile.getName());
            }
        }
        if (removedCount > 0) {
            Logger.warn("Removed " + removedCount + " custom core shader(s) from merged resource pack to prevent compatibility issues.");
        }
    }

    @Generated
    public static File getFinalResourcePack() {
        return finalResourcePack;
    }

    @Generated
    public static String getFinalSHA1() {
        return finalSHA1;
    }

    @Generated
    public static byte[] getFinalSHA1Bytes() {
        return finalSHA1Bytes;
    }
}

