/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.resourcepackmanager.itemsadder;

import com.magmaguy.magmacore.config.ConfigurationFile;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class ItemsAdderDismissedConfig
extends ConfigurationFile {
    private static ItemsAdderDismissedConfig instance = null;

    public ItemsAdderDismissedConfig() {
        super("itemsadder_dismissed.yml");
        instance = this;
    }

    public static boolean hasDismissed(UUID playerUUID) {
        if (instance == null) {
            return false;
        }
        List dismissed = instance.getFileConfiguration().getStringList("dismissed");
        return dismissed.contains(playerUUID.toString());
    }

    public static void setDismissed(UUID playerUUID, boolean dismissed) {
        if (instance == null) {
            return;
        }
        ArrayList<String> dismissedList = new ArrayList<String>(instance.getFileConfiguration().getStringList("dismissed"));
        if (dismissed && !dismissedList.contains(playerUUID.toString())) {
            dismissedList.add(playerUUID.toString());
        } else if (!dismissed) {
            dismissedList.remove(playerUUID.toString());
        }
        instance.getFileConfiguration().set("dismissed", dismissedList);
        try {
            instance.getFileConfiguration().save(ItemsAdderDismissedConfig.instance.file);
        }
        catch (Exception e) {
            Logger.warn("Failed to save ItemsAdder dismissed config!");
            e.printStackTrace();
        }
    }

    @Override
    public void initializeValues() {
        if (!this.getFileConfiguration().contains("dismissed")) {
            this.getFileConfiguration().set("dismissed", new ArrayList());
            try {
                this.getFileConfiguration().save(this.file);
            }
            catch (Exception e) {
                Logger.warn("Failed to initialize ItemsAdder dismissed config!");
            }
        }
    }
}

