/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.dataconverter;

import com.magmaguy.freeminecraftmodels.dataconverter.ParsedTexture;
import com.magmaguy.freeminecraftmodels.magmacore.util.Logger;
import com.magmaguy.freeminecraftmodels.magmacore.util.Round;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CubeBlueprint {
    private final Map<String, Object> cubeJSON;
    private Vector3f to;
    private Vector3f from;
    private boolean validatedData = false;
    private Vector3f boneOffset = new Vector3f();
    private Boolean textureDataExists = null;

    public CubeBlueprint(List<ParsedTexture> parsedTextures, Map<String, Object> cubeJSON, String modelName) {
        this.cubeJSON = cubeJSON;
        cubeJSON.remove("rescale");
        cubeJSON.remove("locked");
        cubeJSON.remove("type");
        cubeJSON.remove("uuid");
        cubeJSON.remove("color");
        cubeJSON.remove("autouv");
        cubeJSON.remove("name");
        cubeJSON.remove("box_uv");
        cubeJSON.remove("render_order");
        cubeJSON.remove("allow_mirror_modeling");
        this.processFace(parsedTextures, (Map)cubeJSON.get("faces"), "north", modelName);
        this.processFace(parsedTextures, (Map)cubeJSON.get("faces"), "east", modelName);
        this.processFace(parsedTextures, (Map)cubeJSON.get("faces"), "south", modelName);
        this.processFace(parsedTextures, (Map)cubeJSON.get("faces"), "west", modelName);
        this.processFace(parsedTextures, (Map)cubeJSON.get("faces"), "up", modelName);
        this.processFace(parsedTextures, (Map)cubeJSON.get("faces"), "down", modelName);
        ArrayList fromList = (ArrayList)cubeJSON.get("from");
        if (fromList == null) {
            return;
        }
        this.from = new Vector3f(Round.fourDecimalPlaces(((Double)fromList.get(0)).floatValue() * 0.4f), Round.fourDecimalPlaces(((Double)fromList.get(1)).floatValue() * 0.4f), Round.fourDecimalPlaces(((Double)fromList.get(2)).floatValue() * 0.4f));
        ArrayList toList = (ArrayList)cubeJSON.get("to");
        if (toList == null) {
            return;
        }
        this.to = new Vector3f(Round.fourDecimalPlaces(((Double)toList.get(0)).floatValue() * 0.4f), Round.fourDecimalPlaces(((Double)toList.get(1)).floatValue() * 0.4f), Round.fourDecimalPlaces(((Double)toList.get(2)).floatValue() * 0.4f));
        this.validatedData = true;
    }

    private void processFace(List<ParsedTexture> parsedTextures, Map<String, Object> map, String faceName, String modelName) {
        this.setTextureData(parsedTextures, (Map)map.get(faceName), modelName);
    }

    private void setTextureData(List<ParsedTexture> parsedTextures, Map<String, Object> map, String modelName) {
        if (map == null || map.get("texture") == null) {
            if (this.textureDataExists != null && this.textureDataExists.booleanValue()) {
                Logger.warn("A cube in the model " + modelName + " has a face which does not have a texture while the rest of the cube has a texture. Minecraft does not allow this. Go through every cube in that model and make sure they all either have or do not have textures on all faces, but don't mix having and not having textures for the same cube. The model will appear with the debug black and purple cube texture until fixed.");
            }
            this.textureDataExists = false;
            return;
        }
        if (this.textureDataExists != null && !this.textureDataExists.booleanValue()) {
            Logger.warn("A cube in the model " + modelName + " has a face which does not have a texture while the rest of the cube has a texture. Minecraft does not allow this. Go through every cube in that model and make sure they all either have or do not have textures on all faces, but don't mix having and not having textures for the same cube. The model will appear with the debug black and purple cube texture until fixed.");
        }
        this.textureDataExists = true;
        Double textureDouble = (Double)map.get("texture");
        int textureValue = (int)Math.round(textureDouble);
        map.put("texture", "#" + textureValue);
        map.put("tintindex", 0);
        if (map.get("rotation") == null) {
            map.put("rotation", 0);
        } else {
            map.put("rotation", Float.valueOf(((Double)map.get("rotation")).floatValue()));
        }
        ArrayList originalUV = (ArrayList)map.get("uv");
        double uvMultiplier = 16.0 / parsedTextures.get(textureValue).getTextureWidth();
        map.put("uv", List.of(Double.valueOf(Round.fourDecimalPlaces((Double)originalUV.get(0) * uvMultiplier)), Double.valueOf(Round.fourDecimalPlaces((Double)originalUV.get(1) * uvMultiplier)), Double.valueOf(Round.fourDecimalPlaces((Double)originalUV.get(2) * uvMultiplier)), Double.valueOf(Round.fourDecimalPlaces((Double)originalUV.get(3) * uvMultiplier))));
    }

    public void shiftPosition() {
        this.from.sub((Vector3fc)this.boneOffset);
        this.to.sub((Vector3fc)this.boneOffset);
        this.cubeJSON.put("from", List.of(Float.valueOf(this.from.get(0)), Float.valueOf(this.from.get(1)), Float.valueOf(this.from.get(2))));
        this.cubeJSON.put("to", List.of(Float.valueOf(this.to.get(0)), Float.valueOf(this.to.get(1)), Float.valueOf(this.to.get(2))));
    }

    public void shiftRotation() {
        if (this.cubeJSON.get("origin") == null) {
            return;
        }
        HashMap<String, Object> newRotationData = new HashMap<String, Object>();
        double scaleFactor = 0.4;
        ArrayList originData = (ArrayList)this.cubeJSON.get("origin");
        double xOrigin = (Double)originData.get(0) * scaleFactor - (double)this.boneOffset.get(0);
        double yOrigin = (Double)originData.get(1) * scaleFactor - (double)this.boneOffset.get(1);
        double zOrigin = (Double)originData.get(2) * scaleFactor - (double)this.boneOffset.get(2);
        double angle = 0.0;
        String axis = "x";
        if (this.cubeJSON.get("rotation") != null) {
            List rotations = (List)this.cubeJSON.get("rotation");
            block5: for (int i = rotations.size() - 1; i >= 0; --i) {
                if ((Double)rotations.get(i) == 0.0) continue;
                angle = Round.fourDecimalPlaces((Double)rotations.get(i));
                switch (i) {
                    case 0: {
                        axis = "x";
                        continue block5;
                    }
                    case 1: {
                        axis = "y";
                        continue block5;
                    }
                    case 2: {
                        axis = "z";
                        continue block5;
                    }
                    default: {
                        Logger.warn("Unexpected amount of rotation axes!");
                    }
                }
            }
        }
        RotationDecomposition decomp = this.decomposeRotation(angle);
        if (decomp.baseRotation != 0.0) {
            this.transformCubeGeometry(decomp.baseRotation, axis, xOrigin, yOrigin, zOrigin);
            newRotationData.put("angle", decomp.remainder);
            newRotationData.put("axis", axis);
        } else {
            newRotationData.put("angle", angle);
            newRotationData.put("axis", axis);
        }
        newRotationData.put("origin", List.of(Double.valueOf(xOrigin), Double.valueOf(yOrigin), Double.valueOf(zOrigin)));
        this.cubeJSON.put("rotation", newRotationData);
        this.cubeJSON.remove("origin");
    }

    private RotationDecomposition decomposeRotation(double angle) {
        double[] baseRotations;
        RotationDecomposition result = new RotationDecomposition();
        while (angle > 180.0) {
            angle -= 360.0;
        }
        while (angle < -180.0) {
            angle += 360.0;
        }
        double[] allowedRotations = new double[]{-45.0, -22.5, 0.0, 22.5, 45.0};
        for (double base : baseRotations = new double[]{0.0, 90.0, -90.0, 180.0, -180.0}) {
            double remainder;
            for (remainder = angle - base; remainder > 180.0; remainder -= 360.0) {
            }
            while (remainder < -180.0) {
                remainder += 360.0;
            }
            for (double allowed : allowedRotations) {
                if (!(Math.abs(remainder - allowed) < 0.01)) continue;
                result.baseRotation = base;
                result.remainder = allowed;
                return result;
            }
        }
        Logger.warn("Could not decompose rotation angle " + angle + " into base + allowed remainder");
        result.baseRotation = 0.0;
        result.remainder = angle;
        return result;
    }

    private void transformCubeGeometry(double angle, String axis, double originX, double originY, double originZ) {
        float fromX = this.from.x;
        float fromY = this.from.y;
        float fromZ = this.from.z;
        float toX = this.to.x;
        float toY = this.to.y;
        float toZ = this.to.z;
        Vector3f newFrom = new Vector3f();
        Vector3f newTo = new Vector3f();
        fromX = (float)((double)fromX - originX);
        fromY = (float)((double)fromY - originY);
        fromZ = (float)((double)fromZ - originZ);
        toX = (float)((double)toX - originX);
        toY = (float)((double)toY - originY);
        toZ = (float)((double)toZ - originZ);
        switch (axis.toLowerCase()) {
            case "x": {
                if (Math.abs(angle - 90.0) < 0.01) {
                    newFrom.set(fromX, -fromZ, fromY);
                    newTo.set(toX, -toZ, toY);
                    break;
                }
                if (Math.abs(angle + 90.0) < 0.01) {
                    newFrom.set(fromX, fromZ, -fromY);
                    newTo.set(toX, toZ, -toY);
                    break;
                }
                if (!(Math.abs(angle - 180.0) < 0.01) && !(Math.abs(angle + 180.0) < 0.01)) break;
                newFrom.set(fromX, -fromY, -fromZ);
                newTo.set(toX, -toY, -toZ);
                break;
            }
            case "y": {
                if (Math.abs(angle - 90.0) < 0.01) {
                    newFrom.set(fromZ, fromY, -fromX);
                    newTo.set(toZ, toY, -toX);
                    break;
                }
                if (Math.abs(angle + 90.0) < 0.01) {
                    newFrom.set(-fromZ, fromY, fromX);
                    newTo.set(-toZ, toY, toX);
                    break;
                }
                if (!(Math.abs(angle - 180.0) < 0.01) && !(Math.abs(angle + 180.0) < 0.01)) break;
                newFrom.set(-fromX, fromY, -fromZ);
                newTo.set(-toX, toY, -toZ);
                break;
            }
            case "z": {
                if (Math.abs(angle - 90.0) < 0.01) {
                    newFrom.set(-fromY, fromX, fromZ);
                    newTo.set(-toY, toX, toZ);
                    break;
                }
                if (Math.abs(angle + 90.0) < 0.01) {
                    newFrom.set(fromY, -fromX, fromZ);
                    newTo.set(toY, -toX, toZ);
                    break;
                }
                if (!(Math.abs(angle - 180.0) < 0.01) && !(Math.abs(angle + 180.0) < 0.01)) break;
                newFrom.set(-fromX, -fromY, fromZ);
                newTo.set(-toX, -toY, toZ);
            }
        }
        newFrom.add((float)originX, (float)originY, (float)originZ);
        newTo.add((float)originX, (float)originY, (float)originZ);
        this.from.set(Math.min(newFrom.x, newTo.x), Math.min(newFrom.y, newTo.y), Math.min(newFrom.z, newTo.z));
        this.to.set(Math.max(newFrom.x, newTo.x), Math.max(newFrom.y, newTo.y), Math.max(newFrom.z, newTo.z));
        this.cubeJSON.put("from", List.of(Float.valueOf(this.from.get(0)), Float.valueOf(this.from.get(1)), Float.valueOf(this.from.get(2))));
        this.cubeJSON.put("to", List.of(Float.valueOf(this.to.get(0)), Float.valueOf(this.to.get(1)), Float.valueOf(this.to.get(2))));
        this.remapFaces(angle, axis);
    }

    private void remapFaces(double angle, String axis) {
        Map faces = (Map)this.cubeJSON.get("faces");
        if (faces == null) {
            return;
        }
        HashMap originalFaces = new HashMap(faces);
        switch (axis.toLowerCase()) {
            case "x": {
                if (Math.abs(angle - 90.0) < 0.01) {
                    faces.put("north", originalFaces.get("down"));
                    faces.put("up", originalFaces.get("north"));
                    faces.put("south", originalFaces.get("up"));
                    faces.put("down", originalFaces.get("south"));
                    this.rotateFaceUV(faces, "east", 90.0);
                    this.rotateFaceUV(faces, "west", -90.0);
                    break;
                }
                if (Math.abs(angle + 90.0) < 0.01) {
                    faces.put("north", originalFaces.get("up"));
                    faces.put("down", originalFaces.get("north"));
                    faces.put("south", originalFaces.get("down"));
                    faces.put("up", originalFaces.get("south"));
                    this.rotateFaceUV(faces, "east", -90.0);
                    this.rotateFaceUV(faces, "west", 90.0);
                    break;
                }
                if (!(Math.abs(angle - 180.0) < 0.01) && !(Math.abs(angle + 180.0) < 0.01)) break;
                faces.put("north", originalFaces.get("south"));
                faces.put("south", originalFaces.get("north"));
                faces.put("up", originalFaces.get("down"));
                faces.put("down", originalFaces.get("up"));
                this.rotateFaceUV(faces, "east", 180.0);
                this.rotateFaceUV(faces, "west", 180.0);
                break;
            }
            case "y": {
                if (Math.abs(angle - 90.0) < 0.01) {
                    faces.put("north", originalFaces.get("west"));
                    faces.put("east", originalFaces.get("north"));
                    faces.put("south", originalFaces.get("east"));
                    faces.put("west", originalFaces.get("south"));
                    this.rotateFaceUV(faces, "up", 90.0);
                    this.rotateFaceUV(faces, "down", -90.0);
                    break;
                }
                if (Math.abs(angle + 90.0) < 0.01) {
                    faces.put("north", originalFaces.get("east"));
                    faces.put("west", originalFaces.get("north"));
                    faces.put("south", originalFaces.get("west"));
                    faces.put("east", originalFaces.get("south"));
                    this.rotateFaceUV(faces, "up", -90.0);
                    this.rotateFaceUV(faces, "down", 90.0);
                    break;
                }
                if (!(Math.abs(angle - 180.0) < 0.01) && !(Math.abs(angle + 180.0) < 0.01)) break;
                faces.put("north", originalFaces.get("south"));
                faces.put("south", originalFaces.get("north"));
                faces.put("east", originalFaces.get("west"));
                faces.put("west", originalFaces.get("east"));
                this.rotateFaceUV(faces, "up", 180.0);
                this.rotateFaceUV(faces, "down", 180.0);
                break;
            }
            case "z": {
                if (Math.abs(angle - 90.0) < 0.01) {
                    faces.put("up", originalFaces.get("west"));
                    faces.put("east", originalFaces.get("up"));
                    faces.put("down", originalFaces.get("east"));
                    faces.put("west", originalFaces.get("down"));
                    this.rotateFaceUV(faces, "north", 90.0);
                    this.rotateFaceUV(faces, "south", -90.0);
                    break;
                }
                if (Math.abs(angle + 90.0) < 0.01) {
                    faces.put("up", originalFaces.get("east"));
                    faces.put("west", originalFaces.get("up"));
                    faces.put("down", originalFaces.get("west"));
                    faces.put("east", originalFaces.get("down"));
                    this.rotateFaceUV(faces, "north", -90.0);
                    this.rotateFaceUV(faces, "south", 90.0);
                    break;
                }
                if (!(Math.abs(angle - 180.0) < 0.01) && !(Math.abs(angle + 180.0) < 0.01)) break;
                faces.put("up", originalFaces.get("down"));
                faces.put("down", originalFaces.get("up"));
                faces.put("east", originalFaces.get("west"));
                faces.put("west", originalFaces.get("east"));
                this.rotateFaceUV(faces, "north", 180.0);
                this.rotateFaceUV(faces, "south", 180.0);
            }
        }
    }

    private void rotateFaceUV(Map<String, Object> faces, String faceName, double rotation) {
        List<Double> newUV;
        Map face = (Map)faces.get(faceName);
        if (face == null) {
            return;
        }
        List<Double> uv = (List<Double>)face.get("uv");
        if (uv == null || uv.size() != 4) {
            return;
        }
        double u1 = (Double)uv.get(0);
        double v1 = (Double)uv.get(1);
        double u2 = (Double)uv.get(2);
        double v2 = (Double)uv.get(3);
        int normalizedRotation = ((int)rotation % 360 + 360) % 360;
        switch (normalizedRotation) {
            case 90: {
                newUV = List.of(Double.valueOf(u1), Double.valueOf(v2), Double.valueOf(u2), Double.valueOf(v1));
                face.put("rotation", 90);
                break;
            }
            case 180: {
                newUV = List.of(Double.valueOf(u2), Double.valueOf(v2), Double.valueOf(u1), Double.valueOf(v1));
                face.put("rotation", 180);
                break;
            }
            case 270: {
                newUV = List.of(Double.valueOf(u2), Double.valueOf(v1), Double.valueOf(u1), Double.valueOf(v2));
                face.put("rotation", 270);
                break;
            }
            default: {
                newUV = uv;
            }
        }
        face.put("uv", newUV);
    }

    public Map<String, Object> getCubeJSON() {
        return this.cubeJSON;
    }

    public Vector3f getTo() {
        return this.to;
    }

    public Vector3f getFrom() {
        return this.from;
    }

    public boolean isValidatedData() {
        return this.validatedData;
    }

    public Vector3f getBoneOffset() {
        return this.boneOffset;
    }

    public void setBoneOffset(Vector3f boneOffset) {
        this.boneOffset = boneOffset;
    }

    private static class RotationDecomposition {
        double baseRotation;
        double remainder;

        private RotationDecomposition() {
        }
    }
}

