/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.customentity.core;

import com.magmaguy.freeminecraftmodels.customentity.ModeledEntity;
import com.magmaguy.freeminecraftmodels.customentity.core.Bone;
import com.magmaguy.freeminecraftmodels.customentity.core.SkeletonWatchers;
import com.magmaguy.freeminecraftmodels.dataconverter.BoneBlueprint;
import com.magmaguy.freeminecraftmodels.dataconverter.SkeletonBlueprint;
import com.magmaguy.freeminecraftmodels.easyminecraftgoals.internal.AbstractPacketBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;

public class Skeleton {
    private final List<BoneBlueprint> mainModel = new ArrayList<BoneBlueprint>();
    private final HashMap<String, Bone> boneMap = new HashMap();
    private final SkeletonBlueprint skeletonBlueprint;
    private final SkeletonWatchers skeletonWatchers;
    private final List<Bone> nametags = new ArrayList<Bone>();
    private float currentHeadPitch = 0.0f;
    private float currentHeadYaw = 0.0f;
    private ModeledEntity modeledEntity = null;
    private Bone rootBone = null;
    private boolean tinting = false;
    private int tintCounter = 0;

    public Skeleton(SkeletonBlueprint skeletonBlueprint, ModeledEntity modeledEntity) {
        this.skeletonBlueprint = skeletonBlueprint;
        this.modeledEntity = modeledEntity;
        skeletonBlueprint.getBoneMap().forEach((key, value) -> {
            if (value.getParent() == null) {
                Bone bone = new Bone((BoneBlueprint)value, null, this);
                this.boneMap.put((String)key, bone);
                bone.getAllChildren(this.boneMap);
                this.rootBone = bone;
            }
        });
        this.skeletonWatchers = new SkeletonWatchers(this);
    }

    @Nullable
    public Location getCurrentLocation() {
        return this.modeledEntity.getLocation();
    }

    public void generateDisplays() {
        this.rootBone.generateDisplay();
        this.boneMap.values().forEach(bone -> {
            if (bone.getBoneBlueprint().isNameTag()) {
                this.nametags.add((Bone)bone);
            }
        });
    }

    public void remove() {
        this.boneMap.values().forEach(Bone::remove);
    }

    public List<Bone> getNametags() {
        ArrayList<Bone> nametags = new ArrayList<Bone>();
        for (Bone value : this.boneMap.values()) {
            if (!value.getBoneBlueprint().isNameTag()) continue;
            nametags.add(value);
        }
        return nametags;
    }

    public Collection<Bone> getBones() {
        return this.boneMap.values();
    }

    public void tick(AbstractPacketBundle abstractPacketBundle) {
        this.skeletonWatchers.tick();
        if (this.tinting) {
            ++this.tintCounter;
            if (this.tintCounter <= 10) {
                int gAndB = (int)(255.0 / (double)this.tintCounter);
                Color tint = Color.fromRGB((int)255, (int)gAndB, (int)gAndB);
                this.boneMap.values().forEach(b -> b.setHorseLeatherArmorColor(tint));
            } else if (!this.modeledEntity.isDying()) {
                this.tinting = false;
                this.boneMap.values().forEach(b -> b.setHorseLeatherArmorColor(Color.WHITE));
            } else if (this.modeledEntity.isRemoved()) {
                this.tinting = false;
            } else if (this.tintCounter % 5 == 0) {
                this.boneMap.values().forEach(b -> b.spawnParticles(Particle.POOF, 0.1));
            }
        }
        if (this.getSkeletonWatchers().hasObservers()) {
            this.rootBone.transform(abstractPacketBundle);
        }
    }

    public void tint() {
        this.tinting = true;
        this.tintCounter = 0;
    }

    public void teleport() {
        this.rootBone.teleport();
    }

    public List<BoneBlueprint> getMainModel() {
        return this.mainModel;
    }

    public HashMap<String, Bone> getBoneMap() {
        return this.boneMap;
    }

    public SkeletonBlueprint getSkeletonBlueprint() {
        return this.skeletonBlueprint;
    }

    public SkeletonWatchers getSkeletonWatchers() {
        return this.skeletonWatchers;
    }

    public float getCurrentHeadPitch() {
        return this.currentHeadPitch;
    }

    public void setCurrentHeadPitch(float currentHeadPitch) {
        this.currentHeadPitch = currentHeadPitch;
    }

    public float getCurrentHeadYaw() {
        return this.currentHeadYaw;
    }

    public void setCurrentHeadYaw(float currentHeadYaw) {
        this.currentHeadYaw = currentHeadYaw;
    }

    public ModeledEntity getModeledEntity() {
        return this.modeledEntity;
    }

    public void setModeledEntity(ModeledEntity modeledEntity) {
        this.modeledEntity = modeledEntity;
    }
}

