/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.customentity.core;

import com.magmaguy.freeminecraftmodels.config.DefaultConfig;
import com.magmaguy.freeminecraftmodels.customentity.core.BoneTransforms;
import com.magmaguy.freeminecraftmodels.customentity.core.Skeleton;
import com.magmaguy.freeminecraftmodels.dataconverter.BoneBlueprint;
import com.magmaguy.freeminecraftmodels.easyminecraftgoals.internal.AbstractPacketBundle;
import com.magmaguy.freeminecraftmodels.magmacore.util.Logger;
import com.magmaguy.freeminecraftmodels.magmacore.util.VersionChecker;
import com.magmaguy.freeminecraftmodels.thirdparty.BedrockChecker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.joml.Vector3f;

public class Bone {
    private final BoneBlueprint boneBlueprint;
    private final List<Bone> boneChildren = new ArrayList<Bone>();
    private final Bone parent;
    private final Skeleton skeleton;
    private final BoneTransforms boneTransforms;
    private Vector3f animationTranslation = new Vector3f();
    private Vector3f animationRotation = new Vector3f();
    private float animationScale = -1.0f;
    boolean warned = false;

    public Bone(BoneBlueprint boneBlueprint, Bone parent, Skeleton skeleton) {
        this.boneBlueprint = boneBlueprint;
        this.parent = parent;
        this.skeleton = skeleton;
        this.boneTransforms = new BoneTransforms(this, parent);
        for (BoneBlueprint child : boneBlueprint.getBoneBlueprintChildren()) {
            this.boneChildren.add(new Bone(child, this, skeleton));
        }
    }

    public void updateAnimationTranslation(float x, float y, float z) {
        this.animationTranslation = new Vector3f(x, y, z);
    }

    public void updateAnimationRotation(double x, double y, double z) {
        this.animationRotation = new Vector3f((float)Math.toRadians(x), (float)Math.toRadians(y), (float)Math.toRadians(z));
    }

    public void updateAnimationScale(float animationScale) {
        this.animationScale = animationScale;
    }

    public void transform(AbstractPacketBundle abstractPacketBundle) {
        this.boneTransforms.transform();
        this.boneChildren.forEach(childBone -> childBone.transform(abstractPacketBundle));
        this.skeleton.getSkeletonWatchers().sendPackets(this, abstractPacketBundle);
    }

    public void generateDisplay() {
        this.boneTransforms.generateDisplay();
        this.boneChildren.forEach(Bone::generateDisplay);
    }

    public void setNameVisible(boolean visible) {
        this.boneChildren.forEach(child -> child.setNameVisible(visible));
    }

    public void remove() {
        if (this.boneTransforms.getPacketTextDisplayArmorStandEntity() != null) {
            this.boneTransforms.getPacketTextDisplayArmorStandEntity().remove();
        }
        if (this.boneTransforms.getPacketArmorStandEntity() != null) {
            this.boneTransforms.getPacketArmorStandEntity().remove();
        }
        if (this.boneTransforms.getPacketDisplayEntity() != null) {
            this.boneTransforms.getPacketDisplayEntity().remove();
        }
        this.boneChildren.forEach(Bone::remove);
    }

    protected void getAllChildren(HashMap<String, Bone> children) {
        this.boneChildren.forEach(child -> {
            children.put(child.getBoneBlueprint().getBoneName(), (Bone)child);
            child.getAllChildren(children);
        });
    }

    public void sendUpdatePacket(AbstractPacketBundle abstractPacketBundle) {
        this.boneTransforms.sendUpdatePacket(abstractPacketBundle);
    }

    public void displayTo(Player player) {
        boolean isBedrock = BedrockChecker.isBedrock(player);
        if (isBedrock && DefaultConfig.sendCustomModelsToBedrockClients) {
            return;
        }
        if (this.boneBlueprint.isNameTag()) {
            if (this.boneTransforms.getPacketTextDisplayArmorStandEntity() == null) {
                if (!this.warned) {
                    Logger.warn("nametag bone did not spawn name tag");
                    this.warned = true;
                }
                return;
            }
            this.boneTransforms.getPacketTextDisplayArmorStandEntity().displayTo(player.getUniqueId());
        } else if (this.boneTransforms.getPacketArmorStandEntity() != null && (!DefaultConfig.useDisplayEntitiesWhenPossible || isBedrock || VersionChecker.serverVersionOlderThan(19, 4))) {
            this.boneTransforms.getPacketArmorStandEntity().displayTo(player.getUniqueId());
        } else if (this.boneTransforms.getPacketDisplayEntity() != null) {
            this.boneTransforms.getPacketDisplayEntity().displayTo(player.getUniqueId());
        }
    }

    public void hideFrom(UUID playerUUID) {
        if (this.boneTransforms.getPacketTextDisplayArmorStandEntity() != null) {
            this.boneTransforms.getPacketTextDisplayArmorStandEntity().hideFrom(playerUUID);
        }
        if (this.boneTransforms.getPacketArmorStandEntity() != null) {
            this.boneTransforms.getPacketArmorStandEntity().hideFrom(playerUUID);
        }
        if (this.boneTransforms.getPacketDisplayEntity() != null) {
            this.boneTransforms.getPacketDisplayEntity().hideFrom(playerUUID);
        }
    }

    public void setHorseLeatherArmorColor(Color color) {
        if (this.boneTransforms.getPacketArmorStandEntity() != null) {
            this.boneTransforms.getPacketArmorStandEntity().setHorseLeatherArmorColor(color);
        }
        if (this.boneTransforms.getPacketDisplayEntity() != null) {
            this.boneTransforms.getPacketDisplayEntity().setHorseLeatherArmorColor(color);
        }
    }

    public void spawnParticles(Particle particle, double speed) {
        if (this.boneTransforms.getPacketDisplayEntity() != null) {
            Location boneLocation = this.boneTransforms.getDisplayEntityTargetLocation();
            if (boneLocation.getWorld() == null) {
                return;
            }
            boneLocation.getWorld().spawnParticle(particle, boneLocation, 1, 1.0, 1.0, 1.0, speed);
        } else if (this.boneTransforms.getPacketArmorStandEntity() != null) {
            Location boneLocation = this.boneTransforms.getArmorStandTargetLocation();
            if (boneLocation.getWorld() == null) {
                return;
            }
            boneLocation.getWorld().spawnParticle(particle, boneLocation, 1, 1.0, 1.0, 1.0, speed);
        }
    }

    public void teleport() {
        this.sendTeleportPacket();
        this.boneChildren.forEach(Bone::teleport);
    }

    private void sendTeleportPacket() {
        if (this.boneTransforms.getPacketArmorStandEntity() != null) {
            this.boneTransforms.getPacketArmorStandEntity().teleport(this.boneTransforms.getArmorStandTargetLocation());
        }
        if (this.boneTransforms.getPacketDisplayEntity() != null) {
            this.boneTransforms.getPacketDisplayEntity().teleport(this.boneTransforms.getDisplayEntityTargetLocation());
        }
        this.skeleton.getSkeletonWatchers().resync(true);
    }

    public BoneBlueprint getBoneBlueprint() {
        return this.boneBlueprint;
    }

    public List<Bone> getBoneChildren() {
        return this.boneChildren;
    }

    public Bone getParent() {
        return this.parent;
    }

    public Skeleton getSkeleton() {
        return this.skeleton;
    }

    public BoneTransforms getBoneTransforms() {
        return this.boneTransforms;
    }

    public Vector3f getAnimationTranslation() {
        return this.animationTranslation;
    }

    public Vector3f getAnimationRotation() {
        return this.animationRotation;
    }

    public float getAnimationScale() {
        return this.animationScale;
    }
}

