/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.animation;

import com.magmaguy.freeminecraftmodels.animation.Animation;
import com.magmaguy.freeminecraftmodels.animation.AnimationStateConfig;
import com.magmaguy.freeminecraftmodels.animation.AnimationStateType;
import com.magmaguy.freeminecraftmodels.animation.IAnimState;
import com.magmaguy.freeminecraftmodels.customentity.ModeledEntity;
import java.util.Optional;

public class DeathState
implements IAnimState {
    private final ModeledEntity modeledEntity;
    private final AnimationStateConfig cfg;

    public DeathState(ModeledEntity entity, AnimationStateConfig cfg) {
        this.modeledEntity = entity;
        this.cfg = cfg;
    }

    @Override
    public void enter() {
        this.cfg.getAnimation().resetCounter();
    }

    @Override
    public void update() {
    }

    @Override
    public void exit() {
    }

    @Override
    public AnimationStateType getType() {
        return AnimationStateType.DEATH;
    }

    @Override
    public Optional<AnimationStateType> nextState() {
        int dur;
        Animation anim = this.cfg.getAnimation();
        long counter = anim.getCounter();
        if (counter >= (long)(dur = anim.getAnimationBlueprint().getDuration())) {
            this.modeledEntity.removeWithMinimizedAnimation();
        }
        return Optional.empty();
    }

    @Override
    public Animation getAnimation() {
        return this.cfg.getAnimation();
    }

    @Override
    public boolean isLoop() {
        return this.cfg.isLoop();
    }
}

