/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.easyminecraftgoals.v1_21_R7_spigot;

import java.lang.reflect.Method;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Display;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CraftBukkitBridge {
    private static final boolean IS_PAPER = CraftBukkitBridge.detectPaper();
    private static final String CB_PACKAGE = IS_PAPER ? "org.bukkit.craftbukkit" : "org.bukkit.craftbukkit.v1_21_R7";
    private static Class<?> craftWorldClass;
    private static Class<?> craftPlayerClass;
    private static Class<?> craftEntityClass;
    private static Class<?> craftLivingEntityClass;
    private static Class<?> craftItemStackClass;
    private static Class<?> craftBlockDataClass;
    private static Method craftWorldGetHandle;
    private static Method craftPlayerGetHandle;
    private static Method craftEntityGetHandle;
    private static Method craftLivingEntityGetHandle;
    private static Method craftItemStackAsNMSCopy;
    private static Method craftBlockDataGetState;
    private static Method displayTeleportDurationMethod;

    private static boolean detectPaper() {
        try {
            Class.forName("io.papermc.paper.configuration.GlobalConfiguration");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static void initializeClasses() {
        try {
            craftWorldClass = Class.forName(CB_PACKAGE + ".CraftWorld");
            craftPlayerClass = Class.forName(CB_PACKAGE + ".entity.CraftPlayer");
            craftEntityClass = Class.forName(CB_PACKAGE + ".entity.CraftEntity");
            craftLivingEntityClass = Class.forName(CB_PACKAGE + ".entity.CraftLivingEntity");
            craftItemStackClass = Class.forName(CB_PACKAGE + ".inventory.CraftItemStack");
            craftBlockDataClass = Class.forName(CB_PACKAGE + ".block.data.CraftBlockData");
            craftWorldGetHandle = craftWorldClass.getMethod("getHandle", new Class[0]);
            craftPlayerGetHandle = craftPlayerClass.getMethod("getHandle", new Class[0]);
            craftEntityGetHandle = craftEntityClass.getMethod("getHandle", new Class[0]);
            craftLivingEntityGetHandle = craftLivingEntityClass.getMethod("getHandle", new Class[0]);
            craftItemStackAsNMSCopy = craftItemStackClass.getMethod("asNMSCopy", ItemStack.class);
            craftBlockDataGetState = craftBlockDataClass.getMethod("getState", new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize CraftBukkit bridge for " + (IS_PAPER ? "Paper" : "Spigot"), e);
        }
    }

    public static boolean isPaper() {
        return IS_PAPER;
    }

    public static ServerLevel getServerLevel(World world) {
        try {
            return (ServerLevel)craftWorldGetHandle.invoke((Object)world, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get ServerLevel from World", e);
        }
    }

    public static ServerLevel getServerLevel(Location location) {
        return CraftBukkitBridge.getServerLevel(location.getWorld());
    }

    public static ServerPlayer getServerPlayer(Player player) {
        try {
            return (ServerPlayer)craftPlayerGetHandle.invoke((Object)player, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get ServerPlayer from Player", e);
        }
    }

    public static net.minecraft.world.entity.Entity getNMSEntity(Entity entity) {
        try {
            return (net.minecraft.world.entity.Entity)craftEntityGetHandle.invoke((Object)entity, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get NMS Entity from Bukkit Entity", e);
        }
    }

    public static net.minecraft.world.entity.LivingEntity getNMSLivingEntity(LivingEntity entity) {
        try {
            return (net.minecraft.world.entity.LivingEntity)craftLivingEntityGetHandle.invoke((Object)entity, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get NMS LivingEntity from Bukkit LivingEntity", e);
        }
    }

    public static net.minecraft.world.item.ItemStack asNMSCopy(ItemStack itemStack) {
        try {
            return (net.minecraft.world.item.ItemStack)craftItemStackAsNMSCopy.invoke(null, itemStack);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert ItemStack to NMS", e);
        }
    }

    public static BlockState getBlockState(BlockData blockData) {
        try {
            return (BlockState)craftBlockDataGetState.invoke((Object)blockData, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get BlockState from BlockData", e);
        }
    }

    public static World getBukkitWorld(Level level) {
        try {
            Method getWorld = level.getClass().getMethod("getWorld", new Class[0]);
            return (World)getWorld.invoke((Object)level, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get Bukkit World from Level", e);
        }
    }

    public static Entity getBukkitEntity(net.minecraft.world.entity.Entity nmsEntity) {
        try {
            Method getBukkitEntity = nmsEntity.getClass().getMethod("getBukkitEntity", new Class[0]);
            return (Entity)getBukkitEntity.invoke((Object)nmsEntity, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get Bukkit Entity from NMS Entity", e);
        }
    }

    public static void setDisplayTeleportDuration(Display display, int duration) {
        try {
            if (displayTeleportDurationMethod == null) {
                displayTeleportDurationMethod = CraftBukkitBridge.findDisplayTeleportDurationMethod();
            }
            displayTeleportDurationMethod.invoke((Object)display, duration);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Method findDisplayTeleportDurationMethod() throws NoSuchMethodException {
        Class<Display> displayClass = Display.class;
        String methodName = IS_PAPER ? "setPosRotInterpolationDuration" : "d";
        Method method = displayClass.getDeclaredMethod(methodName, Integer.TYPE);
        method.setAccessible(true);
        return method;
    }

    public static String getEntityDimensionsFieldName() {
        return "dimensions";
    }

    static {
        CraftBukkitBridge.initializeClasses();
        displayTeleportDurationMethod = null;
    }
}

