/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.easyminecraftgoals.v1_20_R3.wanderbacktopoint;

import com.google.common.collect.ImmutableList;
import com.magmaguy.freeminecraftmodels.easyminecraftgoals.NMSManager;
import com.magmaguy.freeminecraftmodels.easyminecraftgoals.events.WanderBackToPointEndEvent;
import com.magmaguy.freeminecraftmodels.easyminecraftgoals.events.WanderBackToPointStartEvent;
import com.magmaguy.freeminecraftmodels.easyminecraftgoals.internal.AbstractWanderBackToPoint;
import com.magmaguy.freeminecraftmodels.easyminecraftgoals.utils.Utils;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.pathfinder.Path;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.scheduler.BukkitRunnable;

public class WanderBackToPointBehavior
extends Behavior<net.minecraft.world.entity.LivingEntity>
implements AbstractWanderBackToPoint {
    private final Location returnLocation;
    private final double maximumDistanceFromPoint;
    private final LivingEntity livingEntity;
    private final Mob mob;
    private final int maxDurationTicks;
    private long lastTime;
    private int priority;
    private float speed;
    private int stopReturnDistance = 0;
    private int goalRefreshCooldownTicks = 60;
    private boolean hardObjective = false;
    private boolean teleportOnFail = false;
    private boolean startWithCooldown = false;
    private Path path = null;

    public WanderBackToPointBehavior(LivingEntity livingEntity, Mob mob, Location location, double maximumDistanceFromPoint, int priority, int maxDurationTicks) {
        super(Map.of(MemoryModuleType.WALK_TARGET, MemoryStatus.REGISTERED), 0, maxDurationTicks);
        this.livingEntity = livingEntity;
        this.mob = mob;
        this.returnLocation = location;
        this.maximumDistanceFromPoint = maximumDistanceFromPoint;
        this.maxDurationTicks = maxDurationTicks;
        this.priority = priority;
        this.lastTime = 0L;
    }

    protected boolean checkExtraStartConditions(ServerLevel var0, net.minecraft.world.entity.LivingEntity nmsLivingEntity) {
        if (!this.hardObjective && this.mob.getTarget() instanceof Player) {
            this.updateCooldown();
            return false;
        }
        if (this.lastTime + 50L * (long)this.goalRefreshCooldownTicks - System.currentTimeMillis() > 0L) {
            return false;
        }
        this.updateCooldown();
        if (Utils.distanceShorterThan(this.returnLocation.toVector(), this.livingEntity.getLocation().toVector(), this.maximumDistanceFromPoint)) {
            return false;
        }
        WanderBackToPointStartEvent wanderBackToPointStartEvent = new WanderBackToPointStartEvent(this.hardObjective, this.livingEntity, this);
        Bukkit.getPluginManager().callEvent((Event)wanderBackToPointStartEvent);
        if (wanderBackToPointStartEvent.isCancelled()) {
            return false;
        }
        this.path = ((PathfinderMob)nmsLivingEntity).getNavigation().createPath(this.returnLocation.getX(), this.returnLocation.getY(), this.returnLocation.getZ(), this.stopReturnDistance);
        if (this.teleportOnFail && (this.path == null || !this.path.canReach())) {
            this.path = null;
            this.livingEntity.teleport(this.returnLocation);
            WanderBackToPointEndEvent wanderBackToPointEndEvent = new WanderBackToPointEndEvent(this.hardObjective, this.livingEntity, this);
            Bukkit.getPluginManager().callEvent((Event)wanderBackToPointEndEvent);
            return false;
        }
        return true;
    }

    protected void start(ServerLevel var0, net.minecraft.world.entity.LivingEntity var1, long var2) {
        this.mob.getNavigation().stop();
        this.mob.getNavigation().moveTo(this.path, (double)this.speed);
        this.mob.getBrain().setActiveActivityIfPossible(Activity.CORE);
        if (this.hardObjective) {
            new BukkitRunnable(){

                public void run() {
                    if (!WanderBackToPointBehavior.this.livingEntity.isValid() || WanderBackToPointBehavior.this.mob.getNavigation().isDone() || WanderBackToPointBehavior.this.path == null || !WanderBackToPointBehavior.this.path.canReach()) {
                        this.cancel();
                        if (WanderBackToPointBehavior.this.livingEntity.isValid() && (WanderBackToPointBehavior.this.path == null || !WanderBackToPointBehavior.this.path.canReach()) && WanderBackToPointBehavior.this.teleportOnFail) {
                            WanderBackToPointBehavior.this.livingEntity.teleport(WanderBackToPointBehavior.this.returnLocation);
                        }
                        return;
                    }
                    WanderBackToPointBehavior.this.mob.getNavigation().moveTo(WanderBackToPointBehavior.this.path, (double)WanderBackToPointBehavior.this.speed);
                }
            }.runTaskTimer(NMSManager.pluginProvider, 0L, 1L);
        }
    }

    protected void stop(ServerLevel var0, net.minecraft.world.entity.LivingEntity var1, long var2) {
        this.path = null;
        if (this.teleportOnFail && this.timedOut(this.maxDurationTicks)) {
            this.livingEntity.teleport(this.returnLocation);
        }
        WanderBackToPointEndEvent wanderBackToPointEndEvent = new WanderBackToPointEndEvent(this.hardObjective, this.livingEntity, this);
        Bukkit.getPluginManager().callEvent((Event)wanderBackToPointEndEvent);
        this.updateCooldown();
        this.mob.setAggressive(true);
    }

    protected boolean canStillUse(ServerLevel var0, net.minecraft.world.entity.LivingEntity var1, long var2) {
        this.mob.setTarget(null);
        if (this.path == null) {
            return false;
        }
        if (!this.hardObjective && this.mob.getTarget() instanceof Player) {
            return false;
        }
        return !this.path.isDone();
    }

    @Override
    public double getMaximumDistanceFromPoint() {
        return this.maximumDistanceFromPoint;
    }

    @Override
    public long getLastTime() {
        return this.lastTime;
    }

    @Override
    public LivingEntity getLivingEntity() {
        return this.livingEntity;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public int getMaxDurationTicks() {
        return this.maxDurationTicks;
    }

    @Override
    public float getSpeed() {
        return this.speed;
    }

    @Override
    public AbstractWanderBackToPoint setSpeed(float speed) {
        this.speed = speed;
        return this;
    }

    @Override
    public Location getReturnLocation() {
        return this.returnLocation;
    }

    @Override
    public int getStopReturnDistance() {
        return this.stopReturnDistance;
    }

    @Override
    public AbstractWanderBackToPoint setStopReturnDistance(int distance) {
        this.stopReturnDistance = distance;
        return this;
    }

    @Override
    public int getGoalRefreshCooldownTicks() {
        return this.goalRefreshCooldownTicks;
    }

    @Override
    public AbstractWanderBackToPoint setGoalRefreshCooldownTicks(int ticks) {
        this.goalRefreshCooldownTicks = ticks;
        return this;
    }

    @Override
    public boolean isHardObjective() {
        return this.hardObjective;
    }

    @Override
    public AbstractWanderBackToPoint setHardObjective(boolean hardObjective) {
        this.priority = -1;
        this.hardObjective = hardObjective;
        return this;
    }

    @Override
    public boolean isTeleportOnFail() {
        return this.teleportOnFail;
    }

    @Override
    public AbstractWanderBackToPoint setTeleportOnFail(boolean teleportOnFail) {
        this.teleportOnFail = teleportOnFail;
        return this;
    }

    @Override
    public boolean isStartWithCooldown() {
        return this.startWithCooldown;
    }

    @Override
    public AbstractWanderBackToPoint setStartWithCooldown(boolean startWithCooldown) {
        this.startWithCooldown = startWithCooldown;
        return this;
    }

    @Override
    public void updateCooldown() {
        this.lastTime = System.currentTimeMillis();
    }

    @Override
    public void register() {
        if (this.startWithCooldown) {
            this.updateCooldown();
        }
        this.mob.getBrain().addActivity(Activity.CORE, this.priority, ImmutableList.of((Object)this));
    }

    @Override
    public void unregister() {
    }
}

