/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.dataconverter;

import com.google.gson.Gson;
import com.magmaguy.freeminecraftmodels.MetadataHandler;
import com.magmaguy.freeminecraftmodels.dataconverter.CubeBlueprint;
import com.magmaguy.freeminecraftmodels.dataconverter.ParsedTexture;
import com.magmaguy.freeminecraftmodels.dataconverter.SkeletonBlueprint;
import com.magmaguy.freeminecraftmodels.magmacore.util.Logger;
import com.magmaguy.freeminecraftmodels.utils.StringToResourcePackFilename;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.bukkit.NamespacedKey;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BoneBlueprint {
    protected static final float ARMOR_STAND_HEAD_SIZE_MULTIPLIER = 0.4f;
    private static final float MODEL_SCALE = 4.0f;
    private static final float ARMOR_STAND_PIVOT_POINT_HEIGHT = 1.438f;
    public static NamespacedKey nameTagKey = new NamespacedKey(MetadataHandler.PLUGIN, "NameTag");
    private final List<CubeBlueprint> cubeBlueprintChildren = new ArrayList<CubeBlueprint>();
    private final String boneName;
    private final String originalModelName;
    private final String originalBoneName;
    private List<BoneBlueprint> boneBlueprintChildren = new ArrayList<BoneBlueprint>();
    private String modelID = null;
    private boolean nameTag = false;
    private BoneBlueprint parent = null;
    private boolean isDisplayModel = true;
    private Vector3f blueprintModelCenter = new Vector3f();
    private Vector3f blueprintModelPivot;
    private Vector3f blueprintOriginalBoneRotation = new Vector3f();
    private boolean isHead = false;
    private BoneBlueprint metaBone = null;
    private File file;

    public BoneBlueprint(String modelName, BoneBlueprint parent, SkeletonBlueprint skeletonBlueprint) {
        this.originalBoneName = "freeminecraftmodels_autogenerated_root";
        this.boneName = "freeminecraftmodels:" + modelName + "/" + StringToResourcePackFilename.convert(this.originalBoneName);
        this.originalModelName = modelName;
        this.parent = parent;
        skeletonBlueprint.getBoneMap().put(this.originalBoneName, this);
        this.blueprintModelPivot = new Vector3f();
        this.blueprintOriginalBoneRotation = new Vector3f();
    }

    public BoneBlueprint(List<ParsedTexture> parsedTextures, Map<String, Object> boneJSON, HashMap<String, Object> values, Map<String, Map<String, Object>> textureReferences, String modelName, BoneBlueprint parent, SkeletonBlueprint skeletonBlueprint, double resolutionWidth, double resolutionHeight) {
        this.originalBoneName = (String)boneJSON.get("name");
        this.boneName = "freeminecraftmodels:" + modelName + "/" + StringToResourcePackFilename.convert(this.originalBoneName);
        this.originalModelName = modelName;
        this.parent = parent;
        if (this.originalBoneName.startsWith("tag_")) {
            this.metaBone = new BoneBlueprint(boneJSON, modelName, parent, skeletonBlueprint);
        }
        if (this.originalBoneName.startsWith("b_") || this.originalBoneName.equalsIgnoreCase("hitbox")) {
            this.isDisplayModel = false;
        }
        if (this.originalBoneName.startsWith("h_")) {
            this.isHead = true;
        }
        skeletonBlueprint.getBoneMap().put(this.originalBoneName, this);
        this.processChildren(parsedTextures, boneJSON, modelName, values, textureReferences, skeletonBlueprint, resolutionWidth, resolutionHeight);
        this.adjustCubes();
        this.processBoneValues(boneJSON);
        String filename = StringToResourcePackFilename.convert(this.originalBoneName);
        this.generateAndWriteCubes(filename, textureReferences, modelName);
    }

    public BoneBlueprint(Map<String, Object> boneJSON, String modelName, BoneBlueprint parent, SkeletonBlueprint skeletonBlueprint) {
        this.originalBoneName = "fmm_nametag_bone_" + String.valueOf(boneJSON.get("name"));
        this.boneName = "freeminecraftmodels:" + modelName + "/" + StringToResourcePackFilename.convert(this.originalBoneName);
        this.originalModelName = modelName;
        this.parent = parent;
        this.nameTag = true;
        skeletonBlueprint.getBoneMap().put(this.originalBoneName, this);
        this.processBoneValues(boneJSON);
    }

    public Vector3f getBlueprintOriginalBoneRotation() {
        return new Vector3f((Vector3fc)this.blueprintOriginalBoneRotation);
    }

    public boolean isDisplayModel() {
        return this.isDisplayModel && (this.modelID != null || this.nameTag);
    }

    public Vector3f getModelCenter() {
        float rpToBlocks = 0.0625f;
        float unscale = 2.5f;
        return new Vector3f((Vector3fc)this.blueprintModelCenter).mul(rpToBlocks * unscale);
    }

    public Vector3f getBlueprintModelPivot() {
        return new Vector3f((Vector3fc)this.blueprintModelPivot);
    }

    private void adjustCubes() {
        if (this.cubeBlueprintChildren.isEmpty()) {
            return;
        }
        Float lowestX = null;
        Float lowestY = null;
        Float lowestZ = null;
        Float highestX = null;
        Float highestY = null;
        Float highestZ = null;
        for (CubeBlueprint cubeBlueprint : this.cubeBlueprintChildren) {
            if (lowestX == null || cubeBlueprint.getFrom().get(0) < lowestX.floatValue()) {
                lowestX = Float.valueOf(cubeBlueprint.getFrom().get(0));
            }
            if (lowestY == null || cubeBlueprint.getFrom().get(1) < lowestY.floatValue()) {
                lowestY = Float.valueOf(cubeBlueprint.getFrom().get(1));
            }
            if (lowestZ == null || cubeBlueprint.getFrom().get(2) < lowestZ.floatValue()) {
                lowestZ = Float.valueOf(cubeBlueprint.getFrom().get(2));
            }
            if (highestX == null || cubeBlueprint.getTo().get(0) > highestX.floatValue()) {
                highestX = Float.valueOf(cubeBlueprint.getTo().get(0));
            }
            if (highestY == null || cubeBlueprint.getTo().get(1) > highestY.floatValue()) {
                highestY = Float.valueOf(cubeBlueprint.getTo().get(1));
            }
            if (highestZ != null && !(cubeBlueprint.getTo().get(2) > highestZ.floatValue())) continue;
            highestZ = Float.valueOf(cubeBlueprint.getTo().get(2));
        }
        float xSize = Math.abs(highestX.floatValue() - lowestX.floatValue());
        float ySize = Math.abs(highestY.floatValue() - lowestY.floatValue());
        float zSize = Math.abs(highestZ.floatValue() - lowestZ.floatValue());
        if (xSize > 192.0f || ySize > 192.0f || zSize > 192.0f) {
            Logger.warn("Model " + this.originalModelName + " has a boneBlueprint or set of cubes which exceeds the maximum size! Either make the cubes smaller, less far apart or split them up into multiple bones!");
        }
        float newLowestX = 8.0f - xSize / 2.0f;
        float newLowestY = 8.0f - ySize / 2.0f;
        float newLowestZ = 8.0f - zSize / 2.0f;
        float xOffset = lowestX.floatValue() - newLowestX;
        float yOffset = lowestY.floatValue() - newLowestY;
        float zOffset = lowestZ.floatValue() - newLowestZ;
        Vector3f cubeOffset = new Vector3f(xOffset, yOffset, zOffset);
        for (CubeBlueprint cubeBlueprint : this.cubeBlueprintChildren) {
            cubeBlueprint.setBoneOffset(cubeOffset);
            cubeBlueprint.shiftPosition();
            cubeBlueprint.shiftRotation();
        }
        cubeOffset.add((Vector3fc)new Vector3f(8.0f, 8.0f, 8.0f));
        this.blueprintModelCenter = cubeOffset;
    }

    private void processBoneValues(Map<String, Object> boneJSON) {
        this.setOrigin(boneJSON);
        this.setBoneRotation(boneJSON);
        if (this.isNameTag()) {
            List origins = (List)boneJSON.get("origin");
            this.blueprintModelCenter = new Vector3f(((Double)origins.get(0)).floatValue(), ((Double)origins.get(1)).floatValue() + 18.0f, ((Double)origins.get(2)).floatValue()).mul(0.0625f).mul(6.4f);
        }
    }

    private void processChildren(List<ParsedTexture> parsedTextures, Map<String, Object> boneJSON, String modelName, HashMap<String, Object> values, Map<String, Map<String, Object>> textureReferences, SkeletonBlueprint skeletonBlueprint, double resolutionWidth, double resolutionHeight) {
        ArrayList childrenValues = (ArrayList)boneJSON.get("children");
        for (Object object : childrenValues) {
            if (object instanceof String) {
                CubeBlueprint cubeBlueprint = new CubeBlueprint(parsedTextures, (Map)values.get(object), modelName, resolutionWidth, resolutionHeight);
                if (cubeBlueprint.isValidatedData()) {
                    this.cubeBlueprintChildren.add(cubeBlueprint);
                    continue;
                }
                Logger.warn("Model " + modelName + " has an invalid configuration for its cubes!");
                continue;
            }
            BoneBlueprint boneBlueprint = new BoneBlueprint(parsedTextures, (Map)object, values, textureReferences, modelName, this, skeletonBlueprint, resolutionWidth, resolutionHeight);
            this.boneBlueprintChildren.add(boneBlueprint);
            if (boneBlueprint.getMetaBone() == null) continue;
            this.boneBlueprintChildren.add(boneBlueprint.getMetaBone());
        }
    }

    private void setBoneRotation(Map<?, ?> boneJSON) {
        Object boneRotation = boneJSON.get("rotation");
        if (boneRotation == null) {
            return;
        }
        List rotations = (List)boneRotation;
        this.blueprintOriginalBoneRotation = new Vector3f((float)Math.toRadians((Double)rotations.get(0)), (float)Math.toRadians((Double)rotations.get(1)), (float)Math.toRadians((Double)rotations.get(2)));
    }

    private void setOrigin(Map<String, Object> boneJSON) {
        Object obj = boneJSON.get("origin");
        if (obj == null) {
            return;
        }
        List origins = (List)obj;
        this.blueprintModelPivot = this.getModelCenter().sub((Vector3fc)new Vector3f(((Double)origins.get(0)).floatValue(), ((Double)origins.get(1)).floatValue(), ((Double)origins.get(2)).floatValue()).mul(0.0625f));
    }

    private void generateAndWriteCubes(String filename, Map<String, Map<String, Object>> textureReferences, String modelName) {
        if (filename.equalsIgnoreCase("hitbox") || filename.equalsIgnoreCase("tag_name") || this.cubeBlueprintChildren.isEmpty()) {
            return;
        }
        HashMap<String, Object> textureReferencesClone = new HashMap<String, Object>(textureReferences);
        this.setDisplay(textureReferencesClone);
        this.writeCubes(textureReferencesClone);
        this.writeFile(modelName, filename, textureReferencesClone);
    }

    private String getModelDirectory(String modelName) {
        return MetadataHandler.PLUGIN.getDataFolder().getAbsolutePath() + File.separatorChar + "output" + File.separatorChar + "FreeMinecraftModels" + File.separatorChar + "assets" + File.separatorChar + "freeminecraftmodels" + File.separatorChar + "models" + File.separatorChar + modelName;
    }

    private void writeCubes(Map<String, Object> textureReferencesClone) {
        ArrayList<Map<String, Object>> cubeJSONs = new ArrayList<Map<String, Object>>();
        for (CubeBlueprint cubeBlueprint : this.cubeBlueprintChildren) {
            cubeJSONs.add(cubeBlueprint.getCubeJSON());
        }
        textureReferencesClone.put("elements", cubeJSONs);
    }

    private void setDisplay(Map<String, Object> textureReferencesClone) {
        textureReferencesClone.put("display", Map.of("head", Map.of("translation", List.of(Integer.valueOf(0), Double.valueOf(-6.4), Integer.valueOf(0)), "scale", List.of(Float.valueOf(4.0f), Float.valueOf(4.0f), Float.valueOf(4.0f)))));
    }

    private void writeFile(String modelName, String filename, Map<String, Object> boneJSON) {
        String modelDirectory = this.getModelDirectory(modelName);
        Gson gson = new Gson();
        try {
            this.file = new File(modelDirectory + File.separatorChar + filename + ".json");
            FileUtils.writeStringToFile(this.file, gson.toJson(boneJSON), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            Logger.warn("Failed to write boneBlueprint resource packs for boneBlueprint " + filename + "!");
            throw new RuntimeException(e);
        }
    }

    public static float getARMOR_STAND_PIVOT_POINT_HEIGHT() {
        return 1.438f;
    }

    public List<CubeBlueprint> getCubeBlueprintChildren() {
        return this.cubeBlueprintChildren;
    }

    public String getBoneName() {
        return this.boneName;
    }

    public String getOriginalModelName() {
        return this.originalModelName;
    }

    public String getOriginalBoneName() {
        return this.originalBoneName;
    }

    public List<BoneBlueprint> getBoneBlueprintChildren() {
        return this.boneBlueprintChildren;
    }

    public void setBoneBlueprintChildren(List<BoneBlueprint> boneBlueprintChildren) {
        this.boneBlueprintChildren = boneBlueprintChildren;
    }

    public String getModelID() {
        return this.modelID;
    }

    public void setModelID(String modelID) {
        this.modelID = modelID;
    }

    public boolean isNameTag() {
        return this.nameTag;
    }

    public BoneBlueprint getParent() {
        return this.parent;
    }

    public boolean isHead() {
        return this.isHead;
    }

    public BoneBlueprint getMetaBone() {
        return this.metaBone;
    }

    public File getFile() {
        return this.file;
    }
}

