/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.customentity.core.components;

import com.magmaguy.freeminecraftmodels.MetadataHandler;
import com.magmaguy.freeminecraftmodels.api.ModeledEntityHitByProjectileEvent;
import com.magmaguy.freeminecraftmodels.api.ModeledEntityHitboxContactEvent;
import com.magmaguy.freeminecraftmodels.api.ModeledEntityLeftClickEvent;
import com.magmaguy.freeminecraftmodels.api.ModeledEntityRightClickEvent;
import com.magmaguy.freeminecraftmodels.customentity.ModeledEntity;
import com.magmaguy.freeminecraftmodels.customentity.ModeledEntityHitboxContactCallback;
import com.magmaguy.freeminecraftmodels.customentity.ModeledEntityLeftClickCallback;
import com.magmaguy.freeminecraftmodels.customentity.ModeledEntityRightClickCallback;
import com.magmaguy.freeminecraftmodels.customentity.core.components.ModeledEntityHitByProjectileCallback;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.scheduler.BukkitRunnable;

public class InteractionComponent {
    private final ModeledEntity modeledEntity;
    private ModeledEntityLeftClickCallback leftClickCallback;
    private ModeledEntityRightClickCallback rightClickCallback;
    private ModeledEntityHitboxContactCallback hitboxContactCallback;
    private ModeledEntityHitByProjectileCallback projectileHitCallback;

    public InteractionComponent(ModeledEntity modeledEntity) {
        this.modeledEntity = modeledEntity;
    }

    public void callLeftClickEvent(Player player) {
        ModeledEntityLeftClickEvent event = new ModeledEntityLeftClickEvent(player, this.modeledEntity);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public void callRightClickEvent(Player player) {
        ModeledEntityRightClickEvent event = new ModeledEntityRightClickEvent(player, this.modeledEntity);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    protected void callHitboxContactEvent(final Player player) {
        new BukkitRunnable(){

            public void run() {
                ModeledEntityHitboxContactEvent event = new ModeledEntityHitboxContactEvent(player, InteractionComponent.this.modeledEntity);
                Bukkit.getPluginManager().callEvent((Event)event);
            }
        }.runTask(MetadataHandler.PLUGIN);
    }

    public void callModeledEntityHitByProjectileEvent(final Projectile projectile) {
        new BukkitRunnable(){

            public void run() {
                ModeledEntityHitByProjectileEvent event = new ModeledEntityHitByProjectileEvent(projectile, InteractionComponent.this.modeledEntity);
                Bukkit.getPluginManager().callEvent((Event)event);
            }
        }.runTask(MetadataHandler.PLUGIN);
    }

    public void handleLeftClickEvent(Player player) {
        if (this.leftClickCallback == null) {
            return;
        }
        this.leftClickCallback.onLeftClick(player, this.modeledEntity);
    }

    public void handleRightClickEvent(Player player) {
        if (this.rightClickCallback == null) {
            return;
        }
        this.rightClickCallback.onRightClick(player, this.modeledEntity);
    }

    public void handleHitboxContactEvent(Player player) {
        if (this.hitboxContactCallback == null) {
            return;
        }
        this.hitboxContactCallback.onHitboxContact(player, this.modeledEntity);
    }

    public void handleModeledEntityHitByProjectileEvent(Projectile projectile) {
        if (this.projectileHitCallback == null) {
            return;
        }
        this.projectileHitCallback.onHitByProjectile(projectile, this.modeledEntity);
    }

    public void clearCallbacks() {
        this.leftClickCallback = null;
        this.rightClickCallback = null;
        this.hitboxContactCallback = null;
    }

    public void setLeftClickCallback(ModeledEntityLeftClickCallback leftClickCallback) {
        this.leftClickCallback = leftClickCallback;
    }

    public void setRightClickCallback(ModeledEntityRightClickCallback rightClickCallback) {
        this.rightClickCallback = rightClickCallback;
    }

    public void setHitboxContactCallback(ModeledEntityHitboxContactCallback hitboxContactCallback) {
        this.hitboxContactCallback = hitboxContactCallback;
    }

    public ModeledEntityHitboxContactCallback getHitboxContactCallback() {
        return this.hitboxContactCallback;
    }

    public void setProjectileHitCallback(ModeledEntityHitByProjectileCallback projectileHitCallback) {
        this.projectileHitCallback = projectileHitCallback;
    }

    public ModeledEntityHitByProjectileCallback getProjectileHitCallback() {
        return this.projectileHitCallback;
    }

    public static class InteractionComponentEvents
    implements Listener {
        @EventHandler
        public void onLeftClick(ModeledEntityLeftClickEvent event) {
            if (event.isCancelled()) {
                return;
            }
            event.getEntity().getInteractionComponent().handleLeftClickEvent(event.getPlayer());
        }

        @EventHandler
        public void onRightClick(ModeledEntityRightClickEvent event) {
            if (event.isCancelled()) {
                return;
            }
            event.getEntity().getInteractionComponent().handleRightClickEvent(event.getPlayer());
        }

        @EventHandler
        public void onHitboxContact(ModeledEntityHitboxContactEvent event) {
            if (event.isCancelled()) {
                return;
            }
            event.getEntity().getInteractionComponent().handleHitboxContactEvent(event.getPlayer());
        }

        @EventHandler
        public void onProjectileHit(ModeledEntityHitByProjectileEvent event) {
            if (event.isCancelled()) {
                return;
            }
            event.getEntity().getInteractionComponent().handleModeledEntityHitByProjectileEvent(event.getProjectile());
        }
    }
}

