/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.customentity.core.components;

import com.magmaguy.freeminecraftmodels.customentity.ModeledEntity;
import com.magmaguy.freeminecraftmodels.customentity.core.OrientedBoundingBox;
import com.magmaguy.freeminecraftmodels.easyminecraftgoals.NMSManager;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;

public class HitboxComponent {
    private final ModeledEntity modeledEntity;
    private OrientedBoundingBox obbHitbox = null;

    public HitboxComponent(ModeledEntity modeledEntity) {
        this.modeledEntity = modeledEntity;
    }

    public OrientedBoundingBox getObbHitbox() {
        if (this.obbHitbox == null) {
            if (this.modeledEntity.getSkeletonBlueprint().getHitbox() != null) {
                this.obbHitbox = new OrientedBoundingBox(this.modeledEntity.getSkeleton().getCurrentLocation(), this.modeledEntity.getSkeletonBlueprint().getHitbox().getWidthZ(), this.modeledEntity.getSkeletonBlueprint().getHitbox().getHeight(), this.modeledEntity.getSkeletonBlueprint().getHitbox().getWidthX());
                this.obbHitbox.setAssociatedEntity(this.modeledEntity);
                return this.obbHitbox;
            }
            this.obbHitbox = new OrientedBoundingBox(this.modeledEntity.getSkeleton().getCurrentLocation(), 1.0, 2.0, 1.0);
            this.obbHitbox.setAssociatedEntity(this.modeledEntity);
            return this.obbHitbox;
        }
        return this.obbHitbox;
    }

    public void tick(int tickCounter) {
        this.getObbHitbox().update(this.modeledEntity.getLocation());
        if (this.modeledEntity.getInteractionComponent().getHitboxContactCallback() == null) {
            return;
        }
        if (tickCounter % 2 == 0) {
            this.checkPlayerCollisions();
        }
    }

    public void checkPlayerCollisions() {
        if (this.modeledEntity.getHitboxComponent().getObbHitbox() == null) {
            return;
        }
        List nearbyPlayers = this.modeledEntity.getWorld().getPlayers().stream().filter(player -> player.getLocation().distanceSquared(this.modeledEntity.getLocation()) < Math.pow(10.0, 2.0)).collect(Collectors.toList());
        for (Player player2 : nearbyPlayers) {
            if (!this.isPlayerColliding(player2)) continue;
            this.modeledEntity.getInteractionComponent().callHitboxContactEvent(player2);
        }
    }

    protected boolean isPlayerColliding(Player player) {
        return this.getObbHitbox().isAABBCollidingWithOBB(player.getBoundingBox());
    }

    public void setCustomHitboxOnUnderlyingEntity() {
        if (this.modeledEntity.getSkeletonBlueprint().getHitbox() == null) {
            return;
        }
        NMSManager.getAdapter().setCustomHitbox(this.modeledEntity.getUnderlyingEntity(), this.modeledEntity.getSkeletonBlueprint().getHitbox().getWidthX() < this.modeledEntity.getSkeletonBlueprint().getHitbox().getWidthZ() ? (float)this.modeledEntity.getSkeletonBlueprint().getHitbox().getWidthX() : (float)this.modeledEntity.getSkeletonBlueprint().getHitbox().getWidthZ(), (float)this.modeledEntity.getSkeletonBlueprint().getHitbox().getHeight(), true);
    }
}

