/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.customentity.core.components;

import com.magmaguy.freeminecraftmodels.customentity.ModeledEntity;
import com.magmaguy.freeminecraftmodels.customentity.core.OBBHitDetection;
import com.magmaguy.freeminecraftmodels.magmacore.util.AttributeManager;
import org.bukkit.attribute.Attribute;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;

public class DamageableComponent {
    private final ModeledEntity modeledEntity;
    private final boolean internallyImmortal = false;
    private double internalHealth = 1.0;

    public DamageableComponent(ModeledEntity modeledEntity) {
        this.modeledEntity = modeledEntity;
    }

    private void handleNonLivingEntityDamage(double amount) {
        this.internalHealth -= amount;
        if (this.internalHealth <= 0.0) {
            this.modeledEntity.removeWithDeathAnimation();
        }
        this.modeledEntity.getSkeleton().tint();
    }

    public void damage(double amount) {
        Entity entity = this.modeledEntity.getUnderlyingEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            OBBHitDetection.applyDamage = true;
            livingEntity.damage(amount);
            OBBHitDetection.applyDamage = false;
        } else {
            this.handleNonLivingEntityDamage(amount);
        }
        this.modeledEntity.getSkeleton().tint();
    }

    public void damage(Entity damager, double amount) {
        Entity entity = this.modeledEntity.getUnderlyingEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.damage(amount, damager);
        } else {
            this.handleNonLivingEntityDamage(amount);
        }
        this.modeledEntity.getSkeleton().tint();
    }

    public void damage(Entity damager) {
        LivingEntity livingEntity;
        Entity entity = this.modeledEntity.getUnderlyingEntity();
        if (entity instanceof LivingEntity && !(livingEntity = (LivingEntity)entity).getType().equals((Object)EntityType.ARMOR_STAND) && damager instanceof LivingEntity) {
            LivingEntity damagerLivingEntity = (LivingEntity)damager;
            damagerLivingEntity.attack((Entity)livingEntity);
        } else {
            this.handleNonLivingEntityDamage(1.0);
        }
        this.modeledEntity.getSkeleton().tint();
    }

    public boolean damage(Projectile projectile) {
        double damage = 0.0;
        if (projectile.getShooter() != null && projectile.getShooter().equals((Object)this.modeledEntity.getUnderlyingEntity())) {
            return false;
        }
        if (!(projectile instanceof Arrow)) {
            return false;
        }
        Arrow arrow = (Arrow)projectile;
        double speed = arrow.getVelocity().length();
        damage = Math.ceil(speed * arrow.getDamage());
        boolean piercing = false;
        ProjectileSource projectileSource = arrow.getShooter();
        if (projectileSource instanceof LivingEntity) {
            LivingEntity shooter = (LivingEntity)projectileSource;
            ItemStack bow = null;
            try {
                bow = arrow.getWeapon();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bow != null && bow.containsEnchantment(Enchantment.POWER)) {
                int level = bow.getEnchantmentLevel(Enchantment.POWER);
                double bonus = Math.ceil(0.25 * (double)(level + 1) * damage);
                damage += bonus;
            }
            if (bow != null && bow.containsEnchantment(Enchantment.PIERCING)) {
                piercing = true;
            }
        }
        if ((projectileSource = projectile.getShooter()) instanceof LivingEntity) {
            LivingEntity damager = (LivingEntity)projectileSource;
            this.damage((Entity)damager, damage);
        } else {
            this.damage((Entity)projectile.getShooter(), damage);
        }
        this.modeledEntity.getSkeleton().tint();
        if (!piercing) {
            arrow.remove();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void attack(LivingEntity target) {
        Attribute attribute = AttributeManager.getAttribute("generic_attack_damage");
        Entity entity = this.modeledEntity.getUnderlyingEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity underlyingLivingEntity = (LivingEntity)entity;
            if (attribute != null && underlyingLivingEntity.getAttribute(attribute) != null) {
                OBBHitDetection.applyDamage = true;
                underlyingLivingEntity.attack((Entity)target);
                OBBHitDetection.applyDamage = false;
                return;
            }
        }
        OBBHitDetection.applyDamage = true;
        target.damage(2.0, this.modeledEntity.getUnderlyingEntity());
        OBBHitDetection.applyDamage = false;
    }

    public void attack(LivingEntity target, double damage) {
        OBBHitDetection.applyDamage = true;
        target.damage(damage, this.modeledEntity.getUnderlyingEntity());
        OBBHitDetection.applyDamage = false;
    }

    public boolean isInternallyImmortal() {
        return this.internallyImmortal;
    }

    public double getInternalHealth() {
        return this.internalHealth;
    }

    public void setInternalHealth(double internalHealth) {
        this.internalHealth = internalHealth;
    }
}

