/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.animation;

import com.magmaguy.freeminecraftmodels.animation.Animation;
import com.magmaguy.freeminecraftmodels.animation.AnimationStateConfig;
import com.magmaguy.freeminecraftmodels.animation.AnimationStateType;
import com.magmaguy.freeminecraftmodels.animation.Animations;
import com.magmaguy.freeminecraftmodels.animation.AttackState;
import com.magmaguy.freeminecraftmodels.animation.CustomAnimationState;
import com.magmaguy.freeminecraftmodels.animation.DeathState;
import com.magmaguy.freeminecraftmodels.animation.IAnimState;
import com.magmaguy.freeminecraftmodels.animation.IdleState;
import com.magmaguy.freeminecraftmodels.animation.SpawnState;
import com.magmaguy.freeminecraftmodels.animation.WalkState;
import com.magmaguy.freeminecraftmodels.customentity.ModeledEntity;
import com.magmaguy.freeminecraftmodels.dataconverter.AnimationFrame;
import com.magmaguy.freeminecraftmodels.dataconverter.AnimationsBlueprint;
import java.util.EnumMap;
import java.util.Map;

public class AnimationManager {
    private final Map<AnimationStateType, IAnimState> states = new EnumMap<AnimationStateType, IAnimState>(AnimationStateType.class);
    private final ModeledEntity modeledEntity;
    private final Animations animations;
    private IAnimState current;
    private IAnimState nextQueued;
    private AnimationStateType lastCommitted;

    public AnimationManager(ModeledEntity modeledEntity, AnimationsBlueprint bp) {
        this.modeledEntity = modeledEntity;
        this.animations = new Animations(bp, modeledEntity);
        if (this.animations.getAnimations().get("idle") != null) {
            this.states.put(AnimationStateType.IDLE, new IdleState(modeledEntity, new AnimationStateConfig(this.animations.getAnimations().get("idle"), true)));
        }
        if (this.animations.getAnimations().get("walk") != null) {
            this.states.put(AnimationStateType.WALK, new WalkState(modeledEntity, new AnimationStateConfig(this.animations.getAnimations().get("walk"), true)));
        }
        if (this.animations.getAnimations().get("attack") != null) {
            this.states.put(AnimationStateType.ATTACK, new AttackState(new AnimationStateConfig(this.animations.getAnimations().get("attack"), false)));
        }
        if (this.animations.getAnimations().get("death") != null) {
            this.states.put(AnimationStateType.DEATH, new DeathState(modeledEntity, new AnimationStateConfig(this.animations.getAnimations().get("death"), false)));
        }
        if (this.animations.getAnimations().get("spawn") != null) {
            this.states.put(AnimationStateType.SPAWN, new SpawnState(new AnimationStateConfig(this.animations.getAnimations().get("spawn"), false)));
        }
        this.lastCommitted = null;
        IAnimState iAnimState = this.current = this.states.get((Object)AnimationStateType.SPAWN) != null ? this.states.get((Object)AnimationStateType.SPAWN) : this.states.get((Object)AnimationStateType.IDLE);
        if (this.current != null) {
            this.current.enter();
        }
    }

    private void transitionTo(IAnimState target) {
        if (target == null || target == this.current) {
            return;
        }
        if (this.current != null) {
            this.current.exit();
        }
        if (this.current != null && !(this.current instanceof CustomAnimationState)) {
            this.lastCommitted = this.current.getType();
        }
        this.current = target;
        this.current.enter();
    }

    public boolean play(String name, boolean blendAnimation, boolean loop) {
        AnimationStateType st = null;
        try {
            st = AnimationStateType.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (st != null && this.states.containsKey((Object)st)) {
            IAnimState builtIn = this.states.get((Object)st);
            if (blendAnimation) {
                this.nextQueued = builtIn;
            } else {
                this.transitionTo(builtIn);
            }
            return true;
        }
        Animation anim = this.animations.getAnimations().get(name);
        if (anim == null) {
            return false;
        }
        CustomAnimationState custom = new CustomAnimationState(this.modeledEntity, anim, loop, this.lastCommitted != null ? this.lastCommitted : AnimationStateType.IDLE);
        if (blendAnimation) {
            this.nextQueued = custom;
        } else {
            this.transitionTo(custom);
        }
        return true;
    }

    public void stop() {
        this.current.exit();
        this.transitionTo(this.states.get((Object)AnimationStateType.IDLE));
    }

    public void tick() {
        if (this.current == null) {
            return;
        }
        this.current.update();
        this.renderCurrentFrame();
        if (this.nextQueued != null) {
            this.transitionTo(this.nextQueued);
            this.nextQueued = null;
        } else {
            this.current.nextState().ifPresent(stateType -> {
                IAnimState next = this.states.get(stateType);
                this.transitionTo(next);
            });
        }
    }

    private void renderCurrentFrame() {
        Animation anim = this.current.getAnimation();
        boolean loop = this.current.isLoop();
        int duration = anim.getAnimationBlueprint().getDuration();
        long counter = anim.getCounter();
        if (duration == 0) {
            return;
        }
        if (!loop && counter >= (long)duration) {
            return;
        }
        int frame = loop ? (int)(counter % (long)duration) : (int)Math.min(counter, (long)(duration - 1));
        anim.getAnimationFrames().forEach((part, frames) -> {
            if (frames == null || ((AnimationFrame[])frames).length <= frame) {
                part.updateAnimationRotation(0.0, 0.0, 0.0);
                part.updateAnimationTranslation(0.0f, 0.0f, 0.0f);
                part.updateAnimationScale(1.0f, 1.0f, 1.0f);
            } else {
                AnimationFrame f = frames[frame];
                part.updateAnimationRotation(f.xRotation, f.yRotation, f.zRotation);
                part.updateAnimationTranslation(f.xPosition, f.yPosition, f.zPosition);
                part.updateAnimationScale(f.scaleX != null ? f.scaleX.floatValue() : 1.0f, f.scaleY != null ? f.scaleY.floatValue() : 1.0f, f.scaleZ != null ? f.scaleZ.floatValue() : 1.0f);
            }
        });
        anim.incrementCounter();
    }

    public boolean hasAnimation(String animationName) {
        return this.animations.getAnimations().containsKey(animationName);
    }
}

