/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.customentity.core;

import com.magmaguy.freeminecraftmodels.MetadataHandler;
import com.magmaguy.freeminecraftmodels.api.ModeledEntityManager;
import com.magmaguy.freeminecraftmodels.customentity.ModeledEntity;
import com.magmaguy.freeminecraftmodels.customentity.core.OrientedBoundingBox;
import com.magmaguy.freeminecraftmodels.customentity.core.RegisterModelEntity;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class OBBHitDetection
implements Listener {
    public static boolean applyDamage = false;
    private static Set<Projectile> activeProjectiles = ConcurrentHashMap.newKeySet();
    private static BukkitTask projectileDetectionTask = null;
    private static final HashSet<Player> leftClickCooldownPlayers = new HashSet();
    private static final HashSet<Player> rightClickCooldownPlayers = new HashSet();
    private static HashMap<Player, Float> attackCooldowns = new HashMap();

    @EventHandler(priority=EventPriority.LOWEST)
    public void EntityDamageByEntityEvent(EntityDamageByEntityEvent event) {
        if (!RegisterModelEntity.isModelEntity(event.getEntity()) || event.getDamageSource().getDamageType().equals(DamageType.MOB_ATTACK) && !RegisterModelEntity.isModelEntity(event.getDamager())) {
            return;
        }
        if (applyDamage) {
            applyDamage = false;
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void blockBreakEvent(BlockBreakEvent event) {
        if (!event.getPlayer().getWorld().equals(event.getBlock().getWorld())) {
            return;
        }
        double blockDistance = event.getPlayer().getEyeLocation().distance(event.getBlock().getLocation().add(0.5, 0.5, 0.5));
        Optional<ModeledEntity> hitEntityOpt = OrientedBoundingBox.raytraceFromPlayer(event.getPlayer());
        if (hitEntityOpt.isEmpty()) {
            return;
        }
        ModeledEntity hitEntity = hitEntityOpt.get();
        if (hitEntity.getLocation() == null || !event.getPlayer().getWorld().equals(hitEntity.getLocation().getWorld())) {
            return;
        }
        double entityDistance = event.getPlayer().getEyeLocation().distance(hitEntity.getLocation());
        if (entityDistance <= blockDistance) {
            event.setCancelled(true);
        }
    }

    public static void startProjectileDetection() {
        projectileDetectionTask = new BukkitRunnable(){

            public void run() {
                Iterator<Projectile> iter = activeProjectiles.iterator();
                block0: while (iter.hasNext()) {
                    final Projectile proj = iter.next();
                    if (!proj.isValid()) {
                        iter.remove();
                        continue;
                    }
                    for (ModeledEntity entity : ModeledEntityManager.getAllEntities()) {
                        if (entity.getWorld() == null || !entity.getWorld().equals(proj.getWorld()) || proj.getShooter() != null && entity.getUnderlyingEntity() != null && proj.getShooter().equals(entity.getUnderlyingEntity()) || !entity.getHitboxComponent().getObbHitbox().isAABBCollidingWithOBB(proj.getBoundingBox())) continue;
                        entity.getInteractionComponent().callModeledEntityHitByProjectileEvent(proj);
                        iter.remove();
                        new BukkitRunnable(){

                            public void run() {
                                proj.remove();
                            }
                        }.runTask(MetadataHandler.PLUGIN);
                        continue block0;
                    }
                }
            }
        }.runTaskTimer(MetadataHandler.PLUGIN, 0L, 1L);
    }

    public static void shutdown() {
        activeProjectiles.clear();
        leftClickCooldownPlayers.clear();
        rightClickCooldownPlayers.clear();
        attackCooldowns.clear();
        if (projectileDetectionTask != null) {
            projectileDetectionTask.cancel();
            projectileDetectionTask = null;
        }
    }

    private static void executeLeftClickAttack(Player player) {
        OBBHitDetection.executePlayerInteraction(player, leftClickCooldownPlayers, hitEntity -> hitEntity.getInteractionComponent().callLeftClickEvent(player));
    }

    private static void executeRightClickInteraction(Player player) {
        OBBHitDetection.executePlayerInteraction(player, rightClickCooldownPlayers, hitEntity -> hitEntity.getInteractionComponent().callRightClickEvent(player));
    }

    private static void executePlayerInteraction(final Player player, final HashSet<Player> cooldownSet, Consumer<ModeledEntity> interactionCallback) {
        if (cooldownSet.contains(player)) {
            return;
        }
        cooldownSet.add(player);
        new BukkitRunnable(){

            public void run() {
                cooldownSet.remove(player);
            }
        }.runTaskLater(MetadataHandler.PLUGIN, 1L);
        Optional<ModeledEntity> hitEntity = OrientedBoundingBox.raytraceFromPlayer(player);
        if (hitEntity.isEmpty()) {
            return;
        }
        interactionCallback.accept(hitEntity.get());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Action action = event.getAction();
        if (action == Action.LEFT_CLICK_AIR || action == Action.LEFT_CLICK_BLOCK) {
            attackCooldowns.put(event.getPlayer(), Float.valueOf(event.getPlayer().getAttackCooldown()));
            OBBHitDetection.executeLeftClickAttack(event.getPlayer());
        } else if (action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK) {
            OBBHitDetection.executeRightClickInteraction(event.getPlayer());
        }
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        OBBHitDetection.executeLeftClickAttack(event.getPlayer());
    }

    @EventHandler
    public void EntityInteractEvent(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        OBBHitDetection.executeRightClickInteraction(event.getPlayer());
    }

    @EventHandler
    public void onProjectileCreate(ProjectileLaunchEvent event) {
        activeProjectiles.add(event.getEntity());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onEntityHitEvent(EntityDamageByEntityEvent event) {
        Projectile projectile;
        block6: {
            block5: {
                Entity entity = event.getDamager();
                if (!(entity instanceof Projectile)) break block5;
                projectile = (Projectile)entity;
                if (RegisterModelEntity.isModelEntity(event.getEntity())) break block6;
            }
            return;
        }
        event.setCancelled(true);
        ModeledEntity modeledEntity = null;
        for (ModeledEntity loadedModeledEntity : ModeledEntity.getLoadedModeledEntities()) {
            if (loadedModeledEntity.getUnderlyingEntity() == null || !loadedModeledEntity.getUnderlyingEntity().equals(event.getEntity())) continue;
            modeledEntity = loadedModeledEntity;
            break;
        }
        if (modeledEntity == null) {
            return;
        }
        modeledEntity.getInteractionComponent().callModeledEntityHitByProjectileEvent(projectile);
    }

    public static HashMap<Player, Float> getAttackCooldowns() {
        return attackCooldowns;
    }
}

