/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.customentity;

import com.magmaguy.freeminecraftmodels.MetadataHandler;
import com.magmaguy.freeminecraftmodels.customentity.ModeledEntity;
import com.magmaguy.freeminecraftmodels.customentity.core.ModeledEntityInterface;
import com.magmaguy.freeminecraftmodels.dataconverter.FileModelConverter;
import com.magmaguy.freeminecraftmodels.easyminecraftgoals.NMSManager;
import com.magmaguy.freeminecraftmodels.easyminecraftgoals.internal.AbstractPacketBundle;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Evoker;
import org.bukkit.entity.EvokerFangs;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.persistence.PersistentDataType;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DynamicEntity
extends ModeledEntity
implements ModeledEntityInterface {
    private static final HashMap<UUID, DynamicEntity> dynamicEntities = new HashMap();
    private static final NamespacedKey namespacedKey = new NamespacedKey(MetadataHandler.PLUGIN, "DynamicEntity");
    private final String name = "default";
    private boolean damagesOnContact = true;
    private boolean isEvokerAttacking = false;

    public DynamicEntity(String entityID, Location targetLocation) {
        super(entityID, targetLocation);
        this.setLeftClickCallback((player, entity) -> entity.damage((Entity)player));
        this.setModeledEntityHitByProjectileCallback((projectile, entity) -> entity.damage(projectile));
        this.setHitboxContactCallback((player, modeledEntity) -> {
            Mob mob;
            Entity patt1980$temp;
            LivingEntity livingEntity;
            if (!this.damagesOnContact) {
                return;
            }
            Entity patt1877$temp = this.underlyingEntity;
            if (patt1877$temp instanceof LivingEntity && !(livingEntity = (LivingEntity)patt1877$temp).hasAI() || (patt1980$temp = this.underlyingEntity) instanceof Mob && !(mob = (Mob)patt1980$temp).isAware()) {
                return;
            }
            modeledEntity.attack((LivingEntity)player);
        });
    }

    public static boolean isDynamicEntity(Entity entity) {
        return dynamicEntities.containsKey(entity.getUniqueId());
    }

    public static DynamicEntity getDynamicEntity(Entity entity) {
        return dynamicEntities.get(entity.getUniqueId());
    }

    public static @Nullable DynamicEntity create(String entityID, LivingEntity livingEntity) {
        FileModelConverter fileModelConverter = FileModelConverter.getConvertedFileModels().get(entityID);
        if (fileModelConverter == null) {
            return null;
        }
        DynamicEntity dynamicEntity = new DynamicEntity(entityID, livingEntity.getLocation());
        dynamicEntity.spawn(livingEntity);
        livingEntity.setVisibleByDefault(false);
        Bukkit.getOnlinePlayers().forEach(player -> {
            if (player.getLocation().getWorld().equals(dynamicEntity.getLocation().getWorld())) {
                player.hideEntity(MetadataHandler.PLUGIN, (Entity)livingEntity);
            }
        });
        livingEntity.getPersistentDataContainer().set(namespacedKey, PersistentDataType.BYTE, (Object)0);
        return dynamicEntity;
    }

    public void spawn(LivingEntity entity) {
        super.spawn((Entity)entity);
        dynamicEntities.put(entity.getUniqueId(), this);
        this.syncSkeletonWithEntity();
    }

    @Override
    public void tick(AbstractPacketBundle abstractPacketBundle) {
        this.syncSkeletonWithEntity();
        this.evokerWatchdog();
        super.tick(abstractPacketBundle);
    }

    private void evokerWatchdog() {
        Entity entity = this.underlyingEntity;
        if (!(entity instanceof Evoker)) {
            return;
        }
        Evoker evoker = (Evoker)entity;
        if (!this.hasAnimation("attack")) {
            return;
        }
        Bukkit.getScheduler().runTask(MetadataHandler.PLUGIN, () -> {
            if (!evoker.isValid()) {
                return;
            }
            boolean fangsNearby = evoker.getLocation().getWorld().getNearbyEntities(evoker.getLocation(), 2.0, 2.0, 2.0).stream().anyMatch(entity -> entity instanceof EvokerFangs);
            if (fangsNearby) {
                if (!this.isEvokerAttacking) {
                    this.playAnimation("attack", false, false);
                    this.isEvokerAttacking = true;
                }
            } else {
                this.isEvokerAttacking = false;
            }
        });
    }

    private void syncSkeletonWithEntity() {
        if (this.isDying()) {
            return;
        }
        if (this.underlyingEntity == null || !this.underlyingEntity.isValid()) {
            this.remove();
            return;
        }
        Entity entity = this.underlyingEntity;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.getSkeleton().setCurrentHeadPitch(livingEntity.getEyeLocation().getPitch());
            this.getSkeleton().setCurrentHeadYaw(livingEntity.getEyeLocation().getYaw());
        }
    }

    @Override
    public Location getLocation() {
        if (this.underlyingEntity != null) {
            return this.getBodyLocation();
        }
        return super.getLocation();
    }

    @Override
    public void remove() {
        super.remove();
        dynamicEntities.remove(this.underlyingEntity.getUniqueId());
    }

    public static void shutdown() {
        dynamicEntities.clear();
    }

    public Location getBodyLocation() {
        Location bodyLoc = this.underlyingEntity.getLocation().clone();
        float bodyYaw = NMSManager.getAdapter().getBodyRotation(this.underlyingEntity);
        Entity entity = this.underlyingEntity;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            float headYaw = livingEntity.getEyeLocation().getYaw();
            float delta = this.wrapDegrees(headYaw - bodyYaw);
            if (delta > 45.0f) {
                delta = 45.0f;
            }
            if (delta < -45.0f) {
                delta = -45.0f;
            }
            float newBodyYaw = headYaw - delta;
            bodyLoc.setYaw(newBodyYaw);
        }
        bodyLoc.setPitch(0.0f);
        return bodyLoc;
    }

    private float wrapDegrees(float angle) {
        if ((angle %= 360.0f) >= 180.0f) {
            angle -= 360.0f;
        }
        if (angle < -180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public static HashMap<UUID, DynamicEntity> getDynamicEntities() {
        return dynamicEntities;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isDamagesOnContact() {
        return this.damagesOnContact;
    }

    public void setDamagesOnContact(boolean damagesOnContact) {
        this.damagesOnContact = damagesOnContact;
    }

    public static class ModeledEntityEvents
    implements Listener {
        @EventHandler
        public void onEntityDeath(EntityDeathEvent event) {
            DynamicEntity dynamicEntity = DynamicEntity.getDynamicEntity((Entity)event.getEntity());
            if (dynamicEntity == null) {
                return;
            }
            dynamicEntity.removeWithDeathAnimation();
        }
    }
}

