/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.customentity.core.components;

import com.magmaguy.freeminecraftmodels.config.DefaultConfig;
import com.magmaguy.freeminecraftmodels.config.props.PropBlocks;
import com.magmaguy.freeminecraftmodels.customentity.ModeledEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class PropBlockComponent {
    public List<PropBlocks> propBlocks = new ArrayList<PropBlocks>();
    private ModeledEntity modeledEntity;

    public PropBlockComponent(ModeledEntity modeledEntity) {
        this.modeledEntity = modeledEntity;
    }

    public void setPropBlocks(List<PropBlocks> propBlocks) {
        this.propBlocks = propBlocks;
        Location spawnLocation = this.modeledEntity.getSpawnLocation();
        for (Player player : spawnLocation.getWorld().getPlayers()) {
            if (!(spawnLocation.distanceSquared(player.getLocation()) < Math.pow(DefaultConfig.maxModelViewDistance, 2.0))) continue;
            this.showFakePropBlocksToPlayer(player);
        }
    }

    public void showFakePropBlocksToPlayer(Player player) {
        for (PropBlocks propBlock : this.propBlocks) {
            Location finalLocation = propBlock.getProcessedLocation(this.modeledEntity.getSpawnLocation());
            player.sendBlockChange(finalLocation, propBlock.getMaterial().createBlockData());
        }
    }

    public void showFakePropBlocksToAllPlayers() {
        for (UUID viewer : this.modeledEntity.getSkeleton().getSkeletonWatchers().getViewers()) {
            Player player = Bukkit.getPlayer((UUID)viewer);
            if (player == null) continue;
            this.showFakePropBlocksToPlayer(player);
        }
    }

    public void showRealBlocksToPlayer(Player player) {
        for (PropBlocks propBlock : this.propBlocks) {
            Location finalLocation = propBlock.getProcessedLocation(this.modeledEntity.getSpawnLocation());
            player.sendBlockChange(finalLocation, finalLocation.getBlock().getBlockData());
        }
    }

    public void showRealBlocksToAllPlayers() {
        for (UUID viewer : this.modeledEntity.getSkeleton().getSkeletonWatchers().getViewers()) {
            Player player = Bukkit.getPlayer((UUID)viewer);
            if (player == null) continue;
            this.showRealBlocksToPlayer(player);
        }
    }
}

