/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.customentity.core;

import com.magmaguy.freeminecraftmodels.MetadataHandler;
import com.magmaguy.freeminecraftmodels.config.DefaultConfig;
import com.magmaguy.freeminecraftmodels.customentity.ModeledEntity;
import com.magmaguy.freeminecraftmodels.customentity.PropEntity;
import com.magmaguy.freeminecraftmodels.customentity.core.Bone;
import com.magmaguy.freeminecraftmodels.customentity.core.OrientedBoundingBox;
import com.magmaguy.freeminecraftmodels.customentity.core.Skeleton;
import com.magmaguy.freeminecraftmodels.easyminecraftgoals.internal.AbstractPacketBundle;
import com.magmaguy.freeminecraftmodels.thirdparty.BedrockChecker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.joml.Vector3d;

public class SkeletonWatchers
implements Listener {
    private final Skeleton skeleton;
    private final Set<UUID> viewers = new CopyOnWriteArraySet<UUID>();
    private final List<UUID> newPlayers = new ArrayList<UUID>();
    private final List<UUID> toRemove = new ArrayList<UUID>();
    private final int resetTimer = 1200;
    private int counter = ThreadLocalRandom.current().nextInt(1200);
    private int watcherUpdateCounter = 0;
    private static final int UPDATE_INTERVAL = 4;
    private volatile long lastResyncTime = 0L;
    private static final int MIN_VIEW_DISTANCE = 10;

    public HashSet<UUID> getViewers() {
        return new HashSet<UUID>(this.viewers);
    }

    public SkeletonWatchers(Skeleton skeleton) {
        this.skeleton = skeleton;
        this.tick();
    }

    public boolean hasObservers() {
        return !this.viewers.isEmpty();
    }

    public void tick() {
        ++this.watcherUpdateCounter;
        if (this.watcherUpdateCounter >= 4) {
            this.updateWatcherList();
            this.watcherUpdateCounter = 0;
        }
        this.resync(false);
    }

    public void resync(boolean force) {
        long now = System.currentTimeMillis();
        if (!force && now - this.lastResyncTime < 1000L) {
            return;
        }
        ++this.counter;
        if (force || this.counter > 1200 && ThreadLocalRandom.current().nextBoolean()) {
            this.lastResyncTime = now;
            this.counter = 0;
            Set<UUID> tempViewers = Collections.synchronizedSet(new HashSet<UUID>(this.viewers));
            tempViewers.forEach(viewer -> {
                this.hideFrom((UUID)viewer);
                Player p = Bukkit.getPlayer((UUID)viewer);
                if (p != null) {
                    this.displayTo(p);
                }
            });
        }
    }

    private void updateWatcherList() {
        if (this.skeleton.getCurrentLocation() == null) {
            return;
        }
        ArrayList<UUID> newPlayers = new ArrayList<UUID>();
        ArrayList<UUID> toRemove = new ArrayList<UUID>();
        double sightCheckDistanceMin = Math.pow(10.0, 2.0);
        double maxViewDistanceSquared = Math.pow(DefaultConfig.maxModelViewDistance, 2.0);
        for (Player player : this.skeleton.getCurrentLocation().getWorld().getPlayers()) {
            double distance = player.getLocation().distanceSquared(this.skeleton.getCurrentLocation());
            if (!(distance < sightCheckDistanceMin) && (!(distance < maxViewDistanceSquared) || !this.isModelInSight(player))) continue;
            newPlayers.add(player.getUniqueId());
            if (this.viewers.contains(player.getUniqueId())) continue;
            this.displayTo(player);
        }
        HashSet<UUID> viewerSnapshot = new HashSet<UUID>(this.viewers);
        for (UUID viewer : viewerSnapshot) {
            if (newPlayers.contains(viewer)) continue;
            toRemove.add(viewer);
        }
        toRemove.forEach(this.viewers::remove);
        toRemove.forEach(this::hideFrom);
    }

    private boolean isModelInSight(Player player) {
        if (this.skeleton.getModeledEntity() == null) {
            return true;
        }
        OrientedBoundingBox hitbox = this.skeleton.getModeledEntity().getHitboxComponent().getObbHitbox();
        if (hitbox == null) {
            return true;
        }
        Vector centerPoint = this.skeleton.getCurrentLocation().toVector();
        if (this.isPointVisible(player, centerPoint)) {
            return true;
        }
        Vector3d[] corners = hitbox.getCorners();
        if (this.isPointVisible(player, new Vector(corners[0].x, corners[0].y, corners[0].z))) {
            return true;
        }
        if (this.isPointVisible(player, new Vector(corners[4].x, corners[4].y, corners[4].z))) {
            return true;
        }
        if (this.isPointVisible(player, new Vector(corners[2].x, corners[2].y, corners[2].z))) {
            return true;
        }
        return this.isPointVisible(player, new Vector(corners[6].x, corners[6].y, corners[6].z));
    }

    private boolean isPointVisible(Player player, Vector point) {
        return this.isPointVisibleRecursive(player.getEyeLocation(), point, 5);
    }

    private boolean isPointVisibleRecursive(Location eyeLocation, Vector targetPoint, int remainingPasses) {
        if (remainingPasses <= 0) {
            return false;
        }
        Vector toPoint = targetPoint.clone().subtract(eyeLocation.toVector());
        double distance = toPoint.length();
        toPoint.normalize();
        RayTraceResult result = eyeLocation.getWorld().rayTraceBlocks(eyeLocation, toPoint, distance, FluidCollisionMode.NEVER, true);
        if (result == null) {
            return true;
        }
        if (result.getHitBlock() != null) {
            if (result.getHitBlock().getType().isOccluding()) {
                return false;
            }
            Location hitPos = result.getHitPosition().toLocation(eyeLocation.getWorld());
            Vector normalizedDirection = toPoint.clone().normalize();
            Location nextLocation = hitPos.clone().add(normalizedDirection.clone().multiply(2));
            return this.isPointVisibleRecursive(nextLocation, targetPoint, remainingPasses - 1);
        }
        return false;
    }

    private void displayTo(Player player) {
        boolean isBedrock = BedrockChecker.isBedrock(player);
        if (isBedrock && !DefaultConfig.sendCustomModelsToBedrockClients && this.skeleton.getModeledEntity().getUnderlyingEntity() != null) {
            Bukkit.getScheduler().runTask(MetadataHandler.PLUGIN, () -> player.showEntity(MetadataHandler.PLUGIN, this.skeleton.getModeledEntity().getUnderlyingEntity()));
        }
        this.viewers.add(player.getUniqueId());
        this.skeleton.getBones().forEach(bone -> bone.displayTo(player));
        ModeledEntity modeledEntity = this.skeleton.getModeledEntity();
        if (modeledEntity instanceof PropEntity) {
            PropEntity propEntity = (PropEntity)modeledEntity;
            propEntity.showFakePropBlocksToPlayer(player);
        }
    }

    private void hideFrom(UUID uuid) {
        boolean isBedrock = BedrockChecker.isBedrock(Bukkit.getPlayer((UUID)uuid));
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null || !player.isValid()) {
            return;
        }
        if (isBedrock && !DefaultConfig.sendCustomModelsToBedrockClients && this.skeleton.getModeledEntity().getUnderlyingEntity() != null) {
            Bukkit.getScheduler().runTask(MetadataHandler.PLUGIN, () -> player.hideEntity(MetadataHandler.PLUGIN, this.skeleton.getModeledEntity().getUnderlyingEntity()));
        }
        this.viewers.remove(uuid);
        this.skeleton.getBones().forEach(bone -> bone.hideFrom(uuid));
        ModeledEntity modeledEntity = this.skeleton.getModeledEntity();
        if (modeledEntity instanceof PropEntity) {
            PropEntity propEntity = (PropEntity)modeledEntity;
            propEntity.showRealBlocksToPlayer(player);
        }
    }

    public void sendPackets(Bone bone, AbstractPacketBundle abstractPacketBundle) {
        if (!this.hasObservers()) {
            return;
        }
        bone.sendUpdatePacket(abstractPacketBundle);
    }
}

