/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.customentity.core;

import com.magmaguy.freeminecraftmodels.config.DefaultConfig;
import com.magmaguy.freeminecraftmodels.customentity.ModeledEntity;
import com.magmaguy.freeminecraftmodels.customentity.core.Bone;
import com.magmaguy.freeminecraftmodels.dataconverter.BoneBlueprint;
import com.magmaguy.freeminecraftmodels.easyminecraftgoals.NMSManager;
import com.magmaguy.freeminecraftmodels.easyminecraftgoals.internal.AbstractPacketBundle;
import com.magmaguy.freeminecraftmodels.easyminecraftgoals.internal.PacketModelEntity;
import com.magmaguy.freeminecraftmodels.easyminecraftgoals.internal.PacketTextEntity;
import com.magmaguy.freeminecraftmodels.magmacore.util.AttributeManager;
import com.magmaguy.freeminecraftmodels.magmacore.util.VersionChecker;
import com.magmaguy.freeminecraftmodels.utils.TransformationMatrix;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;
import org.joml.Vector3f;

public class BoneTransforms {
    private final Bone parent;
    private final Bone bone;
    private final TransformationMatrix localMatrix = new TransformationMatrix();
    private TransformationMatrix globalMatrix = new TransformationMatrix();
    private PacketModelEntity packetArmorStandEntity = null;
    private PacketModelEntity packetDisplayEntity = null;
    private PacketTextEntity packetTextDisplayArmorStandEntity = null;

    public BoneTransforms(Bone bone, Bone parent) {
        this.bone = bone;
        this.parent = parent;
    }

    public void setTextDisplayText(String text) {
        if (this.packetTextDisplayArmorStandEntity == null) {
            return;
        }
        this.packetTextDisplayArmorStandEntity.setText(text);
    }

    public void setTextDisplayVisible(boolean visible) {
        if (this.packetTextDisplayArmorStandEntity == null) {
            return;
        }
        this.packetTextDisplayArmorStandEntity.setTextVisible(visible);
    }

    public void transform() {
        this.updateLocalTransform();
        this.updateGlobalTransform();
    }

    public void updateGlobalTransform() {
        if (this.parent != null) {
            TransformationMatrix.multiplyMatrices(this.parent.getBoneTransforms().globalMatrix, this.localMatrix, this.globalMatrix);
            if (this.bone.getBoneBlueprint().isHead()) {
                double[] inheritedScale = this.globalMatrix.getScale();
                this.globalMatrix.resetRotation();
                float yaw = -this.bone.getSkeleton().getCurrentHeadYaw() + 180.0f;
                this.globalMatrix.rotateY((float)Math.toRadians(yaw));
                this.globalMatrix.rotateX(-((float)Math.toRadians(this.bone.getSkeleton().getCurrentHeadPitch())));
                this.globalMatrix.scale(inheritedScale[0], inheritedScale[1], inheritedScale[2]);
            }
        } else {
            this.globalMatrix = this.localMatrix;
        }
    }

    public void updateLocalTransform() {
        this.localMatrix.resetToIdentityMatrix();
        this.shiftPivotPoint();
        this.translateModelCenter();
        this.translateAnimation();
        this.rotateAnimation();
        this.rotateDefaultBoneRotation();
        this.scaleAnimation();
        this.shiftPivotPointBack();
        this.rotateByEntityYaw();
    }

    private void scaleAnimation() {
        Vector3f currentScale = this.getDisplayEntityScale();
        this.localMatrix.scale(currentScale.x / 2.5f, currentScale.y / 2.5f, currentScale.z / 2.5f);
    }

    private void translateModelCenter() {
        this.localMatrix.translateLocal(this.bone.getBoneBlueprint().getModelCenter());
        if (this.parent != null) {
            Vector3f modelCenter = this.parent.getBoneBlueprint().getModelCenter();
            modelCenter.mul(-1.0f);
            this.localMatrix.translateLocal(modelCenter);
        }
    }

    private void shiftPivotPoint() {
        this.localMatrix.translateLocal(this.bone.getBoneBlueprint().getBlueprintModelPivot().mul(-1.0f));
    }

    private void translateAnimation() {
        this.localMatrix.translateLocal(-this.bone.getAnimationTranslation().get(0), this.bone.getAnimationTranslation().get(1), this.bone.getAnimationTranslation().get(2));
    }

    private void rotateAnimation() {
        Vector test = new Vector(this.bone.getAnimationRotation().get(0), -this.bone.getAnimationRotation().get(1), -this.bone.getAnimationRotation().get(2));
        test.rotateAroundY(Math.PI);
        this.localMatrix.rotateAnimation((float)test.getX(), (float)test.getY(), (float)test.getZ());
    }

    private void rotateDefaultBoneRotation() {
        this.localMatrix.rotateLocal(this.bone.getBoneBlueprint().getBlueprintOriginalBoneRotation().get(0), this.bone.getBoneBlueprint().getBlueprintOriginalBoneRotation().get(1), this.bone.getBoneBlueprint().getBlueprintOriginalBoneRotation().get(2));
    }

    private void shiftPivotPointBack() {
        this.localMatrix.translateLocal(this.bone.getBoneBlueprint().getBlueprintModelPivot());
    }

    public void generateDisplay() {
        this.transform();
        if (this.bone.getBoneBlueprint().isDisplayModel()) {
            if (this.bone.getBoneBlueprint().isNameTag()) {
                this.initializeTextDisplayBone();
                return;
            }
            this.initializeDisplayEntityBone();
            this.initializeArmorStandBone();
        }
    }

    private void initializeTextDisplayBone() {
        Location textDisplayLocation = this.getArmorStandTargetLocation();
        this.packetTextDisplayArmorStandEntity = NMSManager.getAdapter().createPacketTextArmorStandEntity(textDisplayLocation);
        this.packetTextDisplayArmorStandEntity.initializeText(textDisplayLocation);
        this.packetTextDisplayArmorStandEntity.sendLocationAndRotationPacket(textDisplayLocation, new EulerAngle(0.0, 0.0, 0.0));
    }

    private void initializeDisplayEntityBone() {
        if (!DefaultConfig.useDisplayEntitiesWhenPossible) {
            return;
        }
        Location displayEntityLocation = this.getDisplayEntityTargetLocation();
        this.packetDisplayEntity = NMSManager.getAdapter().createPacketDisplayEntity(displayEntityLocation);
        if (VersionChecker.serverVersionOlderThan(21, 4)) {
            this.packetDisplayEntity.initializeModel(displayEntityLocation, Integer.parseInt(this.bone.getBoneBlueprint().getModelID()));
        } else {
            this.packetDisplayEntity.initializeModel(displayEntityLocation, this.bone.getBoneBlueprint().getModelID());
        }
        this.packetDisplayEntity.sendLocationAndRotationPacket(displayEntityLocation, this.getDisplayEntityRotation());
    }

    private void initializeArmorStandBone() {
        Location armorStandLocation = this.getArmorStandTargetLocation();
        this.packetArmorStandEntity = NMSManager.getAdapter().createPacketArmorStandEntity(armorStandLocation);
        if (VersionChecker.serverVersionOlderThan(21, 4)) {
            this.packetArmorStandEntity.initializeModel(armorStandLocation, Integer.parseInt(this.bone.getBoneBlueprint().getModelID()));
        } else {
            this.packetArmorStandEntity.initializeModel(armorStandLocation, this.bone.getBoneBlueprint().getModelID());
        }
        this.packetArmorStandEntity.sendLocationAndRotationPacket(armorStandLocation, this.getArmorStandEntityRotation());
    }

    private void rotateByEntityYaw() {
        if (this.parent == null) {
            this.localMatrix.rotateLocal(0.0, (float)(-Math.toRadians(this.bone.getSkeleton().getCurrentLocation().getYaw() + 180.0f)), 0.0);
        }
    }

    protected Location getArmorStandTargetLocation() {
        double[] translatedGlobalMatrix = this.globalMatrix.getTranslation();
        Location armorStandLocation = new Location(this.bone.getSkeleton().getCurrentLocation().getWorld(), translatedGlobalMatrix[0], translatedGlobalMatrix[1], translatedGlobalMatrix[2]).add(this.bone.getSkeleton().getCurrentLocation());
        armorStandLocation.setYaw(180.0f);
        armorStandLocation.subtract(new Vector(0.0f, BoneBlueprint.getARMOR_STAND_PIVOT_POINT_HEIGHT(), 0.0f));
        return armorStandLocation;
    }

    protected Location getDisplayEntityTargetLocation() {
        Location armorStandLocation;
        double[] translatedGlobalMatrix = this.globalMatrix.getTranslation();
        if (!VersionChecker.serverVersionOlderThan(20, 0)) {
            armorStandLocation = new Location(this.bone.getSkeleton().getCurrentLocation().getWorld(), translatedGlobalMatrix[0], translatedGlobalMatrix[1], translatedGlobalMatrix[2]).add(this.bone.getSkeleton().getCurrentLocation());
            armorStandLocation.setYaw(180.0f);
        } else {
            armorStandLocation = new Location(this.bone.getSkeleton().getCurrentLocation().getWorld(), translatedGlobalMatrix[0], translatedGlobalMatrix[1], translatedGlobalMatrix[2]).add(this.bone.getSkeleton().getCurrentLocation());
        }
        return armorStandLocation;
    }

    protected EulerAngle getDisplayEntityRotation() {
        double[] rotation = this.globalMatrix.getRotation();
        if (VersionChecker.serverVersionOlderThan(20, 0)) {
            return new EulerAngle(rotation[0], rotation[1], rotation[2]);
        }
        return new EulerAngle(-rotation[0], rotation[1], -rotation[2]);
    }

    protected EulerAngle getArmorStandEntityRotation() {
        double[] rotation = this.globalMatrix.getRotation();
        return new EulerAngle(-rotation[0], -rotation[1], rotation[2]);
    }

    public void sendUpdatePacket(AbstractPacketBundle packetBundle) {
        if (this.packetArmorStandEntity != null && this.packetArmorStandEntity.hasViewers()) {
            if (packetBundle == null) {
                packetBundle = this.packetArmorStandEntity.createPacketBundle();
            }
            this.sendArmorStandUpdatePacket(packetBundle);
        }
        if (this.packetDisplayEntity != null && this.packetDisplayEntity.hasViewers()) {
            if (packetBundle == null) {
                packetBundle = this.packetDisplayEntity.createPacketBundle();
            }
            this.sendDisplayEntityUpdatePacket(packetBundle);
        }
        if (this.packetTextDisplayArmorStandEntity != null && this.packetTextDisplayArmorStandEntity.hasViewers()) {
            if (packetBundle == null) {
                packetBundle = this.packetTextDisplayArmorStandEntity.createPacketBundle();
            }
            this.sendTextDisplayUpdatePacket(packetBundle);
        }
    }

    private void sendTextDisplayUpdatePacket(AbstractPacketBundle packetBundle) {
        this.packetTextDisplayArmorStandEntity.generateLocationAndRotationAndScalePackets(packetBundle, this.getArmorStandTargetLocation(), new EulerAngle(0.0, 0.0, 0.0), 1.0f);
    }

    private void sendArmorStandUpdatePacket(AbstractPacketBundle packetBundle) {
        if (this.packetArmorStandEntity != null) {
            this.packetArmorStandEntity.generateLocationAndRotationAndScalePackets(packetBundle, this.getArmorStandTargetLocation(), this.getArmorStandEntityRotation(), 1.0f);
        }
    }

    private void sendDisplayEntityUpdatePacket(AbstractPacketBundle packetBundle) {
        if (this.packetDisplayEntity != null) {
            double[] scale = this.globalMatrix.getScale();
            this.packetDisplayEntity.generateLocationAndRotationAndScalePackets(packetBundle, this.getDisplayEntityTargetLocation(), this.getDisplayEntityRotation(), (float)scale[0] * 2.5f, (float)scale[1] * 2.5f, (float)scale[2] * 2.5f);
        }
    }

    protected Vector3f getDisplayEntityScale() {
        float scaleZ;
        Vector3f animScale = this.bone.getAnimationScale();
        float scaleX = animScale.x == -1.0f ? 2.5f : animScale.x * 2.5f;
        float scaleY = animScale.y == -1.0f ? 2.5f : animScale.y * 2.5f;
        float f = scaleZ = animScale.z == -1.0f ? 2.5f : animScale.z * 2.5f;
        if (this.bone.getParent() == null) {
            LivingEntity livingEntity;
            ModeledEntity modeledEntity;
            double scaleModifier = this.bone.getSkeleton().getModeledEntity().getScaleModifier();
            if (this.bone.getSkeleton().getModeledEntity().getUnderlyingEntity() != null && (modeledEntity = this.bone.getSkeleton().getModeledEntity()) instanceof LivingEntity && (livingEntity = (LivingEntity)modeledEntity).getAttribute(AttributeManager.getAttribute("generic_scale")) != null) {
                scaleModifier *= livingEntity.getAttribute(AttributeManager.getAttribute("generic_scale")).getValue();
            }
            scaleX *= (float)scaleModifier;
            scaleY *= (float)scaleModifier;
            scaleZ *= (float)scaleModifier;
        }
        return new Vector3f(scaleX, scaleY, scaleZ);
    }

    public PacketModelEntity getPacketArmorStandEntity() {
        return this.packetArmorStandEntity;
    }

    public PacketModelEntity getPacketDisplayEntity() {
        return this.packetDisplayEntity;
    }

    public PacketTextEntity getPacketTextDisplayArmorStandEntity() {
        return this.packetTextDisplayArmorStandEntity;
    }
}

