/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.commands;

import com.magmaguy.freeminecraftmodels.api.ModeledEntityManager;
import com.magmaguy.freeminecraftmodels.customentity.ModeledEntity;
import com.magmaguy.freeminecraftmodels.magmacore.command.AdvancedCommand;
import com.magmaguy.freeminecraftmodels.magmacore.command.CommandData;
import com.magmaguy.freeminecraftmodels.magmacore.util.Logger;
import java.util.List;
import org.bukkit.ChatColor;

public class DeleteAllCommand
extends AdvancedCommand {
    public DeleteAllCommand() {
        super(List.of("deleteall"));
        this.setDescription("Delete all loaded modeled entities in your world");
        this.setPermission("freeminecraftmodels.deleteall");
        this.setUsage("/fmm deleteall");
    }

    @Override
    public void execute(CommandData commandData) {
        int removedCount = 0;
        for (ModeledEntity allEntity : ModeledEntityManager.getAllEntities()) {
            allEntity.remove();
            ++removedCount;
        }
        if (removedCount > 0) {
            Logger.sendMessage(commandData.getCommandSender(), ChatColor.GREEN + "Successfully deleted " + removedCount + " modeled entities.");
        } else {
            Logger.sendMessage(commandData.getCommandSender(), ChatColor.YELLOW + "No modeled entities found to delete.");
        }
    }
}

