/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.utils;

import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;

public class TransformationMatrix {
    Matrix4d replacementMatrix = new Matrix4d();
    private double[][] matrix = new double[4][4];

    public TransformationMatrix() {
        this.resetToIdentityMatrix();
    }

    public static void multiplyMatrices(TransformationMatrix firstMatrix, TransformationMatrix secondMatrix, TransformationMatrix resultMatrix) {
        resultMatrix.replacementMatrix = new Matrix4d((Matrix4dc)firstMatrix.replacementMatrix).mul((Matrix4dc)secondMatrix.replacementMatrix);
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 4; ++col) {
                resultMatrix.matrix[row][col] = 0.0;
                for (int i = 0; i < 4; ++i) {
                    double[] dArray = resultMatrix.matrix[row];
                    int n = col;
                    dArray[n] = dArray[n] + firstMatrix.matrix[row][i] * secondMatrix.matrix[i][col];
                }
            }
        }
    }

    public void resetToIdentityMatrix() {
        this.replacementMatrix.identity();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.matrix[i][j] = i == j ? 1.0 : 0.0;
            }
        }
    }

    public void translateLocal(Vector3f vector) {
        this.translateLocal(vector.get(0), vector.get(1), vector.get(2));
    }

    public void translateLocal(float x, float y, float z) {
        TransformationMatrix translationMatrix = new TransformationMatrix();
        translationMatrix.matrix[0][3] = x;
        translationMatrix.matrix[1][3] = y;
        translationMatrix.matrix[2][3] = z;
        this.multiplyWith(translationMatrix);
        this.replacementMatrix.translateLocal((Vector3dc)new Vector3d((double)x, (double)y, (double)z));
    }

    public void scale(double x, double y, double z) {
        TransformationMatrix scaleMatrix = new TransformationMatrix();
        scaleMatrix.matrix[0][0] = x;
        scaleMatrix.matrix[1][1] = y;
        scaleMatrix.matrix[2][2] = z;
        this.multiplyWith(scaleMatrix);
    }

    public void rotateLocal(double x, double y, double z) {
        this.rotateZ(z);
        this.rotateY(y);
        this.rotateX(x);
        this.replacementMatrix.rotateLocalZ(z);
        this.replacementMatrix.rotateLocalY(y);
        this.replacementMatrix.rotateLocalX(x);
    }

    public void rotateAnimation(double x, double y, double z) {
        this.rotateZ(z);
        this.rotateY(y);
        this.rotateX(x);
        this.replacementMatrix.rotateLocalZ(z);
        this.replacementMatrix.rotateLocalY(y);
        this.replacementMatrix.rotateLocalX(x);
    }

    public double[] getScale() {
        double[] scale = new double[]{Math.sqrt(this.matrix[0][0] * this.matrix[0][0] + this.matrix[1][0] * this.matrix[1][0] + this.matrix[2][0] * this.matrix[2][0]), Math.sqrt(this.matrix[0][1] * this.matrix[0][1] + this.matrix[1][1] * this.matrix[1][1] + this.matrix[2][1] * this.matrix[2][1]), Math.sqrt(this.matrix[0][2] * this.matrix[0][2] + this.matrix[1][2] * this.matrix[1][2] + this.matrix[2][2] * this.matrix[2][2])};
        Vector3d jomlScale = new Vector3d();
        this.replacementMatrix.getScale(jomlScale);
        return scale;
    }

    public void rotateX(double angleRadians) {
        TransformationMatrix rotationMatrix = new TransformationMatrix();
        rotationMatrix.matrix[1][1] = Math.cos(angleRadians);
        rotationMatrix.matrix[1][2] = -Math.sin(angleRadians);
        rotationMatrix.matrix[2][1] = Math.sin(angleRadians);
        rotationMatrix.matrix[2][2] = Math.cos(angleRadians);
        this.multiplyWith(rotationMatrix);
    }

    public void rotateY(double angleRadians) {
        TransformationMatrix rotationMatrix = new TransformationMatrix();
        rotationMatrix.matrix[0][0] = Math.cos(angleRadians);
        rotationMatrix.matrix[0][2] = Math.sin(angleRadians);
        rotationMatrix.matrix[2][0] = -Math.sin(angleRadians);
        rotationMatrix.matrix[2][2] = Math.cos(angleRadians);
        this.multiplyWith(rotationMatrix);
    }

    public void rotateZ(double angleRadians) {
        TransformationMatrix rotationMatrix = new TransformationMatrix();
        rotationMatrix.matrix[0][0] = Math.cos(angleRadians);
        rotationMatrix.matrix[0][1] = -Math.sin(angleRadians);
        rotationMatrix.matrix[1][0] = Math.sin(angleRadians);
        rotationMatrix.matrix[1][1] = Math.cos(angleRadians);
        this.multiplyWith(rotationMatrix);
    }

    private void multiplyWith(TransformationMatrix other) {
        double[][] result = new double[4][4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    double[] dArray = result[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.matrix[i][k] * other.matrix[k][j];
                }
            }
        }
        this.matrix = result;
    }

    public double[] getTranslation() {
        return new double[]{this.matrix[0][3], this.matrix[1][3], this.matrix[2][3]};
    }

    public double[] getRotation() {
        double[] rotation = new double[3];
        rotation[1] = Math.atan2(-this.matrix[2][0], Math.sqrt(this.matrix[0][0] * this.matrix[0][0] + this.matrix[1][0] * this.matrix[1][0]));
        if (Math.abs(this.matrix[2][0]) < 1.0E-6 && Math.abs(this.matrix[2][2]) < 1.0E-6) {
            rotation[0] = Math.atan2(this.matrix[1][2], this.matrix[1][1]);
            rotation[2] = 0.0;
        } else {
            rotation[0] = Math.atan2(this.matrix[2][1], this.matrix[2][2]);
            rotation[2] = Math.atan2(this.matrix[1][0], this.matrix[0][0]);
        }
        return rotation;
    }

    public void resetRotation() {
        double[][] identityRotation = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        identityRotation[0][3] = this.matrix[0][3];
        identityRotation[1][3] = this.matrix[1][3];
        identityRotation[2][3] = this.matrix[2][3];
        for (int i = 0; i < 3; ++i) {
            System.arraycopy(identityRotation[i], 0, this.matrix[i], 0, 3);
        }
        this.replacementMatrix.m00(1.0).m01(0.0).m02(0.0);
        this.replacementMatrix.m10(0.0).m11(1.0).m12(0.0);
        this.replacementMatrix.m20(0.0).m21(0.0).m22(1.0);
    }
}

