/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.dataconverter;

import com.google.gson.Gson;
import com.magmaguy.freeminecraftmodels.dataconverter.AnimationsBlueprint;
import com.magmaguy.freeminecraftmodels.dataconverter.ParsedTexture;
import com.magmaguy.freeminecraftmodels.dataconverter.SkeletonBlueprint;
import com.magmaguy.freeminecraftmodels.magmacore.util.Logger;
import com.magmaguy.freeminecraftmodels.utils.StringToResourcePackFilename;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;

public class FileModelConverter {
    private static final HashMap<String, FileModelConverter> convertedFileModels = new HashMap();
    private final HashMap<String, Object> values = new HashMap();
    private final HashMap<String, Object> outliner = new HashMap();
    private String modelName;
    private SkeletonBlueprint skeletonBlueprint;
    private AnimationsBlueprint animationsBlueprint = null;
    private String ID;
    private int blockBenchVersion = 4;

    public FileModelConverter(File file) {
        BufferedReader reader;
        if (file.getName().contains(".bbmodel")) {
            this.modelName = file.getName().replace(".bbmodel", "");
        } else if (file.getName().contains(".fmmodel")) {
            this.modelName = file.getName().replace(".fmmodel", "");
        } else {
            Bukkit.getLogger().warning("File " + file.getName() + " should not be in the models folder!");
            return;
        }
        this.modelName = StringToResourcePackFilename.convert(this.modelName);
        Gson gson = new Gson();
        try {
            reader = Files.newBufferedReader(Paths.get(file.getPath(), new String[0]));
        }
        catch (Exception ex) {
            Logger.warn("Failed to read file " + file.getAbsolutePath());
            return;
        }
        Map map = gson.fromJson((Reader)reader, Map.class);
        try {
            ((Reader)reader).close();
        }
        catch (Exception exception) {
            Logger.warn("Failed to close reader for file!");
            return;
        }
        this.blockBenchVersion = this.detectVersion(map);
        Logger.info("Detected bbmodel format version: " + this.blockBenchVersion);
        List<ParsedTexture> parsedTextures = this.parseTextures(map);
        ArrayList elementValues = (ArrayList)map.get("elements");
        for (Map element : elementValues) {
            this.values.put((String)element.get("uuid"), element);
        }
        List outlinerValues = this.mergeGroupsAndOutliner(map);
        for (int i = 0; i < outlinerValues.size(); ++i) {
            Object e = outlinerValues.get(i);
            if (!(e instanceof Map)) continue;
            Map element = (Map)e;
            this.outliner.put((String)element.get("uuid"), element);
        }
        this.ID = this.modelName;
        this.skeletonBlueprint = new SkeletonBlueprint(parsedTextures, outlinerValues, this.values, this.generateFileTextures(parsedTextures), this.modelName, null);
        ArrayList animationList = (ArrayList)map.get("animations");
        if (animationList != null) {
            this.animationsBlueprint = new AnimationsBlueprint(animationList, this.modelName, this.skeletonBlueprint, this.blockBenchVersion);
        }
        convertedFileModels.put(this.modelName, this);
    }

    private int detectVersion(Map<?, ?> map) {
        try {
            Map meta = (Map)map.get("meta");
            if (meta == null) {
                return 4;
            }
            String formatVersion = (String)meta.get("format_version");
            if (formatVersion == null) {
                return 4;
            }
            String majorVersionStr = formatVersion.split("\\.")[0];
            return Integer.parseInt(majorVersionStr);
        }
        catch (Exception e) {
            Logger.warn("Failed to detect bbmodel version, defaulting to v4");
            return 4;
        }
    }

    private List mergeGroupsAndOutliner(Map<?, ?> map) {
        ArrayList outlinerValues = (ArrayList)map.get("outliner");
        if (this.blockBenchVersion < 5) {
            return outlinerValues;
        }
        ArrayList groupsList = (ArrayList)map.get("groups");
        if (groupsList == null) {
            return outlinerValues;
        }
        HashMap<String, Map> groupsMap = new HashMap<String, Map>();
        for (Object groupObj : groupsList) {
            Map group;
            String uuid;
            if (!(groupObj instanceof Map) || (uuid = (String)(group = (Map)groupObj).get("uuid")) == null) continue;
            groupsMap.put(uuid, group);
        }
        return this.processOutlinerItems(outlinerValues, groupsMap);
    }

    private List processOutlinerItems(List items, HashMap<String, Map> groupsMap) {
        ArrayList result = new ArrayList();
        for (Object item : items) {
            List children;
            HashMap<String, List> mergedItem;
            if (item instanceof String) {
                result.add(item);
                continue;
            }
            if (!(item instanceof Map)) continue;
            Map outlinerItem = (Map)item;
            String uuid = (String)outlinerItem.get("uuid");
            if (uuid != null && groupsMap.containsKey(uuid)) {
                Map groupData = groupsMap.get(uuid);
                mergedItem = new HashMap(groupData);
            } else {
                mergedItem = new HashMap<String, List>(outlinerItem);
            }
            if (outlinerItem.containsKey("children") && (children = (List)outlinerItem.get("children")) != null && !children.isEmpty()) {
                List processedChildren = this.processOutlinerItems(children, groupsMap);
                mergedItem.put("children", processedChildren);
            }
            result.add(mergedItem);
        }
        return result;
    }

    public static void shutdown() {
        convertedFileModels.clear();
    }

    private List<ParsedTexture> parseTextures(Map<?, ?> map) {
        ArrayList<ParsedTexture> parsedTextures = new ArrayList<ParsedTexture>();
        ArrayList texturesValues = (ArrayList)map.get("textures");
        for (int i = 0; i < texturesValues.size(); ++i) {
            ParsedTexture parsedTexture = new ParsedTexture((Map)texturesValues.get(i), this.modelName, i);
            if (!parsedTexture.isValid()) continue;
            parsedTextures.add(parsedTexture);
        }
        return parsedTextures;
    }

    private Map<String, Map<String, Object>> generateFileTextures(List<ParsedTexture> parsedTextures) {
        HashMap<String, Map<String, Object>> texturesMap = new HashMap<String, Map<String, Object>>();
        HashMap<CallSite, CallSite> textureContents = new HashMap<CallSite, CallSite>();
        for (ParsedTexture parsedTexture : parsedTextures) {
            textureContents.put((CallSite)((Object)("" + parsedTexture.getId())), (CallSite)((Object)("freeminecraftmodels:entity/" + this.modelName + "/" + parsedTexture.getFilename().replace(".png", ""))));
        }
        texturesMap.put("textures", textureContents);
        return texturesMap;
    }

    public static HashMap<String, FileModelConverter> getConvertedFileModels() {
        return convertedFileModels;
    }

    public SkeletonBlueprint getSkeletonBlueprint() {
        return this.skeletonBlueprint;
    }

    public AnimationsBlueprint getAnimationsBlueprint() {
        return this.animationsBlueprint;
    }

    public String getID() {
        return this.ID;
    }
}

