/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.magmacore;

import com.magmaguy.freeminecraftmodels.magmacore.command.AdvancedCommand;
import com.magmaguy.freeminecraftmodels.magmacore.command.CommandManager;
import com.magmaguy.freeminecraftmodels.magmacore.command.LogifyCommand;
import com.magmaguy.freeminecraftmodels.magmacore.dlc.ConfigurationImporter;
import com.magmaguy.freeminecraftmodels.magmacore.instance.InstanceProtector;
import com.magmaguy.freeminecraftmodels.magmacore.instance.MatchInstance;
import com.magmaguy.freeminecraftmodels.magmacore.instance.MatchInstanceWorld;
import com.magmaguy.freeminecraftmodels.magmacore.instance.MatchPlayer;
import com.magmaguy.freeminecraftmodels.magmacore.menus.AdvancedMenuHandler;
import com.magmaguy.freeminecraftmodels.magmacore.menus.SetupMenu;
import com.magmaguy.freeminecraftmodels.magmacore.thirdparty.CustomBiomeCompatibility;
import com.magmaguy.freeminecraftmodels.magmacore.util.Logger;
import com.magmaguy.freeminecraftmodels.magmacore.util.VersionChecker;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class MagmaCore {
    private static MagmaCore instance;
    private final JavaPlugin requestingPlugin;

    private MagmaCore(JavaPlugin requestingPlugin) {
        instance = this;
        this.requestingPlugin = requestingPlugin;
        new AdvancedMenuHandler();
        CustomBiomeCompatibility.initializeMappings();
        Logger.info("MagmaCore v1.13-SNAPSHOT initialized!");
        instance.registerLogify();
    }

    public static void checkVersionUpdate(String resourceID, String downloadURL) {
        VersionChecker.checkPluginVersion(resourceID);
        VersionChecker.VersionCheckerEvents.setDownloadURL(downloadURL);
        Bukkit.getPluginManager().registerEvents((Listener)new VersionChecker.VersionCheckerEvents(), (Plugin)MagmaCore.instance.requestingPlugin);
    }

    public static void onEnable() {
        Bukkit.getPluginManager().registerEvents((Listener)new SetupMenu.SetupMenuListeners(), (Plugin)MagmaCore.instance.requestingPlugin);
        Bukkit.getPluginManager().registerEvents((Listener)new AdvancedMenuHandler.AdvancedMenuListeners(), (Plugin)MagmaCore.instance.requestingPlugin);
    }

    public static void enableMatchSystem() {
        Bukkit.getPluginManager().registerEvents((Listener)new InstanceProtector(), (Plugin)MagmaCore.instance.requestingPlugin);
        Bukkit.getPluginManager().registerEvents((Listener)new MatchPlayer.MatchPlayerEvents(), (Plugin)MagmaCore.instance.requestingPlugin);
        Bukkit.getPluginManager().registerEvents((Listener)new MatchInstance.MatchInstanceEvents(), (Plugin)MagmaCore.instance.requestingPlugin);
        Bukkit.getPluginManager().registerEvents((Listener)new MatchInstanceWorld.MatchInstanceWorldEvents(), (Plugin)MagmaCore.instance.requestingPlugin);
    }

    public static MagmaCore createInstance(JavaPlugin requestingPlugin) {
        if (instance == null) {
            return new MagmaCore(requestingPlugin);
        }
        return instance;
    }

    public static void shutdown() {
        CommandManager.shutdown();
        CustomBiomeCompatibility.shutdown();
        MatchInstance.shutdown();
    }

    public static void initializeImporter() {
        if (instance == null) {
            Bukkit.getLogger().warning("Attempted to initialize importer without first instantiating MagmaCore!");
            return;
        }
        new ConfigurationImporter();
    }

    private void registerLogify() {
        SimpleCommandMap commandMap = null;
        try {
            Field f = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            f.setAccessible(true);
            commandMap = (SimpleCommandMap)f.get(Bukkit.getServer());
        }
        catch (ReflectiveOperationException e) {
            this.requestingPlugin.getLogger().warning("Couldn\u2019t access CommandMap: " + e.getMessage());
            return;
        }
        if (commandMap.getCommand("logify") != null) {
            this.requestingPlugin.getLogger().info("/logify is already registered, skipping.");
            return;
        }
        if (Bukkit.getPluginManager().getPermission("logify.*") == null) {
            Permission perm = new Permission("logify.*", "Lets admins run the /logify command, which sends the current latest server log to mclo.gs.", PermissionDefault.OP);
            Bukkit.getPluginManager().addPermission(perm);
        }
        commandMap.register(this.requestingPlugin.getName(), AdvancedCommand.toBukkitCommand(MagmaCore.instance.requestingPlugin, new LogifyCommand(MagmaCore.instance.requestingPlugin), "logify", new ArrayList<String>()));
        Command wrapper = AdvancedCommand.toBukkitCommand(this.requestingPlugin, new LogifyCommand(this.requestingPlugin), "logify", List.of());
        commandMap.register(this.requestingPlugin.getName(), wrapper);
        Logger.info("Registered /logify command");
    }

    @Generated
    public static MagmaCore getInstance() {
        return instance;
    }

    @Generated
    public JavaPlugin getRequestingPlugin() {
        return this.requestingPlugin;
    }
}

