/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.dataconverter;

import com.magmaguy.freeminecraftmodels.magmacore.util.Logger;
import com.magmaguy.freeminecraftmodels.utils.InterpolationType;
import com.magmaguy.freeminecraftmodels.utils.TransformationType;
import java.util.List;
import java.util.Map;

public class Keyframe {
    private final TransformationType transformationType;
    private final int timeInTicks;
    private final InterpolationType interpolationType;
    private final float dataX;
    private final float dataY;
    private final float dataZ;

    public Keyframe(Object object, String modelName, String animationName) {
        Map data = (Map)object;
        this.transformationType = TransformationType.valueOf(((String)data.get("channel")).toUpperCase());
        this.interpolationType = InterpolationType.valueOf(((String)data.get("interpolation")).toUpperCase());
        this.timeInTicks = (int)(20.0 * (Double)data.get("time"));
        Map dataPoints = (Map)((List)data.get("data_points")).get(0);
        this.dataX = this.tryParseFloat(dataPoints.get("x"), modelName, animationName);
        this.dataY = this.tryParseFloat(dataPoints.get("y"), modelName, animationName);
        this.dataZ = this.tryParseFloat(dataPoints.get("z"), modelName, animationName);
    }

    public Keyframe(TransformationType transformationType, int timeInTicks, InterpolationType interpolationType, float dataX, float dataY, float dataZ) {
        this.transformationType = transformationType;
        this.timeInTicks = timeInTicks;
        this.interpolationType = interpolationType;
        this.dataX = dataX;
        this.dataY = dataY;
        this.dataZ = dataZ;
    }

    private float tryParseFloat(Object rawObject, String modelName, String animationName) {
        if (!(rawObject instanceof String)) {
            return ((Double)rawObject).floatValue();
        }
        String rawValue = (String)rawObject;
        rawValue = rawValue.replaceAll("\\n", "");
        if (rawValue.isEmpty()) {
            return this.transformationType == TransformationType.SCALE ? 1.0f : 0.0f;
        }
        try {
            return (float)Double.parseDouble(rawValue);
        }
        catch (Exception e) {
            Logger.warn("Failed to parse supposed number value " + rawValue + " in animation " + animationName + " for model " + modelName + "!");
            return 0.0f;
        }
    }

    public TransformationType getTransformationType() {
        return this.transformationType;
    }

    public int getTimeInTicks() {
        return this.timeInTicks;
    }

    public InterpolationType getInterpolationType() {
        return this.interpolationType;
    }

    public float getDataX() {
        return this.dataX;
    }

    public float getDataY() {
        return this.dataY;
    }

    public float getDataZ() {
        return this.dataZ;
    }
}

