/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.customentity;

import com.magmaguy.freeminecraftmodels.MetadataHandler;
import com.magmaguy.freeminecraftmodels.customentity.ModeledEntityHitboxContactCallback;
import com.magmaguy.freeminecraftmodels.customentity.ModeledEntityLeftClickCallback;
import com.magmaguy.freeminecraftmodels.customentity.ModeledEntityRightClickCallback;
import com.magmaguy.freeminecraftmodels.customentity.PlayerDisguiseEntity;
import com.magmaguy.freeminecraftmodels.customentity.PropEntity;
import com.magmaguy.freeminecraftmodels.customentity.core.Bone;
import com.magmaguy.freeminecraftmodels.customentity.core.RegisterModelEntity;
import com.magmaguy.freeminecraftmodels.customentity.core.Skeleton;
import com.magmaguy.freeminecraftmodels.customentity.core.components.AnimationComponent;
import com.magmaguy.freeminecraftmodels.customentity.core.components.DamageableComponent;
import com.magmaguy.freeminecraftmodels.customentity.core.components.HitboxComponent;
import com.magmaguy.freeminecraftmodels.customentity.core.components.InteractionComponent;
import com.magmaguy.freeminecraftmodels.customentity.core.components.ModeledEntityHitByProjectileCallback;
import com.magmaguy.freeminecraftmodels.dataconverter.BoneBlueprint;
import com.magmaguy.freeminecraftmodels.dataconverter.FileModelConverter;
import com.magmaguy.freeminecraftmodels.dataconverter.SkeletonBlueprint;
import com.magmaguy.freeminecraftmodels.easyminecraftgoals.internal.AbstractPacketBundle;
import com.magmaguy.freeminecraftmodels.magmacore.util.AttributeManager;
import com.magmaguy.freeminecraftmodels.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TextDisplay;
import org.bukkit.persistence.PersistentDataType;

public class ModeledEntity {
    private static final Set<ModeledEntity> loadedModeledEntities = ConcurrentHashMap.newKeySet();
    private static final HashMap<Entity, ModeledEntity> loadedModeledEntitiesWithUnderlyingEntities = new HashMap();
    private final String entityID;
    private final String name = "default";
    private final List<TextDisplay> nametags = new ArrayList<TextDisplay>();
    private final Location lastSeenLocation;
    private final InteractionComponent interactionComponent = new InteractionComponent(this);
    private final HitboxComponent hitboxComponent = new HitboxComponent(this);
    private final DamageableComponent damageableComponent = new DamageableComponent(this);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    protected int tickCounter = 0;
    protected Entity underlyingEntity = null;
    protected Location spawnLocation = null;
    protected Location currentLocation = null;
    private boolean isDying = false;
    private SkeletonBlueprint skeletonBlueprint = null;
    private Skeleton skeleton;
    private boolean isRemoved = false;
    private double scaleModifier = 1.0;
    private String displayName = null;

    public ModeledEntity(String entityID, Location spawnLocation) {
        this.entityID = entityID;
        this.spawnLocation = spawnLocation;
        this.lastSeenLocation = spawnLocation;
        this.currentLocation = spawnLocation;
        FileModelConverter fileModelConverter = FileModelConverter.getConvertedFileModels().get(entityID);
        if (fileModelConverter == null) {
            Logger.warn("Failed to initialize ModeledEntity: FileModelConverter not found for entityID: " + entityID);
            return;
        }
        this.skeletonBlueprint = fileModelConverter.getSkeletonBlueprint();
        if (this.skeletonBlueprint == null) {
            Logger.warn("Failed to initialize ModeledEntity: SkeletonBlueprint not found for entityID: " + entityID);
            return;
        }
        this.skeleton = new Skeleton(this.skeletonBlueprint, this);
        this.animationComponent.initializeAnimationManager(fileModelConverter);
        loadedModeledEntities.add(this);
    }

    private static boolean isNameTag(ArmorStand armorStand) {
        return armorStand.getPersistentDataContainer().has(BoneBlueprint.nameTagKey, PersistentDataType.BYTE);
    }

    public static void shutdown() {
        HashSet<ModeledEntity> entitiesToRemove = new HashSet<ModeledEntity>(loadedModeledEntities);
        for (ModeledEntity entity : entitiesToRemove) {
            entity.shutdownRemove();
        }
        loadedModeledEntities.clear();
        loadedModeledEntitiesWithUnderlyingEntities.clear();
    }

    public void setUnderlyingEntity(Entity underlyingEntity) {
        this.underlyingEntity = underlyingEntity;
        loadedModeledEntitiesWithUnderlyingEntities.put(underlyingEntity, this);
        if (!(underlyingEntity instanceof PlayerDisguiseEntity)) {
            RegisterModelEntity.registerModelEntity(underlyingEntity, this.getSkeletonBlueprint().getModelName());
        }
        this.hitboxComponent.setCustomHitboxOnUnderlyingEntity();
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
        this.getSkeleton().getNametags().forEach(nametag -> nametag.getBoneTransforms().setTextDisplayText(displayName));
    }

    public void setDisplayNameVisible(boolean visible) {
        this.getSkeleton().getNametags().forEach(nametag -> nametag.getBoneTransforms().setTextDisplayVisible(visible));
    }

    public HashSet<UUID> getViewers() {
        return this.skeleton.getSkeletonWatchers().getViewers();
    }

    public Location getSpawnLocation() {
        return this.spawnLocation.clone();
    }

    protected void displayInitializer() {
        this.skeleton.generateDisplays();
    }

    public void spawn(Entity entity) {
        this.setUnderlyingEntity(entity);
        this.spawnLocation = entity.getLocation();
        this.currentLocation = entity.getLocation();
        this.displayInitializer();
    }

    public void spawn(Location location) {
        this.spawnLocation = location;
        this.currentLocation = location;
        this.displayInitializer();
    }

    public void spawn() {
        this.spawn(this.lastSeenLocation);
    }

    protected void shutdownRemove() {
        this.remove();
    }

    public void tick(AbstractPacketBundle abstractPacketBundle) {
        LivingEntity livingEntity;
        Entity entity;
        if (this.isRemoved || this.getLocation() == null) {
            return;
        }
        this.getSkeleton().tick(abstractPacketBundle);
        this.hitboxComponent.tick(this.tickCounter);
        this.animationComponent.tick();
        ++this.tickCounter;
        if (this.underlyingEntity != null && (entity = this.underlyingEntity) instanceof LivingEntity && (livingEntity = (LivingEntity)entity).getAttribute(AttributeManager.getAttribute("generic_scale")) != null) {
            this.scaleModifier = livingEntity.getAttribute(AttributeManager.getAttribute("generic_scale")).getValue();
        }
    }

    public void removeWithDeathAnimation() {
        this.isDying = true;
        if (!this.animationComponent.playDeathAnimation()) {
            this.remove();
        }
    }

    public void removeWithMinimizedAnimation() {
        if (this.animationComponent.isScalingDown()) {
            return;
        }
        this.isDying = true;
        this.animationComponent.removeWithMinimizedAnimation();
    }

    public void remove() {
        PropEntity propEntity;
        ModeledEntity modeledEntity;
        if (this.isRemoved) {
            return;
        }
        this.interactionComponent.clearCallbacks();
        this.skeleton.remove();
        loadedModeledEntities.remove(this);
        if (this.underlyingEntity != null && (!(this instanceof PropEntity) || (modeledEntity = this) instanceof PropEntity && !(propEntity = (PropEntity)modeledEntity).isPersistent())) {
            loadedModeledEntitiesWithUnderlyingEntities.remove(this.underlyingEntity);
            Bukkit.getScheduler().runTask(MetadataHandler.PLUGIN, () -> this.underlyingEntity.remove());
        }
        this.isRemoved = true;
    }

    public List<Bone> getNametagBones() {
        return this.skeleton.getNametags();
    }

    public World getWorld() {
        if (this.underlyingEntity == null && this.spawnLocation == null) {
            return null;
        }
        if (this.underlyingEntity != null) {
            return this.underlyingEntity.getWorld();
        }
        return this.spawnLocation.getWorld();
    }

    public Location getLocation() {
        if (this.underlyingEntity != null) {
            return this.underlyingEntity.getLocation();
        }
        if (this.currentLocation != null) {
            return this.currentLocation.clone();
        }
        return null;
    }

    public boolean isChunkLoaded() {
        return this.getWorld().isChunkLoaded(this.getLocation().getBlockX() >> 4, this.getLocation().getBlockZ() >> 4);
    }

    public void showUnderlyingEntity(Player player) {
        if (this.underlyingEntity == null || !this.underlyingEntity.isValid()) {
            return;
        }
        player.showEntity(MetadataHandler.PLUGIN, this.underlyingEntity);
        this.underlyingEntity.setGlowing(true);
    }

    public void hideUnderlyingEntity(Player player) {
        if (this.underlyingEntity == null || !this.underlyingEntity.isValid()) {
            return;
        }
        player.hideEntity(MetadataHandler.PLUGIN, this.underlyingEntity);
        this.underlyingEntity.setGlowing(false);
    }

    public void teleport(Location location, boolean teleportUnderlyingEntity) {
        if (teleportUnderlyingEntity && this.underlyingEntity != null) {
            this.underlyingEntity.teleport(location);
        } else {
            this.currentLocation = location;
        }
    }

    public void damage(double amount) {
        this.damageableComponent.damage(amount);
    }

    public void damage(Entity damager, double amount) {
        this.damageableComponent.damage(damager, amount);
    }

    public void damage(Entity entityGettingDamaged) {
        this.damageableComponent.damage(entityGettingDamaged);
    }

    public boolean damage(Projectile projectile) {
        return this.damageableComponent.damage(projectile);
    }

    public void attack(LivingEntity target) {
        this.damageableComponent.attack(target);
    }

    public void attack(LivingEntity target, double damage) {
        this.damageableComponent.attack(target, damage);
    }

    public ModeledEntity setLeftClickCallback(ModeledEntityLeftClickCallback callback) {
        this.interactionComponent.setLeftClickCallback(callback);
        return this;
    }

    public ModeledEntity setRightClickCallback(ModeledEntityRightClickCallback callback) {
        this.interactionComponent.setRightClickCallback(callback);
        return this;
    }

    public ModeledEntity setHitboxContactCallback(ModeledEntityHitboxContactCallback callback) {
        this.interactionComponent.setHitboxContactCallback(callback);
        return this;
    }

    public ModeledEntity setModeledEntityHitByProjectileCallback(ModeledEntityHitByProjectileCallback callback) {
        this.interactionComponent.setProjectileHitCallback(callback);
        return this;
    }

    public boolean playAnimation(String animationName, boolean blendAnimation, boolean loop) {
        return this.animationComponent.playAnimation(animationName, blendAnimation, loop);
    }

    public void stopCurrentAnimations() {
        this.animationComponent.stopCurrentAnimations();
    }

    public boolean hasAnimation(String animationName) {
        return this.animationComponent.hasAnimation(animationName);
    }

    public static Set<ModeledEntity> getLoadedModeledEntities() {
        return loadedModeledEntities;
    }

    public static HashMap<Entity, ModeledEntity> getLoadedModeledEntitiesWithUnderlyingEntities() {
        return loadedModeledEntitiesWithUnderlyingEntities;
    }

    public String getEntityID() {
        return this.entityID;
    }

    public String getName() {
        return this.name;
    }

    public List<TextDisplay> getNametags() {
        return this.nametags;
    }

    public Location getLastSeenLocation() {
        return this.lastSeenLocation;
    }

    public InteractionComponent getInteractionComponent() {
        return this.interactionComponent;
    }

    public HitboxComponent getHitboxComponent() {
        return this.hitboxComponent;
    }

    public DamageableComponent getDamageableComponent() {
        return this.damageableComponent;
    }

    public AnimationComponent getAnimationComponent() {
        return this.animationComponent;
    }

    public Entity getUnderlyingEntity() {
        return this.underlyingEntity;
    }

    public boolean isDying() {
        return this.isDying;
    }

    public SkeletonBlueprint getSkeletonBlueprint() {
        return this.skeletonBlueprint;
    }

    public Skeleton getSkeleton() {
        return this.skeleton;
    }

    public boolean isRemoved() {
        return this.isRemoved;
    }

    public double getScaleModifier() {
        return this.scaleModifier;
    }

    public void setScaleModifier(double scaleModifier) {
        this.scaleModifier = scaleModifier;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

