/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.animation;

import com.magmaguy.freeminecraftmodels.animation.Animation;
import com.magmaguy.freeminecraftmodels.animation.AnimationStateType;
import com.magmaguy.freeminecraftmodels.animation.IAnimState;
import com.magmaguy.freeminecraftmodels.customentity.ModeledEntity;
import java.util.Optional;

public class CustomAnimationState
implements IAnimState {
    private final ModeledEntity entity;
    private final Animation animation;
    private final boolean loop;
    private final AnimationStateType returnTo;
    private boolean finished;

    public CustomAnimationState(ModeledEntity entity, Animation animation, boolean loop, AnimationStateType returnTo) {
        this.entity = entity;
        this.animation = animation;
        this.loop = loop;
        this.returnTo = returnTo;
    }

    @Override
    public void enter() {
        this.animation.resetCounter();
        this.finished = false;
    }

    @Override
    public void update() {
        if (!this.loop && this.animation.getCounter() >= this.animation.getAnimationBlueprint().getDuration()) {
            this.finished = true;
        }
    }

    @Override
    public void exit() {
    }

    @Override
    public AnimationStateType getType() {
        return AnimationStateType.CUSTOM;
    }

    @Override
    public Optional<AnimationStateType> nextState() {
        return this.finished ? Optional.of(this.returnTo) : Optional.empty();
    }

    @Override
    public Animation getAnimation() {
        return this.animation;
    }

    @Override
    public boolean isLoop() {
        return this.loop;
    }
}

