/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.thirdparty.custommodels;

import com.magmaguy.elitemobs.api.EliteMobDeathEvent;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.elitemobs.thirdparty.custommodels.CustomModelInterface;
import com.magmaguy.elitemobs.thirdparty.custommodels.freeminecraftmodels.CustomModelFMM;
import com.magmaguy.elitemobs.thirdparty.custommodels.modelengine.CustomModelMEG;
import com.magmaguy.elitemobs.thirdparty.custommodels.modelengine.ModelEngineChecker;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntitySpawnEvent;

public class CustomModel
implements CustomModelInterface {
    private static final boolean usingModels = false;
    private static ModelPlugin modelPlugin;
    private CustomModelMEG customModelMEG;
    private CustomModelFMM customModelFMM;
    private boolean initialized = false;

    private CustomModel(LivingEntity livingEntity, String modelName, String nametagName) {
        switch (modelPlugin) {
            case FREE_MINECRAFT_MODELS: {
                this.customModelFMM = new CustomModelFMM(livingEntity, modelName, nametagName);
                this.initialized = true;
                break;
            }
            case MODEL_ENGINE: {
                this.customModelMEG = new CustomModelMEG(livingEntity, modelName, nametagName);
                this.initialized = true;
            }
        }
    }

    public static void initialize() {
        modelPlugin = Bukkit.getPluginManager().isPluginEnabled("FreeMinecraftModels") ? ModelPlugin.FREE_MINECRAFT_MODELS : (ModelEngineChecker.modelEngineIsInstalled() ? ModelPlugin.MODEL_ENGINE : ModelPlugin.NONE);
    }

    public static void reloadModels() {
        switch (modelPlugin) {
            case FREE_MINECRAFT_MODELS: {
                CustomModelFMM.reloadModels();
                break;
            }
            case MODEL_ENGINE: {
                CustomModelMEG.reloadModels();
            }
        }
    }

    public static boolean modelExists(String modelName) {
        switch (modelPlugin) {
            case FREE_MINECRAFT_MODELS: {
                return CustomModelFMM.modelExists(modelName);
            }
            case MODEL_ENGINE: {
                return CustomModelMEG.modelExists(modelName);
            }
        }
        return false;
    }

    public static CustomModel generateCustomModel(LivingEntity livingEntity, String modelName, String nametagName) {
        CustomModel customModel = new CustomModel(livingEntity, modelName, nametagName);
        return customModel.initialized ? customModel : null;
    }

    public static boolean customModelsEnabled() {
        return modelPlugin != ModelPlugin.NONE;
    }

    @Override
    public void shoot() {
        switch (modelPlugin) {
            case FREE_MINECRAFT_MODELS: {
                this.customModelFMM.shoot();
                break;
            }
            case MODEL_ENGINE: {
                this.customModelMEG.shoot();
            }
        }
    }

    @Override
    public void melee() {
        switch (modelPlugin) {
            case FREE_MINECRAFT_MODELS: {
                this.customModelFMM.melee();
                break;
            }
            case MODEL_ENGINE: {
                this.customModelMEG.melee();
            }
        }
    }

    @Override
    public void playAnimationByName(String animationName) {
        switch (modelPlugin) {
            case FREE_MINECRAFT_MODELS: {
                this.customModelFMM.playAnimationByName(animationName);
                break;
            }
            case MODEL_ENGINE: {
                this.customModelMEG.playAnimationByName(animationName);
            }
        }
    }

    @Override
    public void setName(String nametagName, boolean visible) {
        switch (modelPlugin) {
            case FREE_MINECRAFT_MODELS: {
                this.customModelFMM.setName(nametagName, visible);
                break;
            }
            case MODEL_ENGINE: {
                this.customModelMEG.setName(nametagName, visible);
            }
        }
    }

    @Override
    public void setNameVisible(boolean visible) {
        switch (modelPlugin) {
            case FREE_MINECRAFT_MODELS: {
                this.customModelFMM.setNameVisible(visible);
                break;
            }
            case MODEL_ENGINE: {
                this.customModelMEG.setNameVisible(visible);
            }
        }
    }

    @Override
    public void addPassenger(CustomBossEntity passenger) {
        switch (modelPlugin) {
            case FREE_MINECRAFT_MODELS: {
                this.customModelFMM.addPassenger(passenger);
                break;
            }
            case MODEL_ENGINE: {
                this.customModelMEG.addPassenger(passenger);
            }
        }
    }

    @Override
    public void switchPhase() {
        switch (modelPlugin) {
            case FREE_MINECRAFT_MODELS: {
                this.customModelFMM.switchPhase();
                break;
            }
            case MODEL_ENGINE: {
                this.customModelMEG.switchPhase();
            }
        }
    }

    @Override
    public Location getNametagBoneLocation() {
        return switch (modelPlugin) {
            case ModelPlugin.FREE_MINECRAFT_MODELS -> this.customModelFMM.getNametagBoneLocation();
            case ModelPlugin.MODEL_ENGINE -> this.customModelMEG.getNametagBoneLocation();
            default -> null;
        };
    }

    @Generated
    public static boolean isUsingModels() {
        return false;
    }

    @Generated
    public static ModelPlugin getModelPlugin() {
        return modelPlugin;
    }

    public static enum ModelPlugin {
        NONE,
        FREE_MINECRAFT_MODELS,
        MODEL_ENGINE;

    }

    public static class ModelEntityEvents
    implements Listener {
        @EventHandler(ignoreCancelled=true)
        public void onMeleeHit(EntityDamageByEntityEvent event) {
            EliteEntity eliteEntity = EntityTracker.getEliteMobEntity(event.getDamager());
            if (!(eliteEntity instanceof CustomBossEntity)) {
                return;
            }
            if (((CustomBossEntity)eliteEntity).getCustomModel() == null) {
                return;
            }
            ((CustomBossEntity)eliteEntity).getCustomModel().melee();
        }

        @EventHandler(ignoreCancelled=true)
        public void onRangedShot(EntitySpawnEvent event) {
            if (!(event.getEntity() instanceof Projectile)) {
                return;
            }
            if (!(((Projectile)event.getEntity()).getShooter() instanceof LivingEntity)) {
                return;
            }
            EliteEntity eliteEntity = EntityTracker.getEliteMobEntity((Entity)((LivingEntity)((Projectile)event.getEntity()).getShooter()));
            if (!(eliteEntity instanceof CustomBossEntity)) {
                return;
            }
            if (((CustomBossEntity)eliteEntity).getCustomModel() == null) {
                return;
            }
            ((CustomBossEntity)eliteEntity).getCustomModel().shoot();
        }

        @EventHandler
        public void onDeathEvent(EliteMobDeathEvent event) {
            CustomBossEntity customBossEntity;
            EliteEntity eliteEntity = event.getEliteEntity();
            if (eliteEntity instanceof CustomBossEntity && (customBossEntity = (CustomBossEntity)eliteEntity).getCustomModel() != null) {
                customBossEntity.getCustomModel().playAnimationByName("death");
            }
        }
    }
}

