/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.tagger;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.npcs.NPCEntity;
import java.util.UUID;
import javax.annotation.Nullable;
import lombok.Generated;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Projectile;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class PersistentTagger {
    private static final String ELITE_ENTITY = "EliteEntity";
    private static final String NPC_ENTITY = "NPCEntity";
    private static final String SUPER_MOB = "SuperMob";
    private static final String VISUAL_EFFECT = "VisualEffect";
    private static final String ELITE_PROJECTILE = "EliteProjectile";

    private PersistentTagger() {
    }

    public static void tag(@NotNull Entity entity, String key, String value) {
        if (entity == null) {
            return;
        }
        entity.getPersistentDataContainer().set(new NamespacedKey((Plugin)MetadataHandler.PLUGIN, key), PersistentDataType.STRING, (Object)value);
    }

    public static void tagElite(Entity entity, @NotNull UUID eliteUUID) {
        PersistentTagger.tag(entity, ELITE_ENTITY, eliteUUID.toString());
    }

    public static boolean isEliteEntity(Entity entity) {
        if (entity == null) {
            return false;
        }
        return entity.getPersistentDataContainer().has(new NamespacedKey((Plugin)MetadataHandler.PLUGIN, ELITE_ENTITY), PersistentDataType.STRING);
    }

    public static EliteEntity getEliteEntity(Entity entity) {
        UUID uuid = PersistentTagger.getUUID(entity, ELITE_ENTITY);
        if (uuid == null) {
            return null;
        }
        return EntityTracker.getEliteMobEntities().get(uuid);
    }

    public static void tagNPC(Entity entity, @NotNull UUID npcUUID) {
        PersistentTagger.tag(entity, NPC_ENTITY, npcUUID.toString());
    }

    public static boolean isNPC(Entity entity) {
        if (entity == null) {
            return false;
        }
        return entity.getPersistentDataContainer().has(new NamespacedKey((Plugin)MetadataHandler.PLUGIN, NPC_ENTITY), PersistentDataType.STRING);
    }

    public static NPCEntity getNPC(Entity entity) {
        UUID uuid = PersistentTagger.getUUID(entity, NPC_ENTITY);
        if (uuid == null) {
            return null;
        }
        return EntityTracker.getNpcEntities().get(uuid);
    }

    public static void tagSuperMob(Entity entity) {
        PersistentTagger.tag(entity, SUPER_MOB, entity.getType().toString());
    }

    public static boolean isSuperMob(Entity entity) {
        if (entity == null) {
            return false;
        }
        return entity.getPersistentDataContainer().has(new NamespacedKey((Plugin)MetadataHandler.PLUGIN, SUPER_MOB), PersistentDataType.STRING);
    }

    public static void tagVisualEffect(Entity entity) {
        PersistentTagger.tag(entity, VISUAL_EFFECT, entity.getType().toString());
    }

    public static boolean isVisualEffect(Entity entity) {
        if (entity == null) {
            return false;
        }
        return entity.getPersistentDataContainer().has(new NamespacedKey((Plugin)MetadataHandler.PLUGIN, VISUAL_EFFECT), PersistentDataType.STRING);
    }

    public static void tagEliteProjectile(Projectile projectile) {
        PersistentTagger.tag((Entity)projectile, ELITE_PROJECTILE, "");
    }

    public static boolean isEliteProjectile(Entity entity) {
        if (entity == null) {
            return false;
        }
        return entity.getPersistentDataContainer().has(new NamespacedKey((Plugin)MetadataHandler.PLUGIN, ELITE_PROJECTILE), PersistentDataType.STRING);
    }

    @Nullable
    public static UUID getUUID(Entity entity, String key) {
        if (entity == null) {
            return null;
        }
        String uuidString = (String)entity.getPersistentDataContainer().get(new NamespacedKey((Plugin)MetadataHandler.PLUGIN, key), PersistentDataType.STRING);
        if (uuidString == null) {
            return null;
        }
        return UUID.fromString(uuidString);
    }

    @Generated
    public static String getELITE_ENTITY() {
        return ELITE_ENTITY;
    }

    @Generated
    public static String getNPC_ENTITY() {
        return NPC_ENTITY;
    }

    @Generated
    public static String getSUPER_MOB() {
        return SUPER_MOB;
    }

    @Generated
    public static String getVISUAL_EFFECT() {
        return VISUAL_EFFECT;
    }

    @Generated
    public static String getELITE_PROJECTILE() {
        return ELITE_PROJECTILE;
    }
}

