/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobTargetPlayerEvent;
import com.magmaguy.elitemobs.combatsystem.EliteProjectile;
import com.magmaguy.elitemobs.config.powers.PowersConfig;
import com.magmaguy.elitemobs.powers.meta.MajorPower;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class TrackingFireball
extends MajorPower {
    public TrackingFireball() {
        super(PowersConfig.getPower("tracking_fireball.yml"));
    }

    public static class TrackingFireballEvents
    implements Listener {
        public static HashMap<UUID, TrackingFireballTasks.TrackingFireballTask> trackingFireballs = new HashMap();

        public static void shutdown() {
            trackingFireballs.clear();
        }

        @EventHandler(ignoreCancelled=true)
        public void targetEvent(EliteMobTargetPlayerEvent event) {
            if (!(event.getEliteMobEntity().getLivingEntity() instanceof Monster)) {
                return;
            }
            TrackingFireball trackingFireball = (TrackingFireball)event.getEliteMobEntity().getPower(new TrackingFireball());
            if (trackingFireball == null) {
                return;
            }
            if (trackingFireball.isFiring()) {
                return;
            }
            trackingFireball.setFiring(true);
            new TrackingFireballTasks((Monster)event.getEntity(), trackingFireball);
        }

        @EventHandler(ignoreCancelled=true)
        public void onFireballPunched(EntityDamageByEntityEvent event) {
            TrackingFireballTasks.TrackingFireballTask trackingFireballTask = trackingFireballs.get(event.getEntity().getUniqueId());
            if (trackingFireballTask == null) {
                return;
            }
            trackingFireballTask.isAfterPlayer = !trackingFireballTask.isAfterPlayer;
        }

        private class TrackingFireballTasks {
            public TrackingFireballTasks(final Monster monster, final TrackingFireball trackingFireball) {
                new BukkitRunnable(){

                    public void run() {
                        if (!monster.isValid() || monster.getTarget() == null) {
                            trackingFireball.setFiring(false);
                            this.cancel();
                            return;
                        }
                        for (Entity nearbyEntity : monster.getNearbyEntities(20.0, 20.0, 20.0)) {
                            if (!(nearbyEntity instanceof Player) || !((Player)nearbyEntity).getGameMode().equals((Object)GameMode.ADVENTURE) && !((Player)nearbyEntity).getGameMode().equals((Object)GameMode.SURVIVAL)) continue;
                            new TrackingFireballTask((Entity)monster, (Player)nearbyEntity);
                        }
                    }
                }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 160L);
            }

            public class TrackingFireballTask {
                public boolean isAfterPlayer = true;
                private Fireball repeatingFireball = null;

                public TrackingFireballTask(final Entity entity, final Player player) {
                    Vector targetterToTargetted = player.getLocation().clone().toVector().subtract(entity.getLocation().toVector()).normalize().multiply(1.0E-4);
                    this.repeatingFireball = (Fireball)EliteProjectile.create(EntityType.FIREBALL, entity, (Entity)player, targetterToTargetted, true);
                    this.repeatingFireball.setYield(3.0f);
                    this.repeatingFireball.setIsIncendiary(true);
                    this.repeatingFireball.setShooter((ProjectileSource)entity);
                    trackingFireballs.put(this.repeatingFireball.getUniqueId(), this);
                    new BukkitRunnable(){
                        int counter = 0;

                        public void run() {
                            if (TrackingFireballTask.this.repeatingFireball == null || !TrackingFireballTask.this.repeatingFireball.isValid() || !entity.isValid() || player.isDead() || this.counter > 3600 || TrackingFireballTask.this.repeatingFireball.getLocation().getWorld() != player.getWorld()) {
                                this.cancel();
                                return;
                            }
                            if (TrackingFireballTask.this.isAfterPlayer) {
                                TrackingFireballTask.this.repeatingFireball.setDirection(TrackingFireballTask.this.setFireballDirection((Entity)player));
                                TrackingFireballTask.this.repeatingFireball.setVelocity(TrackingFireballTask.this.setFireballDirection((Entity)player));
                            } else {
                                TrackingFireballTask.this.repeatingFireball.setDirection(TrackingFireballTask.this.setFireballDirection(entity));
                                TrackingFireballTask.this.repeatingFireball.setVelocity(TrackingFireballTask.this.setFireballDirection(entity));
                            }
                            ++this.counter;
                        }
                    }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 1L, 1L);
                }

                private Vector setFireballDirection(Entity target) {
                    double fireballVelocity = PowersConfig.getPower("tracking_fireball.yml").getFileConfiguration().getDouble("fireballSpeed");
                    if (target.getLocation().distanceSquared(this.repeatingFireball.getLocation()) > 1.0) {
                        return target.getLocation().clone().add(new Vector(0, 1, 0)).toVector().subtract(this.repeatingFireball.getLocation().toVector()).normalize().multiply(fireballVelocity);
                    }
                    return target.getLocation().clone().toVector().subtract(this.repeatingFireball.getLocation().toVector()).normalize().multiply(fireballVelocity);
                }
            }
        }
    }
}

