/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobTargetPlayerEvent;
import com.magmaguy.elitemobs.config.powers.PowersConfig;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.powers.AttackArrow;
import com.magmaguy.elitemobs.powers.meta.MajorPower;
import org.bukkit.GameMode;
import org.bukkit.Particle;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class SkeletonTrackingArrow
extends MajorPower
implements Listener {
    public SkeletonTrackingArrow() {
        super(PowersConfig.getPower("skeleton_tracking_arrow.yml"));
    }

    private static void trackingArrowLoop(final Player player, final Arrow arrow) {
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                if (player.isValid() && arrow.isValid() && arrow.getWorld().equals(player.getWorld()) && player.getLocation().distanceSquared(arrow.getLocation()) < 900.0 && !arrow.isOnGround()) {
                    if (this.counter % 10 == 0) {
                        arrow.setVelocity(arrow.getVelocity().add(SkeletonTrackingArrow.arrowAdjustmentVector(arrow, player)));
                    }
                    arrow.getWorld().spawnParticle(Particle.FLAME, arrow.getLocation(), 10, 0.01, 0.01, 0.01, 0.01);
                } else {
                    arrow.setGravity(true);
                    this.cancel();
                }
                if (this.counter > 1200) {
                    arrow.setGravity(true);
                    this.cancel();
                }
                ++this.counter;
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    private static Vector arrowAdjustmentVector(Arrow arrow, Player player) {
        return player.getEyeLocation().clone().subtract(new Vector(0.0, 0.5, 0.0)).subtract(arrow.getLocation()).toVector().normalize().multiply(0.1);
    }

    @EventHandler
    public void targetEvent(EliteMobTargetPlayerEvent event) {
        SkeletonTrackingArrow skeletonTrackingArrow = (SkeletonTrackingArrow)event.getEliteMobEntity().getPower(this);
        if (skeletonTrackingArrow == null) {
            return;
        }
        if (skeletonTrackingArrow.isFiring()) {
            return;
        }
        skeletonTrackingArrow.setFiring(true);
        this.repeatingTrackingArrowTask(event.getEliteMobEntity(), skeletonTrackingArrow);
    }

    private void repeatingTrackingArrowTask(final EliteEntity eliteEntity, final SkeletonTrackingArrow skeletonTrackingArrow) {
        new BukkitRunnable(){

            public void run() {
                if (!eliteEntity.isValid()) {
                    skeletonTrackingArrow.setFiring(false);
                    this.cancel();
                    return;
                }
                for (Entity nearbyEntity : eliteEntity.getLivingEntity().getNearbyEntities(20.0, 20.0, 20.0)) {
                    if (!(nearbyEntity instanceof Player) || !((Player)nearbyEntity).getGameMode().equals((Object)GameMode.ADVENTURE) && !((Player)nearbyEntity).getGameMode().equals((Object)GameMode.SURVIVAL)) continue;
                    Arrow arrow = AttackArrow.shootArrow((Entity)eliteEntity.getLivingEntity(), (Player)nearbyEntity);
                    arrow.setVelocity(arrow.getVelocity().multiply(0.2));
                    arrow.setGravity(false);
                    SkeletonTrackingArrow.trackingArrowLoop((Player)nearbyEntity, arrow);
                }
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 160L);
    }
}

