/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.config.powers.PowersConfig;
import com.magmaguy.elitemobs.events.BossCustomAttackDamage;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.powers.meta.CombatEnterScanPower;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class PhotonRay
extends CombatEnterScanPower {
    private final int range = 60;
    private List<Location> playerLocations = new ArrayList<Location>(5);
    private int tickCounter = 0;

    public PhotonRay() {
        super(PowersConfig.getPower("photon_ray.yml"));
    }

    private void doDamage(Location location, EliteEntity eliteEntity) {
        for (Entity entity : location.getWorld().getNearbyEntities(location, 0.5, 0.5, 0.5)) {
            if (!(entity instanceof LivingEntity) || eliteEntity.getLivingEntity().equals(entity)) continue;
            BossCustomAttackDamage.dealCustomDamage(eliteEntity.getLivingEntity(), (LivingEntity)entity, 1.0);
        }
        ++this.tickCounter;
    }

    @Override
    protected void finishActivation(final EliteEntity eliteEntity) {
        this.bukkitTask = new BukkitRunnable(){

            public void run() {
                if (PhotonRay.this.doExit(eliteEntity) || PhotonRay.this.isInCooldown(eliteEntity)) {
                    return;
                }
                PhotonRay.this.doPower(eliteEntity);
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    private void doPower(EliteEntity eliteEntity) {
        this.doCooldown(eliteEntity);
        for (Entity entity : eliteEntity.getLivingEntity().getNearbyEntities(60.0, 60.0, 60.0)) {
            if (!entity.getType().equals((Object)EntityType.PLAYER) || ((Player)entity).getGameMode().equals((Object)GameMode.SPECTATOR)) continue;
            this.createRay((Player)entity, eliteEntity.getLocation(), eliteEntity);
            break;
        }
    }

    private void createRay(final Player target, final Location sourceLocation, final EliteEntity sourceEntity) {
        sourceEntity.getLivingEntity().setAI(false);
        new BukkitRunnable(){
            int counter = 0;
            Vector laserVector = PhotonRay.this.generateRayVector(sourceLocation, target.getLocation());

            public void run() {
                if (this.counter > 30 || !target.isValid() || !target.getLocation().getWorld().equals(sourceLocation.getWorld()) || target.getLocation().distanceSquared(sourceLocation) > 3600.0 || !sourceEntity.isValid()) {
                    if (sourceEntity.getLivingEntity() != null) {
                        sourceEntity.getLivingEntity().setAI(true);
                    }
                    this.cancel();
                    return;
                }
                this.laserVector = PhotonRay.this.dragTarget(this.laserVector, sourceEntity.getLocation(), target.getLocation());
                PhotonRay.this.doRaytraceLaser(this.laserVector, sourceEntity.getLocation(), (double)this.counter < 5.0, sourceEntity);
                ++this.counter;
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 2L);
    }

    private void doRaytraceLaser(Vector laserVector, Location source, boolean warningPhase, EliteEntity eliteEntity) {
        Location cloneLocation = source.clone().add(new Vector(0, 1, 0));
        for (int i = 0; i < 120; ++i) {
            if (!cloneLocation.clone().add(laserVector).getBlock().isPassable()) {
                Vector tentativeDistance = cloneLocation.clone().add(laserVector).getBlock().getLocation().add(new Vector(0.5, 0.5, 0.5)).subtract(cloneLocation.clone()).toVector();
                double x = laserVector.getX();
                double y = laserVector.getY();
                double z = laserVector.getZ();
                double xAbs = Math.abs(tentativeDistance.getX());
                double yAbs = Math.abs(tentativeDistance.getY());
                double zAbs = Math.abs(tentativeDistance.getZ());
                if (xAbs > yAbs && xAbs > zAbs) {
                    x *= -1.0;
                } else if (yAbs > xAbs && yAbs > zAbs) {
                    y *= -1.0;
                } else if (zAbs > yAbs && zAbs > xAbs) {
                    z *= -1.0;
                } else {
                    Logger.warn("MagmaGuy is bad at math!");
                }
                laserVector.setX(x);
                laserVector.setY(y);
                laserVector.setZ(z);
            }
            if (warningPhase) {
                this.doWarningParticle(cloneLocation.add(laserVector));
                continue;
            }
            this.doDamageParticles(eliteEntity, cloneLocation.add(laserVector));
        }
    }

    private Vector generateRayVector(Location source, Location target) {
        return target.clone().add(new Vector(0, 1, 0)).subtract(source.clone().add(new Vector(0, 1, 0))).toVector().normalize().multiply(0.5);
    }

    private Vector dragTarget(Vector originalVector, Location sourceLocation, Location targetLocation) {
        if (this.playerLocations.size() < 5) {
            this.playerLocations.add(targetLocation);
            return originalVector;
        }
        Location oldTarget = this.playerLocations.get(0);
        Vector newVector = this.generateRayVector(sourceLocation, oldTarget);
        this.playerLocations.remove(0);
        ArrayList<Location> newLocation = new ArrayList<Location>(this.playerLocations);
        newLocation.add(targetLocation);
        this.playerLocations = newLocation;
        return newVector;
    }

    private void doWarningParticle(Location location) {
        location.getWorld().spawnParticle(Particle.DUST, location.getX(), location.getY(), location.getZ(), 5, 0.2, 0.2, 0.2, 1.0, (Object)new Particle.DustOptions(Color.BLACK, 1.0f));
    }

    private void doDamageParticles(EliteEntity eliteEntity, Location location) {
        location.getWorld().spawnParticle(Particle.DUST, location.getX(), location.getY(), location.getZ(), 5, 0.2, 0.2, 0.2, 1.0, (Object)new Particle.DustOptions(Color.fromRGB((int)ThreadLocalRandom.current().nextInt(0, 100), (int)ThreadLocalRandom.current().nextInt(0, 100), (int)ThreadLocalRandom.current().nextInt(100, 255)), 1.0f));
        for (Entity entity : location.getWorld().getNearbyEntities(location, 0.25, 0.25, 0.25)) {
            if (entity.getType() != EntityType.PLAYER) continue;
            this.doDamage(location, eliteEntity);
        }
    }

    @Override
    protected void finishDeactivation(EliteEntity eliteEntity) {
    }
}

