/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.api.PlayerDamagedByEliteMobEvent;
import com.magmaguy.elitemobs.combatsystem.EliteProjectile;
import com.magmaguy.elitemobs.config.powers.PowersConfig;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.powers.meta.BossPower;
import com.magmaguy.elitemobs.powers.meta.ProjectileTagger;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Snowball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class FrostCone
extends BossPower
implements Listener {
    private static final NamespacedKey frostConeSnowballKey = new NamespacedKey((Plugin)MetadataHandler.PLUGIN, "frost_cone_snowball");
    private static final HashMap<UUID, Integer> frostconePlayer = new HashMap();

    public static void shutdown() {
        frostconePlayer.clear();
    }

    public FrostCone() {
        super(PowersConfig.getPower("frost_cone.yml"));
    }

    public static void startFrostCone(final EliteEntity eliteEntity, final Location damager, final FrostCone frostCone) {
        if (eliteEntity == null || eliteEntity.getLivingEntity() == null || !eliteEntity.getLivingEntity().isValid()) {
            return;
        }
        eliteEntity.getLivingEntity().setAI(false);
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                ++this.counter;
                if (this.counter > 120 || !FrostCone.isPowerStillValid(eliteEntity, damager)) {
                    this.cancel();
                    if (eliteEntity.getLivingEntity() != null && !eliteEntity.getLivingEntity().isDead()) {
                        eliteEntity.getLivingEntity().setAI(true);
                    }
                    frostCone.setFiring(false);
                    return;
                }
                if (this.counter < 60) {
                    FrostCone.doSmokeEffect(eliteEntity, damager);
                    return;
                }
                for (int i = 0; i < 10; ++i) {
                    FrostCone.createSnowball(eliteEntity, damager);
                }
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    private static void doSmokeEffect(EliteEntity eliteEntity, Location location) {
        for (int i = 0; i < 100; ++i) {
            Vector shotVector = FrostCone.getShotVector(eliteEntity, location);
            eliteEntity.getLivingEntity().getWorld().spawnParticle(Particle.SMOKE, eliteEntity.getLivingEntity().getLocation().clone().add(new Vector(0, 1, 0)), 0, shotVector.getX(), shotVector.getY(), shotVector.getZ(), 0.75);
        }
    }

    private static boolean isPowerStillValid(EliteEntity eliteEntity, Location playerLocation) {
        if (!eliteEntity.isValid()) {
            return false;
        }
        return eliteEntity.getLivingEntity().getWorld().equals(playerLocation.getWorld());
    }

    private static Vector getShotVector(EliteEntity eliteEntity, Location location) {
        return location.clone().subtract(eliteEntity.getLivingEntity().getLocation().clone()).toVector().normalize().add(new Vector(ThreadLocalRandom.current().nextDouble() * 1.0 - 0.5, ThreadLocalRandom.current().nextDouble() * 0.5 - 0.25, ThreadLocalRandom.current().nextDouble() * 1.0 - 0.5)).normalize();
    }

    private static Snowball createSnowball(EliteEntity eliteEntity, Location location) {
        Projectile snowball = EliteProjectile.create(EntityType.SNOWBALL, (Entity)eliteEntity.getLivingEntity(), FrostCone.getShotVector(eliteEntity, location), false);
        ProjectileTagger.tagProjectileWithCustomDamage(snowball, 2.0);
        snowball.getPersistentDataContainer().set(frostConeSnowballKey, PersistentDataType.STRING, (Object)"true");
        Bukkit.getScheduler().runTaskLater((Plugin)MetadataHandler.PLUGIN, () -> ((Projectile)snowball).remove(), 60L);
        return (Snowball)snowball;
    }

    @EventHandler
    public void onDamagedEvent(EliteMobDamagedByPlayerEvent event) {
        FrostCone frostCone = (FrostCone)event.getEliteMobEntity().getPower(this);
        if (frostCone == null) {
            return;
        }
        if (frostCone.isInCooldown(event.getEliteMobEntity())) {
            return;
        }
        frostCone.doCooldownTicks(event.getEliteMobEntity());
        frostCone.setFiring(true);
        FrostCone.startFrostCone(event.getEliteMobEntity(), event.getPlayer().getLocation().clone(), frostCone);
    }

    @EventHandler(ignoreCancelled=true)
    public void playerHitByFrostConeSnowball(PlayerDamagedByEliteMobEvent event) {
        if (event.getProjectile() == null) {
            return;
        }
        if (!event.getProjectile().getPersistentDataContainer().has(frostConeSnowballKey, PersistentDataType.STRING)) {
            return;
        }
        final UUID playerUUID = event.getPlayer().getUniqueId();
        if (!frostconePlayer.containsKey(playerUUID)) {
            frostconePlayer.put(playerUUID, 1);
        } else {
            frostconePlayer.put(playerUUID, frostconePlayer.get(playerUUID) + 1);
        }
        event.getPlayer().addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 140, frostconePlayer.get(playerUUID).intValue()));
        new BukkitRunnable(){
            final int amount;
            {
                this.amount = frostconePlayer.get(playerUUID);
            }

            public void run() {
                if (!frostconePlayer.containsKey(playerUUID)) {
                    return;
                }
                if (this.amount != frostconePlayer.get(playerUUID)) {
                    return;
                }
                frostconePlayer.remove(playerUUID);
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 100L);
    }
}

