/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.playerdata.statusscreen;

import com.magmaguy.elitemobs.config.DefaultConfig;
import com.magmaguy.elitemobs.config.menus.premade.PlayerStatusMenuConfig;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.playerdata.statusscreen.BossTrackingPage;
import com.magmaguy.elitemobs.playerdata.statusscreen.CommandsPage;
import com.magmaguy.elitemobs.playerdata.statusscreen.CoverPage;
import com.magmaguy.elitemobs.playerdata.statusscreen.GearPage;
import com.magmaguy.elitemobs.playerdata.statusscreen.PlayerStatusScreenDialog;
import com.magmaguy.elitemobs.playerdata.statusscreen.QuestsPage;
import com.magmaguy.elitemobs.playerdata.statusscreen.StatsPage;
import com.magmaguy.elitemobs.playerdata.statusscreen.TeleportsPage;
import com.magmaguy.elitemobs.thirdparty.geyser.GeyserDetector;
import com.magmaguy.elitemobs.utils.BookMaker;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.VersionChecker;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;

public class PlayerStatusScreen
implements Listener {
    public PlayerStatusScreen(Player requestingPlayer, Player targetPlayer) {
        ItemStack writtenBook = this.generateBook(requestingPlayer, targetPlayer);
        BookMeta bookMeta = (BookMeta)writtenBook.getItemMeta();
        List pages = bookMeta.getPages();
        Object debugPage = "";
        debugPage = (String)debugPage + "Is in memory: " + PlayerData.isInMemory(targetPlayer);
        ArrayList<String> newPages = new ArrayList<String>(pages);
        newPages.add((String)debugPage);
        BookMaker.generateBook(requestingPlayer, newPages);
    }

    public PlayerStatusScreen(Player player) {
        if (!PlayerData.getUseBookMenus(player.getUniqueId()) || GeyserDetector.bedrockPlayer(player) || DefaultConfig.isOnlyUseBedrockMenus()) {
            this.generateChestMenu(player, player);
        } else if (VersionChecker.serverVersionOlderThan(21, 6)) {
            this.generateBook(player, player);
        } else {
            PlayerStatusScreenDialog.showPlayerStatusDialog(player);
        }
        if (!PlayerData.getDismissEMStatusScreenMessage(player.getUniqueId()) && !DefaultConfig.isOnlyUseBedrockMenus()) {
            player.sendMessage(DefaultConfig.getDismissEMMessage());
        }
    }

    protected static void setHoverText(TextComponent textComponent, String text) {
        textComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(text).create()));
    }

    public static String convertLightColorsToBlack(String string) {
        string = ChatColorConverter.convert((String)string);
        if (!((String)(string = ((String)string).replace("\u00a7f", "\u00a70").replace("\u00a7e", "\u00a70"))).startsWith("\u00a7")) {
            string = "\u00a70" + (String)string;
        }
        return string;
    }

    private void generateChestMenu(Player requestingPlayer, Player targetPlayer) {
        CoverPage.coverPage(requestingPlayer);
    }

    private ItemStack generateBook(Player requestingPlayer, Player targetPlayer) {
        TextComponent textComponent;
        int n;
        int n2;
        TextComponent[] textComponentArray;
        TextComponent[] pages = new TextComponent[100];
        int pageCounter = 1;
        ++pageCounter;
        int statsPage = -1;
        int gearPage = -1;
        int teleportsPage = -1;
        int commandsPage = -1;
        int questsPage = -1;
        int bossTrackingPage = -1;
        if (PlayerStatusMenuConfig.isDoStatsPage()) {
            statsPage = pageCounter;
            pages[pageCounter] = StatsPage.statsPage(targetPlayer);
            ++pageCounter;
        }
        if (PlayerStatusMenuConfig.isDoGearPage()) {
            gearPage = pageCounter;
            pages[pageCounter] = GearPage.gearPage(targetPlayer);
            ++pageCounter;
        }
        if (PlayerStatusMenuConfig.isDoTeleportsPage()) {
            teleportsPage = pageCounter;
            textComponentArray = TeleportsPage.teleportsPage();
            n2 = textComponentArray.length;
            for (n = 0; n < n2; ++n) {
                pages[pageCounter] = textComponent = textComponentArray[n];
                ++pageCounter;
            }
        }
        if (PlayerStatusMenuConfig.isDoCommandsPage()) {
            commandsPage = pageCounter;
            pages[pageCounter] = CommandsPage.commandsPage();
            ++pageCounter;
        }
        if (PlayerStatusMenuConfig.isDoQuestTrackingPage()) {
            questsPage = pageCounter;
            textComponentArray = QuestsPage.questsPage(targetPlayer);
            n2 = textComponentArray.length;
            for (n = 0; n < n2; ++n) {
                pages[pageCounter] = textComponent = textComponentArray[n];
                ++pageCounter;
            }
        }
        if (PlayerStatusMenuConfig.isDoBossTrackingPage()) {
            bossTrackingPage = pageCounter;
            textComponentArray = BossTrackingPage.bossTrackingPage(targetPlayer);
            n2 = textComponentArray.length;
            for (n = 0; n < n2; ++n) {
                pages[pageCounter] = textComponent = textComponentArray[n];
                ++pageCounter;
            }
        }
        pages[0] = CoverPage.coverPage(statsPage, gearPage, teleportsPage, commandsPage, questsPage, bossTrackingPage);
        int counter = 0;
        for (TextComponent textComponent2 : pages) {
            if (textComponent2 == null) continue;
            ++counter;
        }
        TextComponent[] finalPages = new TextComponent[counter];
        int secondCounter = 0;
        for (TextComponent textComponent3 : pages) {
            if (textComponent3 == null) continue;
            finalPages[secondCounter] = textComponent3;
            ++secondCounter;
        }
        return BookMaker.generateBook(requestingPlayer, finalPages);
    }
}

