/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.mobconstructor.custombosses;

import com.magmaguy.elitemobs.api.EliteMobDamagedEvent;
import com.magmaguy.elitemobs.api.EliteMobDeathEvent;
import com.magmaguy.elitemobs.api.ElitePhaseSwitchEvent;
import com.magmaguy.elitemobs.api.internal.RemovalReason;
import com.magmaguy.elitemobs.config.custombosses.CustomBossesConfig;
import com.magmaguy.elitemobs.config.custombosses.CustomBossesConfigFields;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomMusic;
import com.magmaguy.elitemobs.utils.ConfigurationLocation;
import com.magmaguy.elitemobs.utils.EventCaller;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class PhaseBossEntity {
    private final CustomBossEntity customBossEntity;
    private List<BossPhase> bossPhases = new ArrayList<BossPhase>();
    private BossPhase currentPhase = null;
    private Location originalSpawnLocation;

    public PhaseBossEntity(CustomBossEntity customBossEntity) {
        this.customBossEntity = customBossEntity;
        try {
            ArrayList<BossPhase> unsortedBossPhases = new ArrayList<BossPhase>();
            unsortedBossPhases.add(new BossPhase(customBossEntity.getCustomBossesConfigFields(), 1.0));
            for (String phaseConfigFile : customBossEntity.getCustomBossesConfigFields().getPhases()) {
                CustomBossesConfigFields customBossesConfigFields = CustomBossesConfig.getCustomBoss(phaseConfigFile.split(":")[0]);
                if (customBossesConfigFields == null) {
                    Logger.warn("Phase boss " + String.valueOf(customBossEntity.getCustomBossesConfigFields()) + " has an invalid config entry for phase " + phaseConfigFile.split(":")[0] + " - this file could not be found. The boss will not be able to do this phase until it is fixed!");
                }
                double healthPercentage = Double.parseDouble(phaseConfigFile.split(":")[1]);
                unsortedBossPhases.add(new BossPhase(customBossesConfigFields, healthPercentage));
            }
            unsortedBossPhases.sort((o1, o2) -> (int)(o2.healthPercentage * 100.0 - o1.healthPercentage * 100.0));
            this.bossPhases = unsortedBossPhases;
            this.currentPhase = this.bossPhases.get(0);
        }
        catch (Exception ex) {
            Logger.warn("Your phase boss " + customBossEntity.customBossesConfigFields.getFilename() + " does not have a valid phases setup. Its phases will not work.");
        }
    }

    public boolean isInFirstPhase() {
        return this.bossPhases.get(0).equals(this.currentPhase);
    }

    private void switchPhase(BossPhase bossPhase, RemovalReason removalReason, double healthPercentage) {
        if (this.isInFirstPhase()) {
            this.originalSpawnLocation = this.customBossEntity.getSpawnLocation().clone();
        }
        if (bossPhase.equals(this.currentPhase)) {
            Logger.warn("Attempted to change the boss phase to what it already was.", true);
            return;
        }
        this.customBossEntity.remove(removalReason);
        if (this.customBossEntity.getCustomModel() != null) {
            this.customBossEntity.getCustomModel().switchPhase();
        }
        if (bossPhase.customBossesConfigFields == null) {
            Logger.warn("A phase for phase boss " + this.bossPhases.get((int)0).customBossesConfigFields.getFilename() + " was not valid! The boss will not be able to switch phases until it is fixed.");
            return;
        }
        this.customBossEntity.setCustomBossesConfigFields(bossPhase.customBossesConfigFields);
        if (removalReason.equals((Object)RemovalReason.PHASE_BOSS_RESET)) {
            if (bossPhase.customBossesConfigFields.getSong() != null) {
                this.customBossEntity.setBossMusic(new CustomMusic(bossPhase.customBossesConfigFields.getSong(), this.customBossEntity));
            }
            this.customBossEntity.setSpawnLocation(this.originalSpawnLocation);
            this.customBossEntity.setRespawnOverrideLocation(this.originalSpawnLocation);
            this.customBossEntity.spawn(true);
        } else {
            if (bossPhase.customBossesConfigFields.getPhaseSpawnLocation() != null) {
                Location location = ConfigurationLocation.serialize(bossPhase.customBossesConfigFields.getPhaseSpawnLocation(), true);
                if (bossPhase.customBossesConfigFields.getPhaseSpawnLocation() != null && bossPhase.customBossesConfigFields.getPhaseSpawnLocation().split(",")[0].equalsIgnoreCase("same_as_boss")) {
                    location.setWorld(this.customBossEntity.getLocation().getWorld());
                }
                if (location != null) {
                    this.customBossEntity.setSpawnLocation(location);
                    this.customBossEntity.setRespawnOverrideLocation(location);
                    this.customBossEntity.setPersistentLocation(location);
                } else {
                    this.customBossEntity.setRespawnOverrideLocation(this.customBossEntity.getLocation());
                    this.customBossEntity.setPersistentLocation(this.customBossEntity.getLocation());
                }
            } else {
                this.customBossEntity.setRespawnOverrideLocation(this.customBossEntity.getLocation());
            }
            if (bossPhase.customBossesConfigFields.getSong() != null) {
                if (this.currentPhase.customBossesConfigFields.getSong() == null) {
                    this.customBossEntity.setBossMusic(new CustomMusic(bossPhase.customBossesConfigFields.getSong(), this.customBossEntity));
                    this.customBossEntity.getBossMusic().start(this.customBossEntity);
                }
                if (!bossPhase.customBossesConfigFields.getSong().equals(this.currentPhase.customBossesConfigFields.getSong())) {
                    if (this.customBossEntity.getBossMusic() != null) {
                        this.customBossEntity.getBossMusic().stop();
                    }
                    this.customBossEntity.setBossMusic(new CustomMusic(bossPhase.customBossesConfigFields.getSong(), this.customBossEntity));
                }
            }
            this.customBossEntity.getSpawnLocation().getChunk().load();
            this.customBossEntity.spawn(true);
        }
        this.currentPhase = bossPhase;
        ElitePhaseSwitchEvent elitePhaseSwitchEvent = new ElitePhaseSwitchEvent(this.customBossEntity, this);
        new EventCaller(elitePhaseSwitchEvent);
        this.customBossEntity.setHealth(this.customBossEntity.getMaxHealth() * healthPercentage);
        this.customBossEntity.setCombatGracePeriod(20);
    }

    public void resetToFirstPhase() {
        this.switchPhase(this.bossPhases.get(0), RemovalReason.PHASE_BOSS_RESET, 1.0);
    }

    public void silentReset() {
        this.currentPhase = this.bossPhases.get(0);
        this.customBossEntity.setCustomBossesConfigFields(this.currentPhase.customBossesConfigFields);
    }

    public CustomBossesConfigFields getPhase1Config() {
        return this.bossPhases.get((int)0).customBossesConfigFields;
    }

    public void checkPhaseBossSwitch(EliteMobDamagedEvent event) {
        if (this.bossPhases.indexOf(this.currentPhase) + 1 >= this.bossPhases.size()) {
            return;
        }
        BossPhase nextBossPhase = this.bossPhases.get(this.bossPhases.indexOf(this.currentPhase) + 1);
        double newHealth = Math.max((this.customBossEntity.getHealth() - event.getDamage()) / this.customBossEntity.getMaxHealth(), 0.0);
        if (newHealth > nextBossPhase.healthPercentage) {
            return;
        }
        event.setCancelled(true);
        this.switchPhase(nextBossPhase, RemovalReason.PHASE_BOSS_PHASE_END, nextBossPhase.healthPercentage);
    }

    @Generated
    public List<BossPhase> getBossPhases() {
        return this.bossPhases;
    }

    public class BossPhase {
        public CustomBossesConfigFields customBossesConfigFields;
        public double healthPercentage;

        public BossPhase(CustomBossesConfigFields customBossesConfigFields, double healthPercentage) {
            this.customBossesConfigFields = customBossesConfigFields;
            this.healthPercentage = healthPercentage;
        }
    }

    public static class PhaseBossEntityListener
    implements Listener {
        @EventHandler(ignoreCancelled=true)
        public void onEliteDamaged(EliteMobDamagedEvent event) {
            if (!(event.getEliteEntity() instanceof CustomBossEntity)) {
                return;
            }
            if (((CustomBossEntity)event.getEliteEntity()).getPhaseBossEntity() == null) {
                return;
            }
            ((CustomBossEntity)event.getEliteEntity()).getPhaseBossEntity().checkPhaseBossSwitch(event);
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onEliteDeath(EliteMobDeathEvent event) {
            EliteEntity eliteEntity = event.getEliteEntity();
            if (!(eliteEntity instanceof CustomBossEntity)) {
                return;
            }
            CustomBossEntity customBossEntity = (CustomBossEntity)eliteEntity;
            if (customBossEntity.getPhaseBossEntity() != null) {
                customBossEntity.phaseBossEntity.silentReset();
            }
        }
    }
}

