/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.mobconstructor.custombosses;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.combatsystem.antiexploit.PreventMountExploit;
import com.magmaguy.elitemobs.config.custombosses.CustomBossesConfig;
import com.magmaguy.elitemobs.config.custombosses.CustomBossesConfigFields;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.magmacore.util.Logger;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CustomBossMount {
    private CustomBossMount() {
    }

    public static CustomBossEntity generateMount(final CustomBossEntity customBossEntity) {
        if (customBossEntity.customBossesConfigFields.getMountedEntity() == null) {
            return null;
        }
        if (customBossEntity.getLivingEntity() == null) {
            Logger.warn("Could not spawn mount for boss " + customBossEntity.customBossesConfigFields.getFilename() + " because the boss has no living entity! This probably means some other plugin is preventing this boss from spawning.");
            return null;
        }
        try {
            EntityType entityType = EntityType.valueOf((String)customBossEntity.customBossesConfigFields.getMountedEntity());
            LivingEntity livingEntity = (LivingEntity)customBossEntity.getLivingEntity().getWorld().spawnEntity(customBossEntity.getLivingEntity().getLocation(), entityType);
            PreventMountExploit.bypass = true;
            livingEntity.addPassenger((Entity)customBossEntity.getLivingEntity());
            livingEntity.setRemoveWhenFarAway(false);
            customBossEntity.livingEntityMount = livingEntity;
        }
        catch (Exception ex) {
            CustomBossesConfigFields customBossesConfigFields = CustomBossesConfig.getCustomBoss(customBossEntity.customBossesConfigFields.getMountedEntity());
            if (customBossesConfigFields != null) {
                final CustomBossEntity mountEntity = CustomBossEntity.createCustomBossEntity(customBossEntity.customBossesConfigFields.getMountedEntity());
                if (mountEntity == null) {
                    Logger.warn("Mount for boss " + customBossEntity.getCustomBossesConfigFields().getFilename() + " is not valid!");
                    return null;
                }
                mountEntity.setSpawnLocation(customBossEntity.getLivingEntity().getLocation());
                mountEntity.setBypassesProtections(customBossEntity.getBypassesProtections());
                mountEntity.setPersistent(false);
                mountEntity.setMount(true);
                mountEntity.spawn(false);
                new BukkitRunnable(){

                    public void run() {
                        if (!mountEntity.isValid()) {
                            return;
                        }
                        if (customBossEntity.getLivingEntity() == null) {
                            return;
                        }
                        if (mountEntity.getCustomModel() != null) {
                            mountEntity.getCustomModel().addPassenger(customBossEntity);
                        } else {
                            PreventMountExploit.bypass = true;
                            if (mountEntity.getLivingEntity() != null) {
                                mountEntity.getLivingEntity().addPassenger((Entity)customBossEntity.getLivingEntity());
                            }
                        }
                        customBossEntity.customBossMount = mountEntity;
                    }
                }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 5L);
                return mountEntity;
            }
            Logger.warn("Attempted to make Custom Boss " + customBossEntity.customBossesConfigFields.getFilename() + " mount invalid entity or boss " + customBossEntity.customBossesConfigFields.getMountedEntity() + " . Fix this in the configuration file.");
        }
        return null;
    }
}

