/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.mobconstructor.custombosses;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.config.DefaultConfig;
import com.magmaguy.elitemobs.config.MobCombatSettingsConfig;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.Logger;
import com.magmaguy.magmacore.util.Round;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class CustomBossBossBar {
    private final CustomBossEntity customBossEntity;
    private final Map<Player, BossBar> bossBars = new HashMap<Player, BossBar>();
    private final HashSet<Player> trackingPlayers = new HashSet();
    private BukkitTask bossBarUpdater;
    private boolean warned = false;

    public CustomBossBossBar(CustomBossEntity customBossEntity) {
        this.customBossEntity = customBossEntity;
        this.start();
        this.sendLocation();
    }

    private void sendLocation() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getWorld().equals(this.customBossEntity.getLocation().getWorld())) continue;
            TextComponent interactiveMessage = new TextComponent(MobCombatSettingsConfig.getBossLocationMessage());
            interactiveMessage.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/elitemobs track boss " + String.valueOf(this.customBossEntity.getEliteUUID())));
            interactiveMessage.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(DefaultConfig.getTrackMessage().replace("$name", this.customBossEntity.getName())).create()));
            player.spigot().sendMessage((BaseComponent)interactiveMessage);
        }
    }

    public void addTrackingPlayer(Player player) {
        if (!this.customBossEntity.exists()) {
            this.remove();
            return;
        }
        if (!this.trackingPlayers.contains(player)) {
            this.trackingPlayers.add(player);
        } else {
            this.trackingPlayers.remove(player);
        }
    }

    public void removeTrackingPlayer(Player player) {
        this.trackingPlayers.remove(player);
        BossBar bossBar = this.bossBars.remove(player);
        if (bossBar != null) {
            bossBar.removeAll();
        }
    }

    public void remove() {
        this.bossBars.values().forEach(BossBar::removeAll);
        this.bossBars.clear();
        this.trackingPlayers.clear();
        this.bossBarUpdater.cancel();
        CustomBossEntity.trackableCustomBosses.remove(this.customBossEntity);
    }

    public String bossBarMessage(Player player, String locationString) {
        if (this.customBossEntity.getCustomBossesConfigFields().getLocationMessage() == null) {
            return "";
        }
        if (this.customBossEntity.getCustomBossesConfigFields().getLocationMessage().contains("$distance") || this.customBossEntity.getCustomBossesConfigFields().getLocationMessage().contains("$location")) {
            if (!player.getLocation().getWorld().equals(this.customBossEntity.getLocation().getWorld())) {
                return ChatColorConverter.convert(MobCombatSettingsConfig.getDefaultOtherWorldBossLocationMessage().replace("$name", this.customBossEntity.getName()));
            }
            return ChatColorConverter.convert(this.customBossEntity.getCustomBossesConfigFields().getLocationMessage().replace("$distance", "" + (int)this.customBossEntity.getLocation().distance(player.getLocation()))).replace("$location", locationString);
        }
        return ChatColorConverter.convert(this.customBossEntity.getCustomBossesConfigFields().getLocationMessage());
    }

    private void updateBossBar(Player player, BossBar bossBar) {
        if (player == null) {
            return;
        }
        if (bossBar == null) {
            return;
        }
        String locationString = this.customBossEntity.getLocation().getBlockX() + ", " + this.customBossEntity.getLocation().getBlockY() + ", " + this.customBossEntity.getLocation().getBlockZ();
        bossBar.setTitle(this.bossBarMessage(player, locationString));
        double progress = Round.twoDecimalPlaces(this.customBossEntity.getHealth() / this.customBossEntity.getMaxHealth());
        if (progress > 1.0) {
            return;
        }
        bossBar.setProgress(progress);
    }

    public void start() {
        this.bossBarUpdater = new BukkitRunnable(){

            public void run() {
                if (!CustomBossBossBar.this.customBossEntity.exists() || CustomBossBossBar.this.customBossEntity.getCustomBossesConfigFields().getLocationMessage() == null) {
                    this.cancel();
                    CustomBossBossBar.this.remove();
                    return;
                }
                HashSet<Player> freshIteration = new HashSet<Player>();
                for (Player player : CustomBossBossBar.this.trackingPlayers) {
                    freshIteration.add(player);
                    if (!CustomBossBossBar.this.bossBars.containsKey(player)) {
                        CustomBossBossBar.this.createBossBar(player);
                    }
                    CustomBossBossBar.this.updateBossBar(player, CustomBossBossBar.this.bossBars.get(player));
                }
                CustomBossBossBar.this.bossBars.entrySet().removeIf(entry -> {
                    if (!CustomBossBossBar.this.trackingPlayers.contains(entry.getKey())) {
                        ((BossBar)entry.getValue()).removeAll();
                        return true;
                    }
                    return false;
                });
                if (CustomBossBossBar.this.customBossEntity.isValid()) {
                    for (Entity entity : CustomBossBossBar.this.customBossEntity.getLivingEntity().getNearbyEntities(30.0, 30.0, 30.0)) {
                        if (!entity.getType().equals((Object)EntityType.PLAYER) || freshIteration.contains((Player)entity)) continue;
                        CustomBossBossBar.this.createBossBar((Player)entity);
                    }
                }
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 5L);
    }

    private void createBossBar(Player player) {
        String locationString = (int)this.customBossEntity.getLocation().getX() + ", " + (int)this.customBossEntity.getLocation().getY() + ", " + (int)this.customBossEntity.getLocation().getZ();
        BossBar bossBar = Bukkit.createBossBar((String)this.bossBarMessage(player, locationString), (BarColor)BarColor.GREEN, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[]{BarFlag.PLAY_BOSS_MUSIC});
        if (!this.customBossEntity.exists()) {
            return;
        }
        if (this.customBossEntity.getHealth() / this.customBossEntity.getMaxHealth() > 1.0 || this.customBossEntity.getHealth() / this.customBossEntity.getMaxHealth() < 0.0) {
            if (!this.warned) {
                Logger.warn("The following boss had more health than it should: " + this.customBossEntity.getName());
                Logger.warn("This is a problem usually caused by running more than one plugin that modifies mob health! EliteMobs can't fix this issue because it is being caused by another plugin. If you want EliteMobs to work correctly, find a way to fix this issue with whatever other plugin is causing it.");
                this.warned = true;
            }
            return;
        }
        this.bossBars.put(player, bossBar);
        this.updateBossBar(player, bossBar);
        bossBar.addPlayer(player);
    }
}

