/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.menus;

import com.magmaguy.elitemobs.config.menus.premade.GetLootMenuConfig;
import com.magmaguy.elitemobs.items.customitems.CustomItem;
import com.magmaguy.elitemobs.menus.EliteMenu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GetLootMenu
extends EliteMenu
implements Listener {
    private static final List<Integer> lootSlots = new ArrayList<Integer>(new ArrayList<Integer>(List.of(10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43, 46, 47, 48, 49, 50, 51, 52)));
    public static HashMap<UUID, GetLootMenu> inventories = new HashMap();
    private final String shopName = GetLootMenuConfig.menuName;
    public int currentHeaderPage = 1;
    public int currentLootPage = 1;
    public boolean filter = false;
    public int filterRank = 0;
    public Inventory inventory;

    public GetLootMenu(Player player) {
        Inventory fakeChestInventory = Bukkit.createInventory(null, (int)54, (String)this.shopName);
        this.tierConstructor(fakeChestInventory);
        this.headerConstructor(fakeChestInventory);
        this.lootNavigationConstructor(fakeChestInventory);
        this.lootConstructor(fakeChestInventory);
        player.openInventory(fakeChestInventory);
        this.inventory = fakeChestInventory;
        inventories.put(player.getUniqueId(), this);
    }

    public GetLootMenu(Player player, GetLootMenu getLootMenu) {
        this.currentHeaderPage = getLootMenu.currentHeaderPage;
        this.currentLootPage = getLootMenu.currentLootPage;
        this.filter = getLootMenu.filter;
        this.filterRank = getLootMenu.filterRank;
        Inventory fakeChestInventory = Bukkit.createInventory(null, (int)54, (String)this.shopName);
        this.tierConstructor(fakeChestInventory);
        this.headerConstructor(fakeChestInventory);
        this.lootNavigationConstructor(fakeChestInventory);
        this.lootConstructor(fakeChestInventory);
        player.openInventory(fakeChestInventory);
        this.inventory = fakeChestInventory;
        inventories.put(player.getUniqueId(), this);
    }

    public static void shutdown() {
        inventories.clear();
    }

    private void headerConstructor(Inventory inventory) {
        inventory.setItem(0, GetLootMenuConfig.leftArrowItem);
        inventory.setItem(8, GetLootMenuConfig.rightArrowItem);
        inventory.setItem(4, GetLootMenuConfig.infoItem);
    }

    private void tierConstructor(Inventory inventory) {
        ArrayList<Integer> tierSlots = new ArrayList<Integer>();
        tierSlots.add(1);
        tierSlots.add(2);
        tierSlots.add(3);
        tierSlots.add(5);
        tierSlots.add(6);
        tierSlots.add(7);
        ArrayList<Integer> keySet = new ArrayList<Integer>(CustomItem.getTieredLoot().keySet());
        Collections.sort(keySet);
        int counter = 1;
        Iterator iterator = tierSlots.iterator();
        while (iterator.hasNext()) {
            int number = (Integer)iterator.next();
            if (keySet.size() >= counter + (this.currentHeaderPage - 1) * 6) {
                ItemStack chest = new ItemStack(Material.CHEST, 1);
                ItemMeta chestItemMeta = chest.getItemMeta();
                chestItemMeta.setDisplayName(GetLootMenuConfig.tierTranslation + " " + String.valueOf(keySet.get(counter - 1 + (this.currentHeaderPage - 1) * 6)));
                ArrayList<String> lore = new ArrayList<String>();
                lore.add(GetLootMenuConfig.itemFilterTranslation);
                chestItemMeta.setLore(lore);
                chest.setItemMeta(chestItemMeta);
                inventory.setItem(number, chest);
            }
            ++counter;
        }
    }

    private void lootNavigationConstructor(Inventory inventory) {
        inventory.setItem(27, GetLootMenuConfig.previousLootItem);
        inventory.setItem(35, GetLootMenuConfig.nextLootItem);
    }

    private void lootConstructor(Inventory inventory) {
        ArrayList getLootList = new ArrayList();
        for (List list : CustomItem.getTieredLoot().values()) {
            getLootList.addAll(list);
        }
        int counter = 1;
        for (int number : lootSlots) {
            if (!this.filter) {
                if (getLootList.size() >= counter + (this.currentLootPage - 1) * 35) {
                    inventory.setItem(number, (ItemStack)getLootList.get(counter - 1 + (this.currentLootPage - 1) * 35));
                }
            } else {
                List currentRankLoot = CustomItem.getTieredLoot().get(this.filterRank);
                if (currentRankLoot.size() >= counter + (this.currentLootPage - 1) * 35) {
                    inventory.setItem(number, (ItemStack)currentRankLoot.get(counter - 1 + (this.currentLootPage - 1) * 35));
                }
            }
            ++counter;
        }
    }

    public static class GetLootMenuListener
    implements Listener {
        @EventHandler
        public void onClick(InventoryClickEvent event) {
            GetLootMenu getLootMenu = null;
            for (GetLootMenu iteratedMenu : inventories.values()) {
                if (iteratedMenu == null || !iteratedMenu.inventory.equals(event.getInventory())) continue;
                getLootMenu = iteratedMenu;
                break;
            }
            if (getLootMenu == null) {
                return;
            }
            if (event.getClickedInventory() == null) {
                return;
            }
            event.setCancelled(true);
            Player player = (Player)event.getWhoClicked();
            ItemStack currentItem = event.getCurrentItem();
            if (!EliteMenu.isTopMenu(event)) {
                return;
            }
            if (currentItem == null) {
                return;
            }
            if (lootSlots.contains(event.getSlot())) {
                player.getInventory().addItem(new ItemStack[]{currentItem});
                return;
            }
            if (currentItem == null || currentItem.getItemMeta() == null) {
                return;
            }
            if (event.getSlot() == 4) {
                new GetLootMenu(player);
                return;
            }
            if (event.getSlot() == 0) {
                if (getLootMenu.currentHeaderPage - 1 > 1) {
                    --getLootMenu.currentHeaderPage;
                    new GetLootMenu(player, getLootMenu);
                }
                return;
            }
            if (event.getSlot() == 8) {
                ++getLootMenu.currentHeaderPage;
                new GetLootMenu(player, getLootMenu);
                return;
            }
            if (event.getSlot() == 27) {
                if (getLootMenu.currentLootPage - 1 < 1) {
                    return;
                }
                --getLootMenu.currentLootPage;
                new GetLootMenu(player, getLootMenu);
                return;
            }
            if (event.getSlot() == 35) {
                ++getLootMenu.currentLootPage;
                new GetLootMenu(player, getLootMenu);
                return;
            }
            if (event.getSlot() == 1 || event.getSlot() == 2 || event.getSlot() == 3 || event.getSlot() == 5 || event.getSlot() == 6 || event.getSlot() == 7) {
                getLootMenu.filter = true;
                getLootMenu.filterRank = Integer.parseInt(currentItem.getItemMeta().getDisplayName().split("\\s")[1]);
                getLootMenu.currentLootPage = 1;
                new GetLootMenu(player, getLootMenu);
            }
        }
    }
}

