/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.items.customloottable;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.utils.EliteItemManager;
import com.magmaguy.elitemobs.items.EliteItemLore;
import com.magmaguy.elitemobs.items.customenchantments.SoulbindEnchantment;
import com.magmaguy.elitemobs.items.customitems.CustomItem;
import com.magmaguy.elitemobs.menus.LootMenu;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.magmacore.util.ChatColorConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SharedLootTable {
    private static final HashMap<EliteEntity, SharedLootTable> sharedLootTables = new HashMap();
    private final int durationInSeconds = 60;
    private final List<ItemStack> loot = new ArrayList<ItemStack>();
    private final EliteEntity eliteEntity;
    private final List<Player> damagers;
    private final List<LootMenu> lootMenus = new ArrayList<LootMenu>();
    private final HashMap<Player, PlayerTable> playerTables = new HashMap();

    public static void shutdown() {
        sharedLootTables.clear();
    }

    public SharedLootTable(EliteEntity eliteEntity) {
        this.eliteEntity = eliteEntity;
        this.damagers = eliteEntity.getDamagers().keySet().stream().toList();
        sharedLootTables.put(eliteEntity, this);
        this.damagers.forEach(damager -> this.lootMenus.add(new LootMenu((Player)damager, this, this.getPlayerTable((Player)damager))));
        if (this.damagers.size() > 1) {
            Bukkit.getScheduler().runTaskLater((Plugin)MetadataHandler.PLUGIN, this::messagePlayers, 1L);
        }
        this.endLoot();
    }

    private void messagePlayers() {
        this.damagers.forEach(damagers -> {
            damagers.sendMessage(ChatColorConverter.convert("&e&l---------------------------------------------"));
            damagers.sendMessage(ChatColorConverter.convert("&8[EliteMobs] &6Loot vote! Do &9/em loot &6 to vote on " + this.loot.size() + " items!"));
            damagers.sendMessage(ChatColorConverter.convert("&e&l---------------------------------------------"));
        });
    }

    public void addLoot(ItemStack itemStack) {
        this.loot.add(itemStack);
    }

    private void endLoot() {
        if (this.damagers.size() < 2) {
            new BukkitRunnable(){

                public void run() {
                    SharedLootTable.this.distribute();
                }
            }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 1L);
            return;
        }
        new BukkitRunnable(){

            public void run() {
                SharedLootTable.this.distribute();
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 1200L);
    }

    private void distribute() {
        for (ItemStack lootInstance : this.loot) {
            ArrayList<Player> needPlayers = new ArrayList<Player>();
            for (PlayerTable playerTable : this.playerTables.values()) {
                for (ItemStack neededLoot : playerTable.getNeedItems()) {
                    if (!neededLoot.isSimilar(lootInstance)) continue;
                    needPlayers.add(playerTable.player);
                }
            }
            if (needPlayers.isEmpty()) {
                this.rollLoot(lootInstance, this.damagers);
                continue;
            }
            this.rollLoot(lootInstance, needPlayers);
        }
        sharedLootTables.remove(this.eliteEntity);
        this.lootMenus.forEach(LootMenu::removeMenu);
    }

    private void rollLoot(ItemStack item, List<Player> players) {
        Player player = players.get(ThreadLocalRandom.current().nextInt(players.size()));
        SoulbindEnchantment.addEnchantment(item, player);
        new EliteItemLore(item, false);
        int newLevel = CustomItem.limitItemLevel(player, EliteItemManager.getRoundedItemLevel(item));
        EliteItemManager.setEliteLevel(item, newLevel);
        HashMap pendingItems = player.getInventory().addItem(new ItemStack[]{item});
        if (!pendingItems.isEmpty()) {
            player.getWorld().dropItemNaturally(player.getLocation(), item);
        }
        players.forEach(thisPlayer -> thisPlayer.sendMessage(player.getDisplayName() + String.valueOf(ChatColor.GREEN) + " received " + item.getItemMeta().getDisplayName() + " !"));
    }

    public PlayerTable getPlayerTable(Player player) {
        PlayerTable playerTable = this.playerTables.get(player);
        if (playerTable == null) {
            playerTable = new PlayerTable(player, this);
        }
        return playerTable;
    }

    @Generated
    public static HashMap<EliteEntity, SharedLootTable> getSharedLootTables() {
        return sharedLootTables;
    }

    @Generated
    public List<ItemStack> getLoot() {
        return this.loot;
    }

    public class PlayerTable {
        private final List<ItemStack> needItems = new ArrayList<ItemStack>();
        private final Player player;
        private final SharedLootTable sharedLootTable;

        public PlayerTable(Player player, SharedLootTable sharedLootTable) {
            this.player = player;
            this.sharedLootTable = sharedLootTable;
            SharedLootTable.this.playerTables.put(player, this);
        }

        public void addNeed(ItemStack itemStack) {
            this.needItems.add(itemStack);
            this.sharedLootTable.damagers.forEach(damager -> damager.sendMessage(ChatColorConverter.convert(this.player.getDisplayName() + " &chas selected need for " + itemStack.getItemMeta().getDisplayName() + " !")));
        }

        public void removeNeed(ItemStack itemStack) {
            this.needItems.remove(itemStack);
            this.sharedLootTable.damagers.forEach(damager -> damager.sendMessage(ChatColorConverter.convert(this.player.getDisplayName() + " &2has selected greed for " + itemStack.getItemMeta().getDisplayName() + " !")));
        }

        @Generated
        public List<ItemStack> getNeedItems() {
            return this.needItems;
        }
    }
}

