/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.items.customenchantments;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.config.enchantments.EnchantmentsConfig;
import com.magmaguy.elitemobs.items.ItemTagger;
import com.magmaguy.elitemobs.items.customenchantments.CustomEnchantment;
import com.magmaguy.elitemobs.npcs.NPCEntity;
import com.magmaguy.magmacore.util.ChatColorConverter;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SummonMerchantEnchantment
extends CustomEnchantment
implements Listener {
    private static final String merchantMessage = EnchantmentsConfig.getEnchantment("summon_merchant.yml").getFileConfiguration().getString("message");
    public static String key = "summon_merchant";

    public SummonMerchantEnchantment() {
        super(key, false);
    }

    private static int getEnchantment(ItemMeta itemMeta) {
        return ItemTagger.getEnchantment(itemMeta, key);
    }

    public static void doSummonMerchant(final Player player, boolean fromMessage, ItemStack itemStack) {
        if (itemStack != null) {
            itemStack.setAmount(itemStack.getAmount() - 1);
        }
        if (!fromMessage) {
            new NPCEntity(player.getLocation());
            if (!merchantMessage.isEmpty()) {
                player.chat(ChatColorConverter.convert(merchantMessage));
            }
            return;
        }
        new BukkitRunnable(){

            public void run() {
                new NPCEntity(player.getLocation());
            }
        }.runTask((Plugin)MetadataHandler.PLUGIN);
    }

    public static class SummonMerchantEvents
    implements Listener {
        private static final Set<UUID> playerCooldowns = new HashSet<UUID>();

        public static void shutdown() {
            playerCooldowns.clear();
        }

        @EventHandler
        public void onItemInteract(PlayerInteractEvent event) {
            if (!event.getAction().equals((Object)Action.RIGHT_CLICK_AIR) && !event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
                return;
            }
            if (SummonMerchantEnchantment.getEnchantment(event.getPlayer().getInventory().getItemInMainHand().getItemMeta()) < 1) {
                return;
            }
            final UUID playerUUID = event.getPlayer().getUniqueId();
            if (playerCooldowns.contains(playerUUID)) {
                return;
            }
            playerCooldowns.add(playerUUID);
            new BukkitRunnable(){

                public void run() {
                    playerCooldowns.remove(playerUUID);
                }
            }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 1200L);
            SummonMerchantEnchantment.doSummonMerchant(event.getPlayer(), false, event.getPlayer().getInventory().getItemInMainHand());
        }

        @EventHandler
        public void onPlayerChat(AsyncPlayerChatEvent event) {
            if (merchantMessage.isEmpty()) {
                return;
            }
            if (event.getMessage().equalsIgnoreCase(merchantMessage)) {
                final UUID playerUUID = event.getPlayer().getUniqueId();
                if (playerCooldowns.contains(playerUUID)) {
                    return;
                }
                playerCooldowns.add(playerUUID);
                new BukkitRunnable(){

                    public void run() {
                        playerCooldowns.remove(playerUUID);
                    }
                }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 1200L);
                for (ItemStack itemStack : event.getPlayer().getInventory()) {
                    if (itemStack == null || SummonMerchantEnchantment.getEnchantment(itemStack.getItemMeta()) <= 0) continue;
                    SummonMerchantEnchantment.doSummonMerchant(event.getPlayer(), true, itemStack);
                    return;
                }
            }
        }
    }
}

