/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.items.customenchantments;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.config.enchantments.EnchantmentsConfig;
import com.magmaguy.elitemobs.events.BossCustomAttackDamage;
import com.magmaguy.elitemobs.items.customenchantments.CustomEnchantment;
import com.magmaguy.elitemobs.playerdata.ElitePlayerInventory;
import com.magmaguy.elitemobs.utils.CooldownHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class FlamethrowerEnchantment
extends CustomEnchantment {
    private static final Set<UUID> playersUsingFlamethrower = new HashSet<UUID>();
    public static String key = "flamethrower";

    public FlamethrowerEnchantment() {
        super(key, false);
    }

    private static List<Location> generateDamagePoints(Player player, Location fixedPlayerLocation) {
        ArrayList<Location> locations = new ArrayList<Location>();
        Location eliteMobLocation = player.getLocation().clone();
        Vector toPlayerVector = fixedPlayerLocation.clone().subtract(eliteMobLocation).toVector().normalize().multiply(0.5);
        for (int i = 0; i < 40; ++i) {
            locations.add(eliteMobLocation.add(toPlayerVector).clone());
        }
        return locations;
    }

    private static void doDamage(List<Location> locations, Player player) {
        for (Location location : locations) {
            try {
                for (Entity entity : location.getWorld().getNearbyEntities(location, 0.5, 0.5, 0.5)) {
                    if (!(entity instanceof LivingEntity) || entity.getType().equals((Object)EntityType.PLAYER) || ((LivingEntity)entity).hasPotionEffect(PotionEffectType.FIRE_RESISTANCE)) continue;
                    BossCustomAttackDamage.dealCustomDamage((LivingEntity)player, (LivingEntity)entity, ElitePlayerInventory.playerInventories.get(player.getUniqueId()).getWeaponLevel(false));
                }
            }
            catch (Exception exception) {
            }
        }
    }

    public static void shutdown() {
        playersUsingFlamethrower.clear();
    }

    public static class FlamethrowerEnchantmentEvents
    implements Listener {
        @EventHandler
        public void onInteract(PlayerInteractEvent event) {
            if (!EnchantmentsConfig.getEnchantment("flamethrower.yml").isEnabled()) {
                return;
            }
            Player player = event.getPlayer();
            if (!event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && !event.getAction().equals((Object)Action.RIGHT_CLICK_AIR)) {
                return;
            }
            if (playersUsingFlamethrower.contains(player.getUniqueId())) {
                return;
            }
            ItemStack zombieKingAxe = player.getInventory().getItemInMainHand();
            if (CustomEnchantment.hasCustomEnchantment(zombieKingAxe, "flamethrower")) {
                if (zombieKingAxe.getDurability() + 4 > zombieKingAxe.getType().getMaxDurability()) {
                    return;
                }
                zombieKingAxe.setDurability((short)(zombieKingAxe.getDurability() + 4));
                this.doFlamethrowerPhase1(player, player.getTargetBlock(null, 30).getLocation().clone().add(0.5, 1.0, 0.5));
                CooldownHandler.initialize(playersUsingFlamethrower.stream().toList(), player.getUniqueId(), 180);
                player.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 100, 20));
            }
        }

        private void doFlamethrowerPhase1(final Player player, final Location targetLocation) {
            new BukkitRunnable(){
                int counter = 0;

                public void run() {
                    if (!player.isValid() || !player.getLocation().getWorld().equals(targetLocation.getWorld())) {
                        this.cancel();
                        return;
                    }
                    this.doParticleEffect(player, targetLocation, Particle.SMOKE);
                    ++this.counter;
                    if (this.counter < 20) {
                        return;
                    }
                    this.doFlamethrowerPhase2(player, targetLocation);
                    this.cancel();
                }
            }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
        }

        private void doParticleEffect(Player player, Location target, Particle particle) {
            if (!player.getWorld().equals(target.getWorld())) {
                return;
            }
            Vector directionVector = target.clone().subtract(player.getLocation()).toVector().normalize();
            for (int i = 0; i < 5; ++i) {
                player.getWorld().spawnParticle(particle, player.getEyeLocation().clone().add(directionVector.getX(), -0.5, directionVector.getZ()), 0, (ThreadLocalRandom.current().nextDouble() - 0.5) * 0.1 + directionVector.getX(), (ThreadLocalRandom.current().nextDouble() - 0.5) * 0.1 + directionVector.getY(), (ThreadLocalRandom.current().nextDouble() - 0.5) * 0.1 + directionVector.getZ(), ThreadLocalRandom.current().nextDouble() + 0.05);
            }
        }

        private void doFlamethrowerPhase2(final Player player, final Location target) {
            final List<Location> damagePoints = FlamethrowerEnchantment.generateDamagePoints(player, target);
            new BukkitRunnable(){
                int timer = 0;

                public void run() {
                    if (!player.isValid() || !player.getLocation().getWorld().equals(target.getWorld())) {
                        this.cancel();
                        return;
                    }
                    this.doParticleEffect(player, target, Particle.FLAME);
                    if (this.timer % 20 == 0) {
                        FlamethrowerEnchantment.doDamage(damagePoints, player);
                    }
                    ++this.timer;
                    if (this.timer < 60) {
                        return;
                    }
                    this.doFlamethrowerPhase3(player, target);
                    this.cancel();
                }
            }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
        }

        private void doFlamethrowerPhase3(final Player player, final Location fixedPlayerLocation) {
            new BukkitRunnable(){
                int timer = 0;

                public void run() {
                    if (!player.isValid() || !player.getLocation().getWorld().equals(fixedPlayerLocation.getWorld())) {
                        this.cancel();
                        return;
                    }
                    ++this.timer;
                    this.doParticleEffect(player, fixedPlayerLocation, Particle.SMOKE);
                    if (this.timer < 20) {
                        return;
                    }
                    this.cancel();
                }
            }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
        }
    }
}

