/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.items.customenchantments;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.config.enchantments.EnchantmentsConfig;
import com.magmaguy.elitemobs.items.ItemTagger;
import com.magmaguy.elitemobs.items.customenchantments.CustomEnchantment;
import com.magmaguy.elitemobs.utils.EventCaller;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class DrillingEnchantment
extends CustomEnchantment {
    public static String key = "drilling";

    public DrillingEnchantment() {
        super(key, false);
    }

    public static void shutdown() {
        DrillingEnchantmentEvents.shutdown();
    }

    public static class DrillingEnchantmentEvents
    implements Listener {
        private static final Set<UUID> activePlayers = new HashSet<UUID>();
        private Material material = null;
        private ItemStack itemStack = null;
        private MiningDirection miningDirection = null;
        private Player player;

        public static void shutdown() {
            activePlayers.clear();
        }

        @EventHandler(priority=EventPriority.HIGHEST)
        public void onDig(BlockBreakEvent event) {
            if (event.isCancelled()) {
                return;
            }
            if (!event.getPlayer().getInventory().getItemInMainHand().hasItemMeta() || event.getPlayer().getInventory().getItemInMainHand().getItemMeta() == null) {
                return;
            }
            if (!ItemTagger.hasEnchantment(event.getPlayer().getInventory().getItemInMainHand().getItemMeta(), new NamespacedKey((Plugin)MetadataHandler.PLUGIN, key))) {
                return;
            }
            if (event.getPlayer().isSneaking()) {
                return;
            }
            if (!EnchantmentsConfig.getEnchantment("drilling.yml").isEnabled()) {
                return;
            }
            if (activePlayers.contains(event.getPlayer().getUniqueId())) {
                return;
            }
            this.drillBlocks(event.getBlock(), ItemTagger.getEnchantment(event.getPlayer().getInventory().getItemInMainHand().getItemMeta(), new NamespacedKey((Plugin)MetadataHandler.PLUGIN, key)), event.getPlayer().getLocation(), event.getPlayer().getInventory().getItemInMainHand(), event.getPlayer());
        }

        private void drillBlocks(Block originalBlock, int enchantmentLevel, Location playerLocation, ItemStack playerItem, Player player) {
            this.player = player;
            this.material = originalBlock.getType();
            this.itemStack = playerItem;
            this.miningDirection = this.determineDirection(originalBlock.getLocation(), playerLocation);
            activePlayers.add(player.getUniqueId());
            switch (enchantmentLevel) {
                case 1: {
                    this.drillLevel1(originalBlock);
                    break;
                }
                case 2: {
                    this.drillLevel2(originalBlock);
                    break;
                }
                case 3: {
                    this.drillLevel3(originalBlock);
                    this.drillLevel2(this.drillLevel1(originalBlock));
                    break;
                }
                case 4: {
                    this.drillLevel3(originalBlock);
                    this.drillLevel3(this.drillLevel1(originalBlock));
                    this.drillLevel2(this.drillLevel1(this.drillLevel1(originalBlock)));
                    break;
                }
                default: {
                    this.drillLevel3(originalBlock);
                    this.drillLevel3(this.drillLevel1(originalBlock));
                    this.drillLevel3(this.drillLevel1(this.drillLevel1(originalBlock)));
                }
            }
            activePlayers.remove(player.getUniqueId());
        }

        private MiningDirection determineDirection(Location blockLocation, Location playerLocation) {
            Location adjustedPlayerLocation = playerLocation.clone().add(new Vector(0, 1, 0));
            Location adjustedBlockLocation = blockLocation.clone().add(new Vector(0.5, 0.5, 0.5));
            Vector directionVector = adjustedBlockLocation.clone().subtract(adjustedPlayerLocation).toVector().normalize();
            double x = directionVector.getX();
            double y = directionVector.getY();
            double z = directionVector.getZ();
            if (Math.abs(y) > 0.9) {
                if (y > 0.0) {
                    return MiningDirection.UP;
                }
                return MiningDirection.DOWN;
            }
            if (Math.abs(x) > Math.abs(z)) {
                if (x > 0.0) {
                    return MiningDirection.EAST;
                }
                return MiningDirection.WEST;
            }
            if (z > 0.0) {
                return MiningDirection.NORTH;
            }
            return MiningDirection.SOUTH;
        }

        private Block processBlock(Block originalBlock, Vector addedVector) {
            if (originalBlock == null) {
                return null;
            }
            Block finalBlock = originalBlock.getWorld().getBlockAt(originalBlock.getLocation().clone().add(addedVector));
            if (!this.material.equals((Object)finalBlock.getType())) {
                return finalBlock;
            }
            BlockBreakEvent blockBreakEvent = new BlockBreakEvent(finalBlock, this.player);
            new EventCaller((Event)blockBreakEvent);
            if (blockBreakEvent.isCancelled()) {
                return null;
            }
            finalBlock.breakNaturally(this.itemStack);
            return finalBlock;
        }

        private Block drillLevel1(Block originalBlock) {
            switch (this.miningDirection) {
                case NORTH: {
                    return this.processBlock(originalBlock, new Vector(0, 0, 1));
                }
                case SOUTH: {
                    return this.processBlock(originalBlock, new Vector(0, 0, -1));
                }
                case EAST: {
                    return this.processBlock(originalBlock, new Vector(1, 0, 0));
                }
                case WEST: {
                    return this.processBlock(originalBlock, new Vector(-1, 0, 0));
                }
                case UP: {
                    return this.processBlock(originalBlock, new Vector(0, 1, 0));
                }
                case DOWN: {
                    return this.processBlock(originalBlock, new Vector(0, -1, 0));
                }
            }
            return null;
        }

        private void drillLevel2(Block originalBlock) {
            switch (this.miningDirection) {
                case NORTH: 
                case SOUTH: {
                    this.processBlock(originalBlock, new Vector(0, 1, 0));
                    this.processBlock(originalBlock, new Vector(0, -1, 0));
                    this.processBlock(originalBlock, new Vector(1, 0, 0));
                    this.processBlock(originalBlock, new Vector(-1, 0, 0));
                    break;
                }
                case EAST: 
                case WEST: {
                    this.processBlock(originalBlock, new Vector(0, 1, 0));
                    this.processBlock(originalBlock, new Vector(0, -1, 0));
                    this.processBlock(originalBlock, new Vector(0, 0, 1));
                    this.processBlock(originalBlock, new Vector(0, 0, -1));
                    break;
                }
                case UP: 
                case DOWN: {
                    this.processBlock(originalBlock, new Vector(1, 0, 0));
                    this.processBlock(originalBlock, new Vector(-1, 0, 0));
                    this.processBlock(originalBlock, new Vector(0, 0, 1));
                    this.processBlock(originalBlock, new Vector(0, 0, -1));
                }
            }
        }

        private void drillLevel3(Block originalBlock) {
            switch (this.miningDirection) {
                case NORTH: 
                case SOUTH: {
                    for (int x = -1; x < 2; ++x) {
                        for (int y = -1; y < 2; ++y) {
                            if (x == 0 && y == 0) continue;
                            this.processBlock(originalBlock, new Vector(x, y, 0));
                        }
                    }
                    break;
                }
                case EAST: 
                case WEST: {
                    for (int y = -1; y < 2; ++y) {
                        for (int z = -1; z < 2; ++z) {
                            if (y == 0 && z == 0) continue;
                            this.processBlock(originalBlock, new Vector(0, y, z));
                        }
                    }
                    break;
                }
                case UP: 
                case DOWN: {
                    for (int x = -1; x < 2; ++x) {
                        for (int z = -1; z < 2; ++z) {
                            if (x == 0 && z == 0) continue;
                            this.processBlock(originalBlock, new Vector(x, 0, z));
                        }
                    }
                    break;
                }
            }
        }

        private static enum MiningDirection {
            UP,
            DOWN,
            NORTH,
            SOUTH,
            EAST,
            WEST;

        }
    }
}

