/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.events;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.adventurersguild.GuildRank;
import com.magmaguy.elitemobs.api.CustomEventStartEvent;
import com.magmaguy.elitemobs.config.EventsConfig;
import com.magmaguy.elitemobs.config.customevents.CustomEventsConfig;
import com.magmaguy.elitemobs.config.customevents.CustomEventsConfigFields;
import com.magmaguy.elitemobs.events.CustomEvent;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.elitemobs.utils.EventCaller;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class ActionEvent
extends CustomEvent {
    private static final List<ActionEvent> blueprintEvents = new ArrayList<ActionEvent>();
    private static final Set<UUID> playerCooldowns = new HashSet<UUID>();
    private final double chance;
    private final List<Material> breakableMaterials;
    private Player player;

    public ActionEvent(CustomEventsConfigFields customEventsConfigFields) {
        super(customEventsConfigFields);
        this.chance = customEventsConfigFields.getChance();
        this.breakableMaterials = customEventsConfigFields.getBreakableMaterials();
        this.setPrimaryCustomBossFilenames(this.primaryCustomBossFilenames);
    }

    public static void shutdown() {
        blueprintEvents.clear();
        playerCooldowns.clear();
    }

    public static void initializeBlueprintEvents() {
        if (!EventsConfig.isActionEventsEnabled()) {
            return;
        }
        for (CustomEventsConfigFields customEventsConfigFields : CustomEventsConfig.getCustomEvents().values()) {
            if (!customEventsConfigFields.isEnabled()) continue;
            switch (customEventsConfigFields.getEventType()) {
                case BREAK_BLOCK: 
                case FISH: 
                case TILL_SOIL: {
                    blueprintEvents.add(new ActionEvent(customEventsConfigFields));
                    break;
                }
            }
        }
    }

    public boolean checkBlockBreakStartConditions(Material material) {
        if (ThreadLocalRandom.current().nextDouble() >= this.chance) {
            return false;
        }
        return this.breakableMaterials.contains(material);
    }

    public boolean checkFishStartConditions() {
        return ThreadLocalRandom.current().nextDouble() < this.chance;
    }

    public boolean checkTillSoilStartConditions() {
        return ThreadLocalRandom.current().nextDouble() < this.chance;
    }

    public void instantiateEvent(Location location, Player player) {
        this.player = player;
        if (GuildRank.isAtOrAboveGuildRank(player, 0, 0)) {
            return;
        }
        ActionEvent actionEvent = new ActionEvent(this.customEventsConfigFields);
        actionEvent.setEventStartLocation(location);
        CustomEventStartEvent customEventStartEvent = new CustomEventStartEvent(actionEvent);
        new EventCaller(customEventStartEvent);
        if (customEventStartEvent.isCancelled()) {
            return;
        }
        if (!actionEvent.startConditions.areValid()) {
            return;
        }
        for (String filename : this.primaryCustomBossFilenames) {
            CustomBossEntity customBossEntity = CustomBossEntity.createCustomBossEntity(filename);
            if (customBossEntity == null) {
                Logger.warn("Failed to generate custom boss " + filename + " ! This has cancelled action event " + this.customEventsConfigFields.getFilename() + " !");
                return;
            }
            customBossEntity.spawn(actionEvent.getEventStartLocation(), false);
            actionEvent.primaryEliteMobs.add(customBossEntity);
        }
        actionEvent.start();
    }

    @Override
    public void startModifiers() {
        UUID playerUUID = this.player.getUniqueId();
        playerCooldowns.add(playerUUID);
        Bukkit.getScheduler().runTaskLater((Plugin)MetadataHandler.PLUGIN, () -> playerCooldowns.remove(playerUUID), 1200L * (long)EventsConfig.getActionEventMinimumCooldown());
    }

    @Override
    public void eventWatchdog() {
    }

    @Override
    public void endModifiers() {
    }

    public static class ActionEventEvents
    implements Listener {
        @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
        public void onBlockBreakEvent(BlockBreakEvent event) {
            if (playerCooldowns.contains(event.getPlayer().getUniqueId())) {
                return;
            }
            if (!CustomEvent.isLocationValid(event.getBlock().getLocation())) {
                return;
            }
            for (ActionEvent actionEvent : blueprintEvents) {
                if (!actionEvent.eventType.equals((Object)CustomEvent.EventType.BREAK_BLOCK) || !actionEvent.checkBlockBreakStartConditions(event.getBlock().getType())) continue;
                actionEvent.instantiateEvent(event.getBlock().getLocation().clone().add(new Vector(0.5, 0.0, 0.5)), event.getPlayer());
            }
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
        public void onFishEvent(PlayerFishEvent event) {
            if (event.getCaught() == null) {
                return;
            }
            if (playerCooldowns.contains(event.getPlayer().getUniqueId())) {
                return;
            }
            if (!CustomEvent.isLocationValid(event.getCaught().getLocation())) {
                return;
            }
            for (ActionEvent actionEvent : blueprintEvents) {
                if (!actionEvent.eventType.equals((Object)CustomEvent.EventType.FISH) || !actionEvent.checkFishStartConditions()) continue;
                actionEvent.instantiateEvent(event.getCaught().getLocation(), event.getPlayer());
            }
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
        public void onTillSoil(PlayerInteractEvent event) {
            if (!event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
                return;
            }
            if (event.getClickedBlock() == null) {
                return;
            }
            if (playerCooldowns.contains(event.getPlayer().getUniqueId())) {
                return;
            }
            Location location = event.getClickedBlock().getLocation().clone().add(new Vector(0.5, 1.0, 0.5));
            if (!CustomEvent.isLocationValid(location)) {
                return;
            }
            if (!(event.getPlayer().getInventory().getItemInMainHand().getType().equals((Object)Material.DIAMOND_HOE) || event.getPlayer().getInventory().getItemInMainHand().getType().equals((Object)Material.IRON_HOE) || event.getPlayer().getInventory().getItemInMainHand().getType().equals((Object)Material.GOLDEN_HOE) || event.getPlayer().getInventory().getItemInMainHand().getType().equals((Object)Material.STONE_HOE) || event.getPlayer().getInventory().getItemInMainHand().getType().equals((Object)Material.WOODEN_HOE) || event.getPlayer().getInventory().getItemInMainHand().getType().equals((Object)Material.NETHERITE_HOE))) {
                return;
            }
            if (!event.getClickedBlock().getType().equals((Object)Material.DIRT) && !event.getClickedBlock().getType().equals((Object)Material.GRASS_BLOCK)) {
                return;
            }
            for (ActionEvent actionEvent : blueprintEvents) {
                if (!actionEvent.eventType.equals((Object)CustomEvent.EventType.TILL_SOIL) || !actionEvent.checkTillSoilStartConditions()) continue;
                actionEvent.instantiateEvent(location, event.getPlayer());
            }
        }
    }
}

