/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.dungeons;

import com.magmaguy.elitemobs.config.contentpackages.ContentPackagesConfigFields;
import com.magmaguy.elitemobs.dungeons.DynamicDungeonPackage;
import com.magmaguy.elitemobs.dungeons.EventsPackage;
import com.magmaguy.elitemobs.dungeons.ItemsPackage;
import com.magmaguy.elitemobs.dungeons.MetaPackage;
import com.magmaguy.elitemobs.dungeons.ModelsPackage;
import com.magmaguy.elitemobs.dungeons.WorldDungeonPackage;
import com.magmaguy.elitemobs.dungeons.WorldInstancedDungeonPackage;
import com.magmaguy.elitemobs.dungeons.WorldPackage;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.elitemobs.npcs.NPCEntity;
import com.magmaguy.elitemobs.treasurechest.TreasureChest;
import com.magmaguy.magmacore.menus.ContentPackage;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.ItemStackGenerator;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class EMPackage
extends ContentPackage {
    protected static final HashMap<String, EMPackage> content = new HashMap();
    private static final Map<String, EMPackage> emPackages = new HashMap<String, EMPackage>();
    protected final ContentPackagesConfigFields contentPackagesConfigFields;
    protected boolean isDownloaded;
    protected boolean isInstalled;
    protected boolean outOfDate = false;
    protected List<CustomBossEntity> customBossEntityList = new ArrayList<CustomBossEntity>();
    protected List<TreasureChest> treasureChestList = new ArrayList<TreasureChest>();
    protected List<NPCEntity> npcEntities = new ArrayList<NPCEntity>();

    public EMPackage(ContentPackagesConfigFields contentPackagesConfigFields) {
        this.contentPackagesConfigFields = contentPackagesConfigFields;
        emPackages.put(contentPackagesConfigFields.getFilename(), this);
        this.baseInitialization();
    }

    public static EMPackage getContent(String data) {
        return content.get(data);
    }

    public static void shutdown() {
        content.clear();
        emPackages.clear();
    }

    public static void initialize(ContentPackagesConfigFields contentPackagesConfigFields) {
        if (contentPackagesConfigFields.getContentType() != null) {
            switch (contentPackagesConfigFields.getContentType()) {
                case INSTANCED_DUNGEON: {
                    new WorldInstancedDungeonPackage(contentPackagesConfigFields);
                    break;
                }
                case DYNAMIC_DUNGEON: {
                    new DynamicDungeonPackage(contentPackagesConfigFields);
                    break;
                }
                case OPEN_DUNGEON: {
                    new WorldDungeonPackage(contentPackagesConfigFields);
                    break;
                }
                case HUB: {
                    new WorldPackage(contentPackagesConfigFields);
                    break;
                }
                case SCHEMATIC_DUNGEON: {
                    Logger.warn("Tried to load schematic dungeon " + contentPackagesConfigFields.getFilename() + "! This will not work because schematic dungeons have been removed as of EliteMobs 9.0 and replaced with world dungeons. If you want the schematic dungeon experience, I recommend you use BetterStructures with the elite shrines packages, which work better than schematics ever could. Fix this by deleting it from the dungeonpackager file.");
                    break;
                }
                case META_PACKAGE: {
                    new MetaPackage(contentPackagesConfigFields);
                    break;
                }
                case ITEMS_PACKAGE: {
                    new ItemsPackage(contentPackagesConfigFields);
                    break;
                }
                case EVENTS_PACKAGE: {
                    new EventsPackage(contentPackagesConfigFields);
                    break;
                }
                case MODELS_PACKAGE: {
                    new ModelsPackage(contentPackagesConfigFields);
                }
            }
        }
    }

    public void setupMenuToggle(Player player) {
        if (this.isInstalled) {
            this.doUninstall(player);
            return;
        }
        if (this.isDownloaded) {
            this.doInstall(player);
            return;
        }
        this.doDownload(player);
    }

    @Override
    protected ItemStack getInstalledItemStack() {
        return this.generateItemStack(List.of("Content is installed!", "Click to uninstall!"), Material.GREEN_STAINED_GLASS_PANE);
    }

    @Override
    protected ItemStack getNotInstalledItemStack() {
        return this.generateItemStack(List.of("Content is not installed!", "Click to install!"), Material.YELLOW_STAINED_GLASS_PANE);
    }

    @Override
    protected ItemStack getPartiallyInstalledItemStack() {
        return this.generateItemStack(List.of("Content partially installed!", "This is either because you haven't downloaded all of it,", "or because some elements have been manually disabled.", "Click to download!"), Material.ORANGE_STAINED_GLASS_PANE);
    }

    @Override
    protected ItemStack getNotDownloadedItemStack() {
        return this.generateItemStack(List.of("Content is not downloaded!", "Click for download link!"), Material.RED_STAINED_GLASS_PANE);
    }

    private ItemStack generateItemStack(List<String> specificTooltip, Material material) {
        ArrayList<String> tooltip = new ArrayList<String>(specificTooltip);
        tooltip.addAll(this.contentPackagesConfigFields.getSetupMenuDescription());
        ItemStack itemStack = ItemStackGenerator.generateItemStack(material, this.contentPackagesConfigFields.getName(), tooltip);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    @Override
    public abstract void doInstall(Player var1);

    @Override
    public abstract void doUninstall(Player var1);

    @Override
    public void doDownload(Player player) {
        player.sendMessage("----------------------------------------------------");
        player.sendMessage(ChatColorConverter.convert("&4Download this at &9" + this.getContentPackagesConfigFields().getDownloadLink() + " &4!"));
        player.sendMessage("----------------------------------------------------");
    }

    @Override
    protected ContentPackage.ContentState getContentState() {
        if (this.isInstalled) {
            return ContentPackage.ContentState.INSTALLED;
        }
        if (this.isDownloaded) {
            return ContentPackage.ContentState.NOT_INSTALLED;
        }
        return ContentPackage.ContentState.NOT_DOWNLOADED;
    }

    public boolean isOutOfDate() {
        if (!this.isInstalled) {
            return false;
        }
        return this.outOfDate;
    }

    public abstract void baseInitialization();

    public abstract void initializeContent();

    @Generated
    public static Map<String, EMPackage> getEmPackages() {
        return emPackages;
    }

    @Generated
    public ContentPackagesConfigFields getContentPackagesConfigFields() {
        return this.contentPackagesConfigFields;
    }

    @Generated
    public boolean isDownloaded() {
        return this.isDownloaded;
    }

    @Generated
    public void setDownloaded(boolean isDownloaded) {
        this.isDownloaded = isDownloaded;
    }

    @Generated
    public boolean isInstalled() {
        return this.isInstalled;
    }

    @Generated
    public void setInstalled(boolean isInstalled) {
        this.isInstalled = isInstalled;
    }

    @Generated
    public void setOutOfDate(boolean outOfDate) {
        this.outOfDate = outOfDate;
    }

    @Generated
    public List<CustomBossEntity> getCustomBossEntityList() {
        return this.customBossEntityList;
    }
}

