/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.config;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.magmacore.util.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ConfigurationExporter {
    private static final String RSP_RESOURCE_PATH = "em_rsp_defaults";
    private static final String CHECKSUM_FILE = ".rsp_checksum";

    private ConfigurationExporter() {
    }

    public static void initializeConfigs() {
        new BukkitRunnable(){

            public void run() {
                Path pluginFolder = Paths.get(MetadataHandler.PLUGIN.getDataFolder().getAbsolutePath(), new String[0]);
                Path exportsPath = pluginFolder.resolve("resource_pack");
                if (!Files.isDirectory(exportsPath, new LinkOption[0])) {
                    try {
                        Files.createDirectories(exportsPath, new FileAttribute[0]);
                    }
                    catch (Exception exception) {
                        Logger.warn("Failed to create exports directory! Tell the dev!");
                        exception.printStackTrace();
                        return;
                    }
                }
                try {
                    ConfigurationExporter.exportResourcePack(exportsPath);
                }
                catch (Exception e) {
                    Logger.warn("Failed to export resource pack! Tell the dev!");
                    e.printStackTrace();
                }
            }
        }.runTaskAsynchronously((Plugin)MetadataHandler.PLUGIN);
    }

    private static void exportResourcePack(Path exportsPath) throws IOException {
        Path targetPath = exportsPath.resolve(RSP_RESOURCE_PATH);
        Path checksumFile = exportsPath.resolve(CHECKSUM_FILE);
        String jarChecksum = ConfigurationExporter.calculateJarResourceChecksum();
        if (jarChecksum == null) {
            Logger.warn("Could not calculate resource pack checksum from jar!");
            return;
        }
        boolean needsCopy = true;
        if (Files.exists(checksumFile, new LinkOption[0]) && Files.isDirectory(targetPath, new LinkOption[0])) {
            try {
                String existingChecksum = Files.readString(checksumFile).trim();
                if (existingChecksum.equals(jarChecksum)) {
                    needsCopy = false;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!needsCopy) {
            return;
        }
        if (Files.exists(targetPath, new LinkOption[0])) {
            ConfigurationExporter.clearDirectoryContents(targetPath);
        } else {
            Files.createDirectories(targetPath, new FileAttribute[0]);
        }
        ConfigurationExporter.copyResourceFolder(RSP_RESOURCE_PATH, targetPath);
        Files.writeString(checksumFile, (CharSequence)jarChecksum, new OpenOption[0]);
        Logger.info("Resource pack exported to resource_pack folder.");
    }

    private static String calculateJarResourceChecksum() {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            URL resourceUrl = MetadataHandler.PLUGIN.getClass().getClassLoader().getResource(RSP_RESOURCE_PATH);
            if (resourceUrl == null) {
                return null;
            }
            if (resourceUrl.getProtocol().equals("jar")) {
                JarURLConnection jarConnection = (JarURLConnection)resourceUrl.openConnection();
                try (JarFile jarFile = jarConnection.getJarFile();){
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        if (!entry.getName().startsWith(RSP_RESOURCE_PATH) || entry.isDirectory()) continue;
                        digest.update(entry.getName().getBytes());
                        digest.update(Long.toString(entry.getSize()).getBytes());
                    }
                }
            } else {
                Path resourcePath = Paths.get(resourceUrl.toURI());
                Files.walk(resourcePath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).sorted().forEach(path -> {
                    try {
                        digest.update(path.toString().getBytes());
                        digest.update(Long.toString(Files.size(path)).getBytes());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
            }
            byte[] hashBytes = digest.digest();
            StringBuilder sb = new StringBuilder();
            for (byte b : hashBytes) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        catch (Exception e) {
            Logger.warn("Error calculating jar resource checksum: " + e.getMessage());
            return null;
        }
    }

    private static void copyResourceFolder(String resourcePath, Path targetPath) throws IOException {
        URL resourceUrl = MetadataHandler.PLUGIN.getClass().getClassLoader().getResource(resourcePath);
        if (resourceUrl == null) {
            Logger.warn("Resource folder not found: " + resourcePath);
            return;
        }
        if (resourceUrl.getProtocol().equals("jar")) {
            JarURLConnection jarConnection = (JarURLConnection)resourceUrl.openConnection();
            try (JarFile jarFile = jarConnection.getJarFile();){
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    String relativePath;
                    JarEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    if (!entryName.startsWith(resourcePath + "/") || (relativePath = entryName.substring(resourcePath.length() + 1)).isEmpty()) continue;
                    Path targetFile = targetPath.resolve(relativePath);
                    if (entry.isDirectory()) {
                        Files.createDirectories(targetFile, new FileAttribute[0]);
                        continue;
                    }
                    Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
                    InputStream is = jarFile.getInputStream(entry);
                    try {
                        Files.copy(is, targetFile, StandardCopyOption.REPLACE_EXISTING);
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
            }
        }
        try {
            Path sourcePath = Paths.get(resourceUrl.toURI());
            ConfigurationExporter.copyDirectory(sourcePath, targetPath);
        }
        catch (Exception e) {
            Logger.warn("Failed to copy resource folder from IDE: " + e.getMessage());
        }
    }

    private static void copyDirectory(Path source, Path target) throws IOException {
        Files.walk(source, new FileVisitOption[0]).forEach(sourcePath -> {
            try {
                Path targetFile = target.resolve(source.relativize((Path)sourcePath));
                if (Files.isDirectory(sourcePath, new LinkOption[0])) {
                    Files.createDirectories(targetFile, new FileAttribute[0]);
                } else {
                    Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
                    Files.copy(sourcePath, targetFile, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static void clearDirectoryContents(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            Files.walk(path, new FileVisitOption[0]).sorted((a, b) -> b.compareTo((Path)a)).filter(p -> !p.equals(path)).forEach(p -> {
                try {
                    Files.delete(p);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
    }

    public static byte[] sha1CodeByteArray(File file) throws IOException, NoSuchAlgorithmException {
        FileInputStream fileInputStream = new FileInputStream(file);
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        DigestInputStream digestInputStream = new DigestInputStream(fileInputStream, digest);
        byte[] bytes = new byte[1024];
        while (digestInputStream.read(bytes) > 0) {
            digest = digestInputStream.getMessageDigest();
        }
        fileInputStream.close();
        return digest.digest();
    }
}

