/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.utils.shapes;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.utils.Lerp;
import com.magmaguy.elitemobs.utils.shapes.Ray;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class RotatingRay
extends Ray {
    private final int animationDuration;
    private final Location originalCenterLocation;
    private final Location target2;
    private final Vector raySegment;
    private final double distanceSquared;

    public RotatingRay(boolean ignoresSolidBlocks, double pointRadius, Location target, Location target2, double pitchPreRotation, double yawPreRotation, double pitchRotation, double yawRotation, int animationDuration) {
        super(ignoresSolidBlocks, pointRadius, target, target2);
        this.originalCenterLocation = target.clone();
        this.target2 = target2;
        this.animationDuration = animationDuration;
        this.raySegment = target2.clone().subtract(target).toVector().normalize().multiply(pointRadius * 2.0);
        if (yawPreRotation != 0.0) {
            this.raySegment.rotateAroundY(Math.toRadians(yawPreRotation));
        }
        if (pitchPreRotation != 0.0) {
            Vector perpendicularVector = this.raySegment.clone().rotateAroundY(Math.toRadians(90.0));
            this.raySegment.rotateAroundAxis(perpendicularVector, Math.toRadians(pitchPreRotation));
        }
        this.locations = this.drawLine(this.originalCenterLocation, target2);
        this.distanceSquared = target.distanceSquared(target2);
        if (animationDuration > 0) {
            this.startRotating(animationDuration, pitchRotation, yawRotation);
        }
    }

    @Override
    protected List<Location> drawLine(Location location1, Location location2) {
        this.currentSource = location1;
        this.currentTarget = location2;
        ArrayList<Location> locations = new ArrayList<Location>();
        Location currentLocation = this.originalCenterLocation.clone();
        locations.add(this.originalCenterLocation);
        int i = 0;
        while ((double)i < 500.0) {
            currentLocation.add(this.raySegment);
            if (this.originalCenterLocation.distanceSquared(currentLocation) > this.distanceSquared || !this.ignoresSolidBlocks && currentLocation.getBlock().getType().isSolid()) break;
            locations.add(currentLocation.clone());
            ++i;
        }
        return locations;
    }

    private void startRotating(int totalTickDuration, double pitchRotation, double yawRotation) {
        final double singleTickPitchRotation = pitchRotation != 0.0 ? pitchRotation / (double)totalTickDuration : 0.0;
        final double singleTickYawRotation = yawRotation != 0.0 ? yawRotation / (double)totalTickDuration : 0.0;
        final Vector perpendicularVector = this.raySegment.clone().setY(0).normalize().rotateAroundY(Math.toRadians(90.0));
        new BukkitRunnable(){
            private int counter = 1;

            public void run() {
                if (this.counter > RotatingRay.this.animationDuration) {
                    this.cancel();
                    return;
                }
                ++this.counter;
                if (RotatingRay.this.target2 != null) {
                    RotatingRay.this.centerLocation = Lerp.lerpLocation(RotatingRay.this.originalCenterLocation, RotatingRay.this.target2, (double)this.counter / (double)RotatingRay.this.animationDuration);
                }
                if (singleTickPitchRotation > 0.0) {
                    RotatingRay.this.raySegment.rotateAroundAxis(perpendicularVector, Math.toRadians(singleTickPitchRotation));
                }
                if (singleTickYawRotation > 0.0) {
                    RotatingRay.this.raySegment.rotateAroundY(Math.toRadians(singleTickYawRotation));
                }
                RotatingRay.this.locations = RotatingRay.this.drawLine(RotatingRay.this.centerLocation, RotatingRay.this.target2);
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 1L, 1L);
    }
}

