/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.utils;

import com.google.common.collect.ArrayListMultimap;
import com.magmaguy.elitemobs.playerdata.PlayerItem;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;

public class BossBarUtil {
    public static HashSet<BossBar> bossBars = new HashSet();
    public static ArrayListMultimap<UUID, PlayerBrokenItemBar> brokenPlayerItem = ArrayListMultimap.create();

    private BossBarUtil() {
    }

    public static void shutdown() {
        bossBars.forEach(BossBar::removeAll);
        bossBars.clear();
        brokenPlayerItem.clear();
    }

    public static void DisplayBrokenItemBossBar(PlayerItem.EquipmentSlot equipmentSlot, Player player, String title) {
        UUID playerUUID = player.getUniqueId();
        List arrayList = brokenPlayerItem.get((Object)playerUUID);
        boolean alreadyExists = false;
        for (PlayerBrokenItemBar playerBrokenItemBar : arrayList) {
            if (!playerBrokenItemBar.getEquipmentSlot().equals((Object)equipmentSlot)) continue;
            alreadyExists = true;
            break;
        }
        if (!alreadyExists) {
            brokenPlayerItem.put((Object)playerUUID, (Object)new PlayerBrokenItemBar(equipmentSlot, player, title, BarColor.RED, BarStyle.SOLID));
        }
    }

    public static void HideBrokenItemBossBar(PlayerItem.EquipmentSlot equipmentSlot, Player player) {
        UUID playerUUID = player.getUniqueId();
        List arrayList = brokenPlayerItem.get((Object)playerUUID);
        PlayerBrokenItemBar storedPlayerBrokenItemBar = null;
        for (PlayerBrokenItemBar playerBrokenItemBar : arrayList) {
            if (!playerBrokenItemBar.getEquipmentSlot().equals((Object)equipmentSlot)) continue;
            storedPlayerBrokenItemBar = playerBrokenItemBar;
            BossBarUtil.DestroyBossBar(playerBrokenItemBar.bossBar);
            break;
        }
        brokenPlayerItem.remove((Object)playerUUID, storedPlayerBrokenItemBar);
    }

    private static BossBar CreateBossBar(Player player, String title, BarColor barColor, BarStyle barStyle) {
        BossBar bossBar = Bukkit.createBossBar((String)title, (BarColor)barColor, (BarStyle)barStyle, (BarFlag[])new BarFlag[0]);
        bossBar.addPlayer(player);
        bossBars.add(bossBar);
        return bossBar;
    }

    private static void DestroyBossBar(BossBar bossBar) {
        bossBar.removeAll();
        bossBars.remove(bossBar);
    }

    private static class PlayerBrokenItemBar {
        private final PlayerItem.EquipmentSlot equipmentSlot;
        private final BossBar bossBar;

        private PlayerBrokenItemBar(PlayerItem.EquipmentSlot equipmentSlot, Player player, String title, BarColor barColor, BarStyle barStyle) {
            this.equipmentSlot = equipmentSlot;
            this.bossBar = BossBarUtil.CreateBossBar(player, title, barColor, barStyle);
        }

        @Generated
        public PlayerItem.EquipmentSlot getEquipmentSlot() {
            return this.equipmentSlot;
        }

        @Generated
        public BossBar getBossBar() {
            return this.bossBar;
        }
    }
}

