/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.quests.objectives;

import com.magmaguy.elitemobs.api.EliteMobDeathEvent;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.quests.Quest;
import com.magmaguy.elitemobs.quests.objectives.Objective;
import com.magmaguy.elitemobs.quests.objectives.QuestObjectives;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public abstract class KillObjective
extends Objective {
    protected KillObjective(int targetAmount, String objectiveName) {
        super(targetAmount, objectiveName);
    }

    public abstract void checkProgress(EliteMobDeathEvent var1, QuestObjectives var2);

    public static class KillObjectiveEvents
    implements Listener {
        @EventHandler
        public void onEliteDeath(EliteMobDeathEvent event) {
            for (Player player : event.getEliteEntity().getDamagers().keySet()) {
                if (player.hasMetadata("NPC") || !PlayerData.isInMemory(player.getUniqueId())) continue;
                for (Quest quest : PlayerData.getQuests(player.getUniqueId())) {
                    if (quest == null) continue;
                    for (Objective objective : quest.getQuestObjectives().getObjectives()) {
                        if (!(objective instanceof KillObjective)) continue;
                        ((KillObjective)objective).checkProgress(event, quest.getQuestObjectives());
                    }
                }
            }
        }
    }
}

