/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powerstances;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.powerstances.MajorPowerPowerStance;
import com.magmaguy.elitemobs.powerstances.MajorPowerStanceMath;
import com.magmaguy.elitemobs.powerstances.MinorPowerPowerStance;
import com.magmaguy.elitemobs.powerstances.MinorPowerStanceMath;
import com.magmaguy.elitemobs.powerstances.VisualItemRemover;
import java.util.Arrays;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Item;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class VisualItemProcessor {
    private boolean hasValidEffect;

    public VisualItemProcessor(Object[][] multiDimensionalTrailTracker, Vector[][] cachedVectorPositions, boolean visualEffectBoolean, int pointsPerRotation, EliteEntity eliteEntity) {
        this.hasValidEffect = visualEffectBoolean;
        if (multiDimensionalTrailTracker.length < 1) {
            return;
        }
        this.rotateExistingEffects(multiDimensionalTrailTracker, cachedVectorPositions, pointsPerRotation, eliteEntity);
    }

    public static int adjustTrackPosition(double pointsPerRotation, int totalEffectQuantity, int sectionCounter, int globalCounter) {
        int location = (int)(pointsPerRotation / (double)totalEffectQuantity * (double)sectionCounter + (double)globalCounter);
        if (location >= 30) {
            location -= 30;
        }
        return location;
    }

    private void rotateExistingEffects(final Object[][] multiDimensionalTrailTracker, final Vector[][] cachedVectorPositions, final int pointsPerRotation, final EliteEntity eliteEntity) {
        new BukkitRunnable(){
            final boolean isObfuscated;
            int counter;
            {
                this.isObfuscated = eliteEntity.isVisualEffectObfuscated();
                this.counter = 0;
            }

            public void run() {
                if (!eliteEntity.isValid() || !VisualItemProcessor.this.hasValidEffect) {
                    VisualItemRemover.removeItems(multiDimensionalTrailTracker);
                    this.cancel();
                    return;
                }
                for (int i = 0; i < multiDimensionalTrailTracker.length; ++i) {
                    int sectionCounter = 0;
                    for (int j = 0; j < multiDimensionalTrailTracker[i].length; ++j) {
                        int adjustedEffectPositionInRotation = VisualItemProcessor.adjustTrackPosition(pointsPerRotation, multiDimensionalTrailTracker[i].length, sectionCounter, this.counter);
                        Vector vector = cachedVectorPositions[i][adjustedEffectPositionInRotation];
                        if (multiDimensionalTrailTracker[i][j] instanceof Item) {
                            VisualItemProcessor.this.rotateItem(multiDimensionalTrailTracker[i][j], vector, eliteEntity);
                        }
                        if (multiDimensionalTrailTracker[i][j] instanceof Particle) {
                            VisualItemProcessor.this.rotateParticle(multiDimensionalTrailTracker[i][j], vector, eliteEntity);
                        }
                        if (++sectionCounter < pointsPerRotation) continue;
                        sectionCounter = 0;
                    }
                }
                ++this.counter;
                if (this.counter >= pointsPerRotation) {
                    this.counter = 0;
                }
                if (this.isObfuscated != eliteEntity.isVisualEffectObfuscated()) {
                    VisualItemRemover.removeItems(multiDimensionalTrailTracker);
                    this.cancel();
                    new BukkitRunnable(){

                        public void run() {
                            eliteEntity.setVisualEffectObfuscated(false);
                            if (Arrays.deepEquals((Object[])cachedVectorPositions, (Object[])MinorPowerStanceMath.cachedVectors)) {
                                eliteEntity.setMinorVisualEffect(false);
                                new MinorPowerPowerStance(eliteEntity);
                            }
                            if (Arrays.deepEquals((Object[])cachedVectorPositions, (Object[])MajorPowerStanceMath.cachedVectors)) {
                                eliteEntity.setMajorVisualEffect(false);
                                new MajorPowerPowerStance(eliteEntity);
                            }
                        }
                    }.runTask((Plugin)MetadataHandler.PLUGIN);
                }
            }
        }.runTaskTimerAsynchronously((Plugin)MetadataHandler.PLUGIN, 0L, 5L);
    }

    private void rotateItem(Object itemObject, Vector vector, EliteEntity eliteEntity) {
        Item item = (Item)itemObject;
        Location currentLocation = item.getLocation().clone();
        Location newLocation = eliteEntity.getLivingEntity().getLocation().clone().add(new Vector(0, 1, 0)).add(vector);
        if (newLocation.getWorld() != currentLocation.getWorld()) {
            this.hasValidEffect = false;
            return;
        }
        Vector movementVector = newLocation.subtract(currentLocation).toVector();
        movementVector = movementVector.multiply(0.3);
        item.setVelocity(movementVector);
    }

    private void rotateParticle(Object particleObject, Vector vector, EliteEntity eliteEntity) {
        Particle particle = (Particle)particleObject;
        if (eliteEntity.isValid()) {
            eliteEntity.getLivingEntity().getWorld().spawnParticle(particle, eliteEntity.getLivingEntity().getLocation().add(0.0, 1.0, 0.0).add(vector), 1, 0.0, 0.0, 0.0, 0.01);
        }
    }
}

